/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.util.config.AnalysisScopeReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShallowAnalysisScope
implements Serializable {
    private static final long serialVersionUID = -3256390509887654321L;
    private final SetOfClasses exclusions;
    private final List<String> moduleLinesList;
    private final List<String> ldrImplLinesList;

    public ShallowAnalysisScope(SetOfClasses setOfClasses, List<String> list, List<String> list2) {
        if (list == null) {
            throw new IllegalArgumentException("null moduleLinesList");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("null ldrImplLinesList");
        }
        this.exclusions = setOfClasses;
        this.moduleLinesList = list;
        this.ldrImplLinesList = list2;
    }

    public AnalysisScope toAnalysisScope() throws IOException {
        AnalysisScope analysisScope = AnalysisScope.createJavaAnalysisScope();
        analysisScope.setExclusions(this.exclusions);
        for (String string : this.moduleLinesList) {
            AnalysisScopeReader.processScopeDefLine(analysisScope, this.getClass().getClassLoader(), string);
        }
        for (String string : this.ldrImplLinesList) {
            AnalysisScopeReader.processScopeDefLine(analysisScope, this.getClass().getClassLoader(), string);
        }
        return analysisScope;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.moduleLinesList) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

