/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.classLoader.ArrayClassLoader;
import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.ClassFileModule;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.ipa.callgraph.ShallowAnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.PlatformUtil;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisScope {
    private static final int DEBUG_LEVEL = 0;
    public static final Atom PRIMORDIAL = Atom.findOrCreateUnicodeAtom("Primordial");
    public static final Atom EXTENSION = Atom.findOrCreateUnicodeAtom("Extension");
    public static final Atom APPLICATION = Atom.findOrCreateUnicodeAtom("Application");
    public static final Atom SYNTHETIC = Atom.findOrCreateUnicodeAtom("Synthetic");
    private SetOfClasses exclusions;
    protected final LinkedHashMap<Atom, ClassLoaderReference> loadersByName = new LinkedHashMap();
    private final ArrayClassLoader arrayClassLoader = new ArrayClassLoader();
    private final Map<ClassLoaderReference, List<Module>> moduleMap = HashMapFactory.make(3);
    private final Map<Atom, Language> languages;
    private final HashMap<ClassLoaderReference, String> loaderImplByRef = HashMapFactory.make();

    public static AnalysisScope createJavaAnalysisScope() {
        AnalysisScope analysisScope = new AnalysisScope(Collections.singleton(Language.JAVA));
        analysisScope.initForJava();
        return analysisScope;
    }

    protected void initForJava() {
        this.initCoreForJava();
        this.initSynthetic(this.loadersByName.get(APPLICATION));
    }

    protected void initCoreForJava() {
        ClassLoaderReference classLoaderReference = new ClassLoaderReference(PRIMORDIAL, ClassLoaderReference.Java, null);
        ClassLoaderReference classLoaderReference2 = new ClassLoaderReference(EXTENSION, ClassLoaderReference.Java, classLoaderReference);
        ClassLoaderReference classLoaderReference3 = new ClassLoaderReference(APPLICATION, ClassLoaderReference.Java, classLoaderReference2);
        this.loadersByName.put(PRIMORDIAL, classLoaderReference);
        this.loadersByName.put(EXTENSION, classLoaderReference2);
        this.loadersByName.put(APPLICATION, classLoaderReference3);
    }

    protected void initSynthetic(ClassLoaderReference classLoaderReference) {
        ClassLoaderReference classLoaderReference2 = new ClassLoaderReference(SYNTHETIC, ClassLoaderReference.Java, classLoaderReference);
        this.setLoaderImpl(classLoaderReference2, "com.ibm.wala.ipa.summaries.BypassSyntheticClassLoader");
        this.loadersByName.put(SYNTHETIC, classLoaderReference2);
    }

    protected AnalysisScope(Collection<? extends Language> collection) {
        this.languages = new HashMap<Atom, Language>();
        for (Language language : collection) {
            this.languages.put(language.getName(), language);
        }
    }

    public Language getLanguage(Atom atom) {
        return this.languages.get(atom);
    }

    public boolean isApplicationLoader(IClassLoader iClassLoader) {
        return iClassLoader.getReference().equals(this.getLoader(APPLICATION));
    }

    public ClassLoaderReference getPrimordialLoader() {
        return this.getLoader(PRIMORDIAL);
    }

    public ClassLoaderReference getExtensionLoader() {
        return this.getLoader(EXTENSION);
    }

    public ClassLoaderReference getApplicationLoader() {
        return this.getLoader(APPLICATION);
    }

    public ClassLoaderReference getSyntheticLoader() {
        return this.getLoader(SYNTHETIC);
    }

    public Collection<Language> getLanguages() {
        return this.languages.values();
    }

    public Set<Language> getBaseLanguages() {
        HashSet<Language> hashSet = HashSetFactory.make();
        for (Language language : this.getLanguages()) {
            if (language.getBaseLanguage() != null) continue;
            hashSet.add(language);
        }
        return hashSet;
    }

    public void addSourceFileToScope(ClassLoaderReference classLoaderReference, File file, String string) throws IllegalArgumentException {
        List<Module> list = MapUtil.findOrCreateList(this.moduleMap, classLoaderReference);
        list.add(new SourceFileModule(file, string));
    }

    public void addClassFileToScope(ClassLoaderReference classLoaderReference, File file) throws IllegalArgumentException {
        List<Module> list = MapUtil.findOrCreateList(this.moduleMap, classLoaderReference);
        list.add(new ClassFileModule(file));
    }

    public void addToScope(ClassLoaderReference classLoaderReference, JarFile jarFile) {
        List<Module> list = MapUtil.findOrCreateList(this.moduleMap, classLoaderReference);
        list.add(new JarFileModule(jarFile));
    }

    public void addToScope(ClassLoaderReference classLoaderReference, Module module) {
        if (module == null) {
            throw new IllegalArgumentException("null m");
        }
        List<Module> list = MapUtil.findOrCreateList(this.moduleMap, classLoaderReference);
        list.add(module);
    }

    public void addToScope(AnalysisScope analysisScope) {
        if (analysisScope == null) {
            throw new IllegalArgumentException("null other");
        }
        for (ClassLoaderReference classLoaderReference : analysisScope.getLoaders()) {
            for (Module module : analysisScope.getModules(classLoaderReference)) {
                this.addToScope(classLoaderReference, module);
            }
        }
    }

    public void addToScopeHead(ClassLoaderReference classLoaderReference, Module module) {
        if (module == null) {
            throw new IllegalArgumentException("null m");
        }
        List<Module> list = MapUtil.findOrCreateList(this.moduleMap, classLoaderReference);
        list.add(0, module);
    }

    public ClassLoaderReference getLoader(Atom atom) throws IllegalArgumentException {
        if (atom == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (atom.length() == 0) {
            throw new IllegalArgumentException("empty atom is not a legal class loader name");
        }
        return this.loadersByName.get(atom);
    }

    protected ClassLoaderReference classLoaderName2Ref(String string) {
        return this.getLoader(Atom.findOrCreateUnicodeAtom(string));
    }

    public String getLoaderImpl(ClassLoaderReference classLoaderReference) {
        return this.loaderImplByRef.get(classLoaderReference);
    }

    public void setLoaderImpl(ClassLoaderReference classLoaderReference, String string) {
        if (classLoaderReference == null) {
            throw new IllegalArgumentException("null ref");
        }
        if (string == null) {
            throw new IllegalArgumentException("null implClass");
        }
        this.loaderImplByRef.put(classLoaderReference, string);
    }

    public Collection<ClassLoaderReference> getLoaders() {
        return Collections.unmodifiableCollection(this.loadersByName.values());
    }

    public int getNumberOfLoaders() {
        return this.loadersByName.values().size();
    }

    public SetOfClasses getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(SetOfClasses setOfClasses) {
        this.exclusions = setOfClasses;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (ClassLoaderReference classLoaderReference : this.loadersByName.values()) {
            stringBuffer.append(classLoaderReference.getName());
            stringBuffer.append("\n");
            for (Module module : this.getModules(classLoaderReference)) {
                stringBuffer.append(" ");
                stringBuffer.append(module);
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append(this.getExclusionString());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected Object getExclusionString() {
        return "Exclusions: " + this.exclusions;
    }

    public MethodReference findMethod(Atom atom, String string, Atom atom2, ImmutableByteArray immutableByteArray) {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("null desc");
        }
        ClassLoaderReference classLoaderReference = this.getLoader(atom);
        Descriptor descriptor = Descriptor.findOrCreate(this.languages.get(classLoaderReference.getLanguage()), immutableByteArray);
        TypeReference typeReference = TypeReference.findOrCreate(classLoaderReference, TypeName.string2TypeName(string));
        return MethodReference.findOrCreate(typeReference, atom2, descriptor);
    }

    public List<Module> getModules(ClassLoaderReference classLoaderReference) {
        List<Module> list = this.moduleMap.get(classLoaderReference);
        List list2 = Collections.emptyList();
        return list == null ? list2 : list;
    }

    public ArrayClassLoader getArrayClassLoader() {
        return this.arrayClassLoader;
    }

    private JarFile getRtJar() {
        for (Module module : this.getModules(this.getPrimordialLoader())) {
            if (!(module instanceof JarFileModule)) continue;
            JarFile jarFile = ((JarFileModule)module).getJarFile();
            if (jarFile.getName().endsWith(String.valueOf(File.separator) + "rt.jar")) {
                return jarFile;
            }
            if (jarFile.getName().endsWith(String.valueOf(File.separator) + "core.jar")) {
                return jarFile;
            }
            if (!PlatformUtil.onMacOSX() || !jarFile.getName().endsWith(String.valueOf(File.separator) + "classes.jar")) continue;
            return jarFile;
        }
        return null;
    }

    public String getJavaLibraryVersion() throws IllegalStateException {
        JarFile jarFile = this.getRtJar();
        if (jarFile == null) {
            throw new IllegalStateException("cannot find runtime libraries");
        }
        try {
            Manifest manifest = jarFile.getManifest();
            assert (manifest != null) : "runtime library has no manifest!";
            String string = manifest.getMainAttributes().getValue("Specification-Version");
            if (string == null) {
                Attributes attributes = manifest.getMainAttributes();
                System.err.println("main attributes:" + attributes);
                Assertions.UNREACHABLE("Manifest for " + jarFile.getName() + " has no value for Specification-Version");
            }
            return string;
        }
        catch (IOException iOException) {
            Assertions.UNREACHABLE("error getting rt.jar manifest!");
            return null;
        }
    }

    public boolean isJava16Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.6");
    }

    public boolean isJava15Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.5");
    }

    public boolean isJava14Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.4");
    }

    public ShallowAnalysisScope toShallowAnalysisScope() throws NotSerializableException {
        String string;
        String string2;
        Object object;
        if (this.getArrayClassLoader().getNumberOfClasses() != 0) {
            throw new NotSerializableException("Scope was already used for building array classes");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<ClassLoaderReference, List<Module>> entry : this.moduleMap.entrySet()) {
            ClassLoaderReference classLoaderReference = entry.getKey();
            object = classLoaderReference.getName().toString();
            string2 = classLoaderReference.getLanguage().toString();
            assert (Language.JAVA.getName().equals(classLoaderReference.getLanguage())) : "Java language only is currently supported";
            for (Object object2 : entry.getValue()) {
                String string3;
                if (object2 instanceof JarFileModule) {
                    string = "jarFile";
                    string3 = ((JarFileModule)object2).getAbsolutePath();
                } else if (object2 instanceof BinaryDirectoryTreeModule) {
                    string = "binaryDir";
                    string3 = ((BinaryDirectoryTreeModule)object2).getPath();
                } else if (object2 instanceof SourceDirectoryTreeModule) {
                    string = "sourceDir";
                    string3 = ((SourceDirectoryTreeModule)object2).getPath();
                } else if (object2 instanceof SourceFileModule) {
                    string = "sourceFile";
                    string3 = ((SourceFileModule)object2).getAbsolutePath();
                } else {
                    Assertions.UNREACHABLE("Module type isn't supported - " + object2);
                    continue;
                }
                string3.replace("\\", "/");
                String string4 = String.format("%s,%s,%s,%s", object, string2, string, string3);
                arrayList.add(string4);
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Map.Entry entry : this.loaderImplByRef.entrySet()) {
            Object object2;
            object = (ClassLoaderReference)entry.getKey();
            string2 = ((ClassLoaderReference)object).getName().toString();
            object2 = ((ClassLoaderReference)object).getLanguage().toString();
            assert (Language.JAVA.getName().equals(((ClassLoaderReference)object).getLanguage())) : "Java language only is currently supported";
            String string5 = (String)entry.getValue();
            string = String.format("%s,%s,%s,%s", string2, object2, "loaderImpl", string5);
            arrayList2.add(string);
        }
        ShallowAnalysisScope shallowAnalysisScope = new ShallowAnalysisScope(this.getExclusions(), arrayList, arrayList2);
        return shallowAnalysisScope;
    }
}

