/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.DefaultIRFactory;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSACache;
import com.ibm.wala.util.ref.ReferenceCleanser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisCache {
    private final IRFactory<IMethod> irFactory;
    private final SSACache ssaCache;

    public AnalysisCache(IRFactory<IMethod> iRFactory) {
        this.irFactory = iRFactory;
        this.ssaCache = new SSACache(iRFactory);
        ReferenceCleanser.registerCache(this);
    }

    public AnalysisCache() {
        this(new DefaultIRFactory());
    }

    public void invalidate(IMethod iMethod, Context context) {
        this.ssaCache.invalidate(iMethod, context);
    }

    public SSACache getSSACache() {
        return this.ssaCache;
    }

    public IRFactory<IMethod> getIRFactory() {
        return this.irFactory;
    }

    public IR getIR(IMethod iMethod) {
        if (iMethod == null) {
            throw new IllegalArgumentException("method is null");
        }
        return this.ssaCache.findOrCreateIR(iMethod, Everywhere.EVERYWHERE, new AnalysisOptions().getSSAOptions());
    }

    public DefUse getDefUse(IR iR) {
        if (iR == null) {
            throw new IllegalArgumentException("ir is null");
        }
        return this.ssaCache.findOrCreateDU(iR, Everywhere.EVERYWHERE);
    }
}

