/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.fixedpoint.impl;

import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixpoint.IVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralStatement<T extends IVariable>
extends AbstractStatement<T, AbstractOperator<T>> {
    protected final T lhs;
    protected final IVariable[] rhs;
    private final int hashCode;
    private final AbstractOperator<T> operator;
    private static final int[] primes = new int[]{331, 337, 347, 1277};

    @Override
    public byte evaluate() {
        return this.operator.evaluate(this.lhs, this.rhs);
    }

    @Override
    public T getLHS() {
        return this.lhs;
    }

    @Override
    public boolean hasVariable(IVariable iVariable) {
        if (this.lhs == iVariable) {
            return true;
        }
        int n = 0;
        while (n < this.rhs.length) {
            if (this.rhs[n] == iVariable) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public GeneralStatement(T t, AbstractOperator<T> abstractOperator) {
        if (abstractOperator == null) {
            throw new IllegalArgumentException("null operator");
        }
        this.operator = abstractOperator;
        this.lhs = t;
        this.rhs = null;
        this.hashCode = this.makeHashCode();
    }

    public GeneralStatement(T t, AbstractOperator<T> abstractOperator, T t2, T t3) {
        if (abstractOperator == null) {
            throw new IllegalArgumentException("null operator");
        }
        this.operator = abstractOperator;
        this.lhs = t;
        this.rhs = new IVariable[2];
        this.rhs[0] = t2;
        this.rhs[1] = t3;
        this.hashCode = this.makeHashCode();
    }

    public GeneralStatement(T t, AbstractOperator<T> abstractOperator, T t2, T t3, T t4) {
        if (abstractOperator == null) {
            throw new IllegalArgumentException("null operator");
        }
        this.operator = abstractOperator;
        this.rhs = new IVariable[3];
        this.lhs = t;
        this.rhs[0] = t2;
        this.rhs[1] = t3;
        this.rhs[2] = t4;
        this.hashCode = this.makeHashCode();
    }

    public GeneralStatement(T t, AbstractOperator<T> abstractOperator, IVariable[] iVariableArray) {
        if (abstractOperator == null) {
            throw new IllegalArgumentException("null operator");
        }
        if (iVariableArray == null) {
            throw new IllegalArgumentException("rhs is null");
        }
        this.operator = abstractOperator;
        this.lhs = t;
        this.rhs = (IVariable[])iVariableArray.clone();
        this.hashCode = this.makeHashCode();
    }

    private int makeHashCode() {
        int n = this.operator.hashCode();
        if (this.lhs != null) {
            n += this.lhs.hashCode() * primes[0];
        }
        int n2 = 0;
        while (n2 < Math.min(this.rhs.length, 2)) {
            if (this.rhs[n2] != null) {
                n += primes[n2 + 1] * this.rhs[n2].hashCode();
            }
            ++n2;
        }
        return n;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass().equals(object.getClass())) {
            GeneralStatement generalStatement = (GeneralStatement)object;
            if (this.hashCode == generalStatement.hashCode) {
                if (this.lhs == null || generalStatement.lhs == null ? generalStatement.lhs != this.lhs : !this.lhs.equals(generalStatement.lhs)) {
                    return false;
                }
                if (this.operator.equals(generalStatement.operator) && this.rhs.length == generalStatement.rhs.length) {
                    int n = 0;
                    while (n < this.rhs.length) {
                        if (this.rhs[n] == null || generalStatement.rhs[n] == null ? generalStatement.rhs[n] != this.rhs[n] : !this.rhs[n].equals(generalStatement.rhs[n])) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public AbstractOperator<T> getOperator() {
        return this.operator;
    }

    @Override
    public IVariable[] getRHS() {
        return this.rhs;
    }
}

