/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dynamic;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.Logger;

public abstract class Launcher {
    protected File workingDir = null;
    protected Map env = null;
    protected byte[] stdOut = null;
    protected byte[] stdErr = null;
    private byte[] input = null;
    private final boolean captureOutput;
    private final boolean captureErr;
    private final Logger logger;

    protected Launcher(Logger logger) {
        this.captureOutput = false;
        this.captureErr = false;
        this.logger = logger;
    }

    protected Launcher(boolean bl, boolean bl2, Logger logger) {
        this.captureOutput = bl;
        this.captureErr = true;
        this.logger = logger;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File file) {
        this.workingDir = file;
    }

    public Map getEnv() {
        return this.env;
    }

    public void setEnv(Map map) {
        this.env = map;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (workingDir: ");
        stringBuffer.append(this.workingDir);
        stringBuffer.append(", env: ");
        stringBuffer.append(this.env);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected Process spawnProcess(String string) throws IllegalArgumentException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("cmd cannot be null");
        }
        if (this.logger != null) {
            this.logger.fine("spawning process " + string);
        }
        String[] stringArray = this.getEnv() == null ? null : this.buildEnv(this.getEnv());
        Process process = Runtime.getRuntime().exec(string, stringArray, this.getWorkingDir());
        return process;
    }

    private String[] buildEnv(Map map) {
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            stringArray[n++] = entry.getKey() + "=" + entry.getValue();
        }
        return stringArray;
    }

    protected Thread drainStdOut(Process process) {
        final BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        Drainer drainer = new Drainer(process){

            void drain() throws IOException {
                Launcher.this.drainAndPrint(bufferedInputStream, System.out);
            }
        };
        drainer.start();
        return drainer;
    }

    protected Drainer captureStdOut(Process process) {
        final BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Drainer drainer = new Drainer(process){

            void drain() throws IOException {
                Launcher.this.drainAndCatch(bufferedInputStream, byteArrayOutputStream);
            }
        };
        drainer.setCapture(byteArrayOutputStream);
        drainer.start();
        return drainer;
    }

    protected Thread drainStdErr(Process process) {
        final BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getErrorStream());
        Drainer drainer = new Drainer(process){

            void drain() throws IOException {
                Launcher.this.drainAndPrint(bufferedInputStream, System.err);
            }
        };
        drainer.start();
        return drainer;
    }

    protected Drainer captureStdErr(Process process) {
        final BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getErrorStream());
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Drainer drainer = new Drainer(process){

            void drain() throws IOException {
                Launcher.this.drainAndCatch(bufferedInputStream, byteArrayOutputStream);
            }
        };
        drainer.setCapture(byteArrayOutputStream);
        drainer.start();
        return drainer;
    }

    private void drainAndPrint(BufferedInputStream bufferedInputStream, PrintStream printStream) throws IOException {
        try {
            while (bufferedInputStream.available() > 0) {
                byte[] byArray = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(byArray);
                printStream.print(new String(byArray));
            }
        }
        catch (IOException iOException) {}
    }

    private void drainAndCatch(BufferedInputStream bufferedInputStream, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        try {
            while (bufferedInputStream.available() > 0) {
                byte[] byArray = new byte[bufferedInputStream.available()];
                int n = bufferedInputStream.read(byArray);
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {}
    }

    public boolean isCaptureOutput() {
        return this.captureOutput;
    }

    public boolean isCaptureErr() {
        return this.captureErr;
    }

    public byte[] getStdOut() {
        return this.stdOut;
    }

    public byte[] getStderr() {
        return this.stdErr;
    }

    protected void setStdOut(byte[] byArray) {
        this.stdOut = byArray;
    }

    protected void setStdErr(byte[] byArray) {
        this.stdErr = byArray;
    }

    public byte[] getInput() {
        return this.input;
    }

    public void setInput(byte[] byArray) {
        this.input = byArray;
    }

    abstract class Drainer
    extends Thread {
        private final Process p;
        private ByteArrayOutputStream capture;

        abstract void drain() throws IOException;

        Drainer(Process process) {
            this.p = process;
        }

        public void run() {
            try {
                boolean bl = true;
                while (bl) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.drain();
                    try {
                        this.p.exitValue();
                        bl = false;
                        this.drain();
                        if (Launcher.this.logger == null) continue;
                        Launcher.this.logger.fine("process terminated with exit code " + this.p.exitValue());
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        bl = true;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public ByteArrayOutputStream getCapture() {
            return this.capture;
        }

        public void setCapture(ByteArrayOutputStream byteArrayOutputStream) {
            this.capture = byteArrayOutputStream;
        }
    }
}

