/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dynamic;

import com.ibm.wala.dynamic.Launcher;
import com.ibm.wala.util.PlatformUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLauncher
extends Launcher {
    private String programArgs;
    private final String mainClass;
    private final boolean inheritClasspath;
    private boolean enableAssertions;
    private final List<String> xtraClasspath = new ArrayList<String>();
    private Thread stdOutDrain;
    private Thread stdErrDrain;
    private String javaExe;
    private String vmArgs;
    private Process lastProcess;

    public static JavaLauncher make(String string, String string2, List<String> list, Logger logger) {
        return new JavaLauncher(string, string2, true, list, false, false, logger);
    }

    public static JavaLauncher make(String string, String string2, boolean bl, List<String> list, boolean bl2, boolean bl3, Logger logger) {
        if (string2 == null) {
            throw new IllegalArgumentException("null mainClass");
        }
        return new JavaLauncher(string, string2, bl, list, bl2, bl3, logger);
    }

    private JavaLauncher(String string, String string2, boolean bl, List<String> list, boolean bl2, boolean bl3, Logger logger) {
        super(bl2, bl3, logger);
        this.programArgs = string;
        this.mainClass = string2;
        this.inheritClasspath = bl;
        if (list != null) {
            this.xtraClasspath.addAll(list);
        }
        this.javaExe = JavaLauncher.defaultJavaExe();
    }

    public String getJavaExe() {
        return this.javaExe;
    }

    public void setJavaExe(String string) {
        this.javaExe = string;
    }

    public void setProgramArgs(String string) {
        this.programArgs = string;
    }

    public String getProgramArgs() {
        return this.programArgs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<String> getXtraClassPath() {
        return this.xtraClasspath;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (programArgs: ");
        stringBuffer.append(this.programArgs);
        stringBuffer.append(", mainClass: ");
        stringBuffer.append(this.mainClass);
        stringBuffer.append(", xtraClasspath: ");
        stringBuffer.append(this.xtraClasspath);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String defaultJavaExe() {
        String string = String.valueOf(System.getProperty("java.home")) + File.separatorChar + "bin" + File.separatorChar + "java";
        return string;
    }

    public Process start() throws IllegalArgumentException, IOException {
        String string = this.makeClasspath();
        String string2 = " -Xmx800M ";
        String string3 = PlatformUtil.onMacOSX() ? " -Xrs " : "";
        String string4 = this.enableAssertions ? " -ea " : "";
        String string5 = this.getVmArgs() == null ? "" : this.getVmArgs();
        String string6 = String.valueOf(this.javaExe) + string2 + string3 + string + " " + this.makeLibPath() + " " + string4 + " " + string5 + " " + this.getMainClass() + " " + this.getProgramArgs();
        Process process = this.spawnProcess(string6);
        this.stdErrDrain = this.isCaptureErr() ? this.captureStdErr(process) : this.drainStdErr(process);
        this.stdOutDrain = this.isCaptureOutput() ? this.captureStdOut(process) : this.drainStdOut(process);
        this.lastProcess = process;
        return process;
    }

    public Process getLastProcess() {
        return this.lastProcess;
    }

    private String makeLibPath() {
        String string = System.getProperty("java.library.path");
        if (string == null) {
            return "";
        }
        return "-Djava.library.path=" + string;
    }

    public void join() {
        Launcher.Drainer drainer;
        if (this.stdOutDrain == null || this.stdErrDrain == null) {
            throw new IllegalStateException("process not started.  illegal to join()");
        }
        try {
            this.stdOutDrain.join();
            this.stdErrDrain.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new InternalError("Internal error in JavaLauncher.join()");
        }
        if (this.isCaptureErr()) {
            drainer = (Launcher.Drainer)this.stdErrDrain;
            this.setStdErr(drainer.getCapture().toByteArray());
        }
        if (this.isCaptureOutput()) {
            drainer = (Launcher.Drainer)this.stdOutDrain;
            this.setStdOut(drainer.getCapture().toByteArray());
        }
    }

    private String makeClasspath() {
        String string;
        String string2 = string = this.inheritClasspath ? System.getProperty("java.class.path") : "";
        if (this.getXtraClassPath() == null || this.getXtraClassPath().isEmpty()) {
            return " -classpath " + JavaLauncher.quoteStringIfNeeded(string);
        }
        Iterator<String> iterator = this.getXtraClassPath().iterator();
        while (iterator.hasNext()) {
            string = String.valueOf(string) + File.pathSeparatorChar;
            string = String.valueOf(string) + iterator.next();
        }
        return " -classpath " + JavaLauncher.quoteStringIfNeeded(string);
    }

    public static String quoteStringIfNeeded(String string) {
        if ((string = string.trim()).indexOf(32) == -1) {
            return string;
        }
        if (string.charAt(string.length() - 1) == '\\' && string.charAt(string.length() - 2) != '\\') {
            string = String.valueOf(string) + '\\';
        }
        return String.valueOf('\"') + string + '\"';
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean bl) {
        this.enableAssertions = bl;
    }

    public void setVmArgs(String string) {
        this.vmArgs = string;
    }

    public String getVmArgs() {
        return this.vmArgs;
    }
}

