/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.shrike.ShrikeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMemoryAccessMap
implements MemoryAccessMap {
    private static final boolean DEBUG = false;
    private static final boolean ALWAYS_BUILD_IR = true;
    private final Map<IField, Set<MemoryAccess>> readMap = HashMapFactory.make();
    private final Map<IField, Set<MemoryAccess>> writeMap = HashMapFactory.make();
    private final Set<MemoryAccess> arrayReads = HashSetFactory.make();
    private final Set<MemoryAccess> arrayWrites = HashSetFactory.make();
    private final IClassHierarchy cha;
    private final boolean includePrimOps;
    private final HeapModel heapModel;

    public SimpleMemoryAccessMap(CallGraph callGraph, HeapModel heapModel, boolean bl) {
        if (callGraph == null) {
            throw new IllegalArgumentException("null cg");
        }
        this.cha = callGraph.getClassHierarchy();
        this.heapModel = heapModel;
        this.includePrimOps = bl;
        this.populate(callGraph);
    }

    private void populate(CallGraph callGraph) {
        for (CGNode cGNode : callGraph) {
            this.populate(cGNode);
        }
    }

    private void populate(CGNode cGNode) {
        IR iR = cGNode.getIR();
        if (iR == null) {
            return;
        }
        SSAInstruction[] sSAInstructionArray = iR.getInstructions();
        SSAMemoryAccessVisitor sSAMemoryAccessVisitor = new SSAMemoryAccessVisitor(cGNode);
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                sSAMemoryAccessVisitor.setInstructionIndex(n);
                sSAInstruction.visit(sSAMemoryAccessVisitor);
            }
            ++n;
        }
    }

    @Override
    public Collection<MemoryAccess> getFieldReads(PointerKey pointerKey, IField iField) {
        Collection collection = this.readMap.get(iField);
        if (collection == null) {
            return Collections.emptySet();
        }
        return collection;
    }

    @Override
    public Collection<MemoryAccess> getFieldWrites(PointerKey pointerKey, IField iField) {
        Collection collection = this.writeMap.get(iField);
        if (collection == null) {
            return Collections.emptySet();
        }
        return collection;
    }

    @Override
    public Collection<MemoryAccess> getArrayReads(PointerKey pointerKey) {
        return this.arrayReads;
    }

    @Override
    public Collection<MemoryAccess> getArrayWrites(PointerKey pointerKey) {
        return this.arrayWrites;
    }

    public String toString() {
        Iterator<Object> iterator;
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<IField> hashSet = HashSetFactory.make();
        hashSet.addAll(this.readMap.keySet());
        hashSet.addAll(this.writeMap.keySet());
        for (IField iField : hashSet) {
            Object object;
            stringBuffer.append("FIELD ").append(iField).append(":\n");
            Collection<MemoryAccess> collection = this.getFieldReads(null, iField);
            if (!collection.isEmpty()) {
                stringBuffer.append("  reads:\n");
                object = collection.iterator();
                while (object.hasNext()) {
                    stringBuffer.append("  ").append(object.next()).append("\n");
                }
            }
            if ((object = this.getFieldWrites(null, iField)).isEmpty()) continue;
            stringBuffer.append("  writes:\n");
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append("  ").append(iterator2.next()).append("\n");
            }
        }
        stringBuffer.append("ARRAY CONTENTS:\n");
        if (!this.arrayReads.isEmpty()) {
            stringBuffer.append("  reads:\n");
            iterator = this.arrayReads.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("  ").append(iterator.next()).append("\n");
            }
        }
        if (!this.arrayWrites.isEmpty()) {
            stringBuffer.append("  writes:\n");
            iterator = this.arrayWrites.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("  ").append(iterator.next()).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public Collection<MemoryAccess> getStaticFieldReads(IField iField) {
        return this.getFieldReads(null, iField);
    }

    @Override
    public Collection<MemoryAccess> getStaticFieldWrites(IField iField) {
        return this.getFieldWrites(null, iField);
    }

    @Override
    public HeapModel getHeapModel() {
        return this.heapModel;
    }

    public void repOk() {
        for (MemoryAccess memoryAccess : Iterator2Iterable.make(new CompoundIterator<MemoryAccess>(this.arrayReads.iterator(), this.arrayWrites.iterator()))) {
            CGNode cGNode = memoryAccess.getNode();
            IR iR = cGNode.getIR();
            assert (iR != null) : "null IR for " + cGNode + " but we have a memory access";
            SSAInstruction[] sSAInstructionArray = iR.getInstructions();
            int n = memoryAccess.getInstructionIndex();
            assert (n >= 0 && n < sSAInstructionArray.length) : "instruction index " + n + " out of range for " + cGNode + ", which has " + sSAInstructionArray.length + " instructions";
            SSAInstruction sSAInstruction = sSAInstructionArray[memoryAccess.getInstructionIndex()];
            if (sSAInstruction != null) assert (sSAInstruction instanceof SSAArrayReferenceInstruction || sSAInstruction instanceof SSANewInstruction) : "bad type " + sSAInstruction.getClass() + " for array access instruction";
        }
    }

    private class MemoryAccessVisitor
    extends IInstruction.Visitor {
        int instructionIndex;
        final ClassLoaderReference loader;
        final CGNode node;

        public MemoryAccessVisitor(ClassLoaderReference classLoaderReference, CGNode cGNode) {
            this.loader = classLoaderReference;
            this.node = cGNode;
        }

        protected int getInstructionIndex() {
            return this.instructionIndex;
        }

        protected void setInstructionIndex(int n) {
            this.instructionIndex = n;
        }

        public void visitNew(NewInstruction newInstruction) {
            TypeReference typeReference = ShrikeUtil.makeTypeReference(this.loader, newInstruction.getType());
            if (typeReference.isArrayType() && typeReference.getArrayElementType().isArrayType()) {
                SimpleMemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
            }
        }

        public void visitArrayLoad(IArrayLoadInstruction iArrayLoadInstruction) {
            TypeReference typeReference;
            if (!SimpleMemoryAccessMap.this.includePrimOps && (typeReference = ShrikeUtil.makeTypeReference(this.loader, iArrayLoadInstruction.getType())).isPrimitiveType()) {
                return;
            }
            SimpleMemoryAccessMap.this.arrayReads.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitArrayStore(IArrayStoreInstruction iArrayStoreInstruction) {
            TypeReference typeReference;
            if (!SimpleMemoryAccessMap.this.includePrimOps && (typeReference = ShrikeUtil.makeTypeReference(this.loader, iArrayStoreInstruction.getType())).isPrimitiveType()) {
                return;
            }
            SimpleMemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitGet(IGetInstruction iGetInstruction) {
            FieldReference fieldReference = FieldReference.findOrCreate(this.loader, iGetInstruction.getClassType(), iGetInstruction.getFieldName(), iGetInstruction.getFieldType());
            if (!SimpleMemoryAccessMap.this.includePrimOps && fieldReference.getFieldType().isPrimitiveType()) {
                return;
            }
            IField iField = SimpleMemoryAccessMap.this.cha.resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            Set set = MapUtil.findOrCreateSet(SimpleMemoryAccessMap.this.readMap, iField);
            MemoryAccess memoryAccess = new MemoryAccess(this.instructionIndex, this.node);
            set.add(memoryAccess);
        }

        public void visitPut(IPutInstruction iPutInstruction) {
            FieldReference fieldReference = FieldReference.findOrCreate(this.loader, iPutInstruction.getClassType(), iPutInstruction.getFieldName(), iPutInstruction.getFieldType());
            if (!SimpleMemoryAccessMap.this.includePrimOps && fieldReference.getFieldType().isPrimitiveType()) {
                return;
            }
            IField iField = SimpleMemoryAccessMap.this.cha.resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            Set set = MapUtil.findOrCreateSet(SimpleMemoryAccessMap.this.writeMap, iField);
            MemoryAccess memoryAccess = new MemoryAccess(this.instructionIndex, this.node);
            set.add(memoryAccess);
        }
    }

    private class SSAMemoryAccessVisitor
    extends SSAInstruction.Visitor {
        private final CGNode node;
        private int instructionIndex;

        public SSAMemoryAccessVisitor(CGNode cGNode) {
            this.node = cGNode;
        }

        public void setInstructionIndex(int n) {
            this.instructionIndex = n;
        }

        public void visitNew(SSANewInstruction sSANewInstruction) {
            TypeReference typeReference = sSANewInstruction.getNewSite().getDeclaredType();
            if (typeReference.isArrayType() && typeReference.getArrayElementType().isArrayType()) {
                SimpleMemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
            }
        }

        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            if (!SimpleMemoryAccessMap.this.includePrimOps && sSAArrayLoadInstruction.typeIsPrimitive()) {
                return;
            }
            SimpleMemoryAccessMap.this.arrayReads.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
            if (!SimpleMemoryAccessMap.this.includePrimOps && sSAArrayStoreInstruction.typeIsPrimitive()) {
                return;
            }
            SimpleMemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            if (!SimpleMemoryAccessMap.this.includePrimOps && sSAGetInstruction.getDeclaredFieldType().isPrimitiveType()) {
                return;
            }
            FieldReference fieldReference = sSAGetInstruction.getDeclaredField();
            IField iField = SimpleMemoryAccessMap.this.cha.resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            Set set = MapUtil.findOrCreateSet(SimpleMemoryAccessMap.this.readMap, iField);
            MemoryAccess memoryAccess = new MemoryAccess(this.instructionIndex, this.node);
            set.add(memoryAccess);
        }

        public void visitPut(SSAPutInstruction sSAPutInstruction) {
            if (!SimpleMemoryAccessMap.this.includePrimOps && sSAPutInstruction.getDeclaredFieldType().isPrimitiveType()) {
                return;
            }
            FieldReference fieldReference = sSAPutInstruction.getDeclaredField();
            IField iField = SimpleMemoryAccessMap.this.cha.resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            Set set = MapUtil.findOrCreateSet(SimpleMemoryAccessMap.this.writeMap, iField);
            MemoryAccess memoryAccess = new MemoryAccess(this.instructionIndex, this.node);
            set.add(memoryAccess);
        }
    }
}

