/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.genericutil;

import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableStack<T>
implements Iterable<T> {
    private static final ImmutableStack<Object> EMPTY = new ImmutableStack<Object>(new Object[0]);
    private static final int MAX_SIZE = Integer.MAX_VALUE;
    private final T[] entries;
    private final int cachedHashCode;

    public static int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public static final <T> ImmutableStack<T> emptyStack() {
        return EMPTY;
    }

    protected ImmutableStack(T[] TArray) {
        this.entries = TArray;
        this.cachedHashCode = Arrays.hashCode(TArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof ImmutableStack) {
            ImmutableStack immutableStack = (ImmutableStack)object;
            return Arrays.equals(this.entries, immutableStack.entries);
        }
        return false;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public ImmutableStack<T> push(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null entry");
        }
        int n = this.entries.length + 1;
        Object[] objectArray = null;
        if (n <= Integer.MAX_VALUE) {
            objectArray = this.makeInternalArray(n);
            System.arraycopy(this.entries, 0, objectArray, 0, this.entries.length);
            objectArray[n - 1] = t;
        } else {
            objectArray = this.makeInternalArray(Integer.MAX_VALUE);
            System.arraycopy(this.entries, 1, objectArray, 0, this.entries.length - 1);
            objectArray[0x7FFFFFFE] = t;
        }
        return this.makeStack(objectArray);
    }

    protected T[] makeInternalArray(int n) {
        return new Object[n];
    }

    protected ImmutableStack<T> makeStack(T[] TArray) {
        return new ImmutableStack<T>(TArray);
    }

    public T peek() {
        if (this.entries.length == 0) {
            throw new EmptyStackException();
        }
        return this.entries[this.entries.length - 1];
    }

    public ImmutableStack<T> pop() {
        if (this.entries.length == 0) {
            throw new EmptyStackException();
        }
        int n = this.entries.length - 1;
        T[] TArray = this.makeInternalArray(n);
        System.arraycopy(this.entries, 0, TArray, 0, n);
        return this.makeStack(TArray);
    }

    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    public int size() {
        return this.entries.length;
    }

    public T get(int n) {
        try {
            return this.entries[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid i: " + n);
        }
    }

    public String toString() {
        String string = Arrays.toString(this.entries);
        assert (this.entries.length <= Integer.MAX_VALUE) : string;
        return string;
    }

    public boolean contains(T t) {
        if (t == null) {
            return false;
        }
        int n = 0;
        while (n < this.entries.length) {
            if (this.entries[n] != null && this.entries[n].equals(t)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean topMatches(ImmutableStack<T> immutableStack) throws IllegalArgumentException {
        if (immutableStack == null) {
            throw new IllegalArgumentException("other == null");
        }
        if (immutableStack.size() > this.size()) {
            return false;
        }
        int n = immutableStack.size() - 1;
        int n2 = this.size() - 1;
        while (n >= 0) {
            if (!immutableStack.get(n).equals(this.get(n2))) {
                return false;
            }
            --n;
            --n2;
        }
        return true;
    }

    public ImmutableStack<T> reverse() {
        Object[] objectArray = new Object[this.entries.length];
        int n = this.entries.length - 1;
        int n2 = 0;
        while (n >= 0) {
            objectArray[n2] = this.entries[n];
            --n;
            ++n2;
        }
        return new ImmutableStack<Object>(objectArray);
    }

    public ImmutableStack<T> popAll(ImmutableStack<T> immutableStack) {
        if (!this.topMatches(immutableStack)) {
            throw new IllegalArgumentException("top does not match");
        }
        int n = this.entries.length - immutableStack.entries.length;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.entries, 0, objectArray, 0, n);
        return new ImmutableStack<Object>(objectArray);
    }

    public ImmutableStack<T> pushAll(ImmutableStack<T> immutableStack) {
        if (immutableStack == null) {
            throw new IllegalArgumentException("null other");
        }
        int n = this.entries.length + immutableStack.entries.length;
        Object[] objectArray = null;
        if (n <= Integer.MAX_VALUE) {
            objectArray = new Object[n];
            System.arraycopy(this.entries, 0, objectArray, 0, this.entries.length);
            System.arraycopy(immutableStack.entries, 0, objectArray, this.entries.length, immutableStack.entries.length);
        } else {
            objectArray = new Object[Integer.MAX_VALUE];
            int n2 = Integer.MAX_VALUE - immutableStack.entries.length;
            System.arraycopy(this.entries, this.entries.length - n2, objectArray, 0, n2);
            System.arraycopy(immutableStack.entries, 0, objectArray, n2, immutableStack.entries.length);
        }
        return new ImmutableStack<Object>(objectArray);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.entries.length == 0) {
            return EmptyIterator.instance();
        }
        return new ArrayIterator<T>(this.entries);
    }

    public ImmutableStack<T> replaceTop(T t) {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        int n = this.entries.length;
        T[] TArray = this.makeInternalArray(n);
        System.arraycopy(this.entries, 0, TArray, 0, this.entries.length - 1);
        TArray[n - 1] = t;
        return this.makeStack(TArray);
    }
}

