/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AbstractDemandFlowGraph;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowGraph;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.demandpa.util.PointerParamValueNumIterator;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DemandPointerFlowGraph
extends AbstractDemandFlowGraph
implements IFlowGraph {
    public DemandPointerFlowGraph(CallGraph callGraph, HeapModel heapModel, MemoryAccessMap memoryAccessMap, IClassHierarchy iClassHierarchy) {
        super(callGraph, heapModel, memoryAccessMap, iClassHierarchy);
    }

    protected void addNodesForParameters(CGNode cGNode, IR iR) {
        Object object = new PointerParamValueNumIterator(cGNode);
        while (object.hasNext()) {
            int n = (Integer)object.next();
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, n);
            this.addNode(pointerKey);
            this.params.put(pointerKey, cGNode);
        }
        object = this.heapModel.getPointerKeyForReturnValue(cGNode);
        this.addNode(object);
        this.returns.put(object, cGNode);
        PointerKey pointerKey = this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode);
        this.addNode(pointerKey);
        this.returns.put(pointerKey, cGNode);
    }

    protected AbstractDemandFlowGraph.FlowStatementVisitor makeVisitor(CGNode cGNode) {
        return new StatementVisitor(this.heapModel, this, this.cha, this.cg, cGNode);
    }

    public static NewMultiDimInfo getInfoForNewMultiDim(SSANewInstruction sSANewInstruction, HeapModel heapModel, CGNode cGNode) {
        if (heapModel == null) {
            throw new IllegalArgumentException("null heapModel");
        }
        HashSet<Pair<PointerKey, InstanceKey>> hashSet = HashSetFactory.make();
        HashSet<Pair<PointerKey, PointerKey>> hashSet2 = HashSetFactory.make();
        InstanceKey instanceKey = heapModel.getInstanceKeyForAllocation(cGNode, sSANewInstruction.getNewSite());
        if (instanceKey == null) {
            return null;
        }
        IClass iClass = instanceKey.getConcreteType();
        if (!iClass.isArrayClass() || ((ArrayClass)iClass).getElementClass() == null || !((ArrayClass)iClass).getElementClass().isArrayClass()) {
            return null;
        }
        PointerKey pointerKey = heapModel.getPointerKeyForLocal(cGNode, sSANewInstruction.getDef());
        int n = 0;
        InstanceKey instanceKey2 = instanceKey;
        PointerKey pointerKey2 = pointerKey;
        while (iClass != null && iClass.isArrayClass()) {
            if ((iClass = ((ArrayClass)iClass).getElementClass()) == null || !iClass.isArrayClass()) continue;
            InstanceKey instanceKey3 = heapModel.getInstanceKeyForMultiNewArray(cGNode, sSANewInstruction.getNewSite(), n);
            PointerKey pointerKey3 = heapModel.getPointerKeyForArrayContents(instanceKey2);
            hashSet.add(Pair.make(pointerKey3, instanceKey3));
            hashSet2.add(Pair.make(pointerKey2, pointerKey3));
            instanceKey2 = instanceKey3;
            pointerKey2 = pointerKey3;
            ++n;
        }
        return new NewMultiDimInfo(hashSet, hashSet2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewMultiDimInfo {
        public final Collection<Pair<PointerKey, InstanceKey>> newInstrs;
        public final Collection<Pair<PointerKey, PointerKey>> arrStoreInstrs;

        public NewMultiDimInfo(Collection<Pair<PointerKey, InstanceKey>> collection, Collection<Pair<PointerKey, PointerKey>> collection2) {
            this.newInstrs = collection;
            this.arrStoreInstrs = collection2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatementVisitor
    extends SSAInstruction.Visitor
    implements AbstractDemandFlowGraph.FlowStatementVisitor {
        private final HeapModel heapModel;
        private final IFlowGraph g;
        private final IClassHierarchy cha;
        private final CallGraph cg;
        protected final CGNode node;
        protected final IR ir;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public StatementVisitor(HeapModel heapModel, IFlowGraph iFlowGraph, IClassHierarchy iClassHierarchy, CallGraph callGraph, CGNode cGNode) {
            this.heapModel = heapModel;
            this.g = iFlowGraph;
            this.cha = iClassHierarchy;
            this.cg = callGraph;
            this.node = cGNode;
            this.ir = cGNode.getIR();
            this.du = cGNode.getDU();
            this.symbolTable = this.ir.getSymbolTable();
            assert (this.symbolTable != null);
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            if (sSAArrayLoadInstruction.typeIsPrimitive()) {
                return;
            }
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, sSAArrayLoadInstruction.getDef());
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(this.node, sSAArrayLoadInstruction.getArrayRef());
            this.g.addNode(pointerKey);
            this.g.addNode(pointerKey2);
            this.g.addEdge(pointerKey, pointerKey2, GetFieldLabel.make(ArrayContents.v()));
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
            if (sSAArrayStoreInstruction.typeIsPrimitive()) {
                return;
            }
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, sSAArrayStoreInstruction.getValue());
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(this.node, sSAArrayStoreInstruction.getArrayRef());
            this.g.addNode(pointerKey);
            this.g.addNode(pointerKey2);
            this.g.addEdge(pointerKey2, pointerKey, PutFieldLabel.make(ArrayContents.v()));
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction sSACheckCastInstruction) {
            Object object;
            HashSet<IClass> hashSet = HashSetFactory.make();
            TypeReference[] typeReferenceArray = sSACheckCastInstruction.getDeclaredResultTypes();
            int n = typeReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = typeReferenceArray[n2];
                IClass iClass = this.cha.lookupClass((TypeReference)object);
                if (iClass == null) {
                    return;
                }
                hashSet.add(iClass);
                ++n2;
            }
            object = new FilteredPointerKey.MultipleClassesFilter(hashSet.toArray(new IClass[hashSet.size()]));
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, sSACheckCastInstruction.getResult());
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(this.node, sSACheckCastInstruction.getVal());
            this.g.addNode(pointerKey);
            this.g.addNode(pointerKey2);
            this.g.addEdge(pointerKey, pointerKey2, AssignLabel.make((FilteredPointerKey.TypeFilter)object));
        }

        @Override
        public void visitReturn(SSAReturnInstruction sSAReturnInstruction) {
            if (sSAReturnInstruction.returnsPrimitiveType() || sSAReturnInstruction.returnsVoid()) {
                return;
            }
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, sSAReturnInstruction.getResult());
            this.g.addNode(pointerKey);
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForReturnValue(this.node);
            this.g.addNode(pointerKey2);
            this.g.addEdge(pointerKey2, pointerKey, AssignLabel.noFilter());
        }

        @Override
        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            this.visitGetInternal(sSAGetInstruction.getDef(), sSAGetInstruction.getRef(), sSAGetInstruction.isStatic(), sSAGetInstruction.getDeclaredField());
        }

        protected void visitGetInternal(int n, int n2, boolean bl, FieldReference fieldReference) {
            if (fieldReference.getFieldType().isPrimitiveType()) {
                return;
            }
            IField iField = this.cg.getClassHierarchy().resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, n);
            assert (pointerKey != null);
            if (bl) {
                PointerKey pointerKey2 = this.heapModel.getPointerKeyForStaticField(iField);
                this.g.addNode(pointerKey);
                this.g.addNode(pointerKey2);
                this.g.addEdge(pointerKey, pointerKey2, AssignGlobalLabel.v());
            } else {
                PointerKey pointerKey3 = this.heapModel.getPointerKeyForLocal(this.node, n2);
                this.g.addNode(pointerKey);
                this.g.addNode(pointerKey3);
                this.g.addEdge(pointerKey, pointerKey3, GetFieldLabel.make(iField));
            }
        }

        @Override
        public void visitPut(SSAPutInstruction sSAPutInstruction) {
            this.visitPutInternal(sSAPutInstruction.getVal(), sSAPutInstruction.getRef(), sSAPutInstruction.isStatic(), sSAPutInstruction.getDeclaredField());
        }

        public void visitPutInternal(int n, int n2, boolean bl, FieldReference fieldReference) {
            if (fieldReference.getFieldType().isPrimitiveType()) {
                return;
            }
            IField iField = this.cg.getClassHierarchy().resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, n);
            assert (pointerKey != null);
            if (bl) {
                PointerKey pointerKey2 = this.heapModel.getPointerKeyForStaticField(iField);
                this.g.addNode(pointerKey);
                this.g.addNode(pointerKey2);
                this.g.addEdge(pointerKey2, pointerKey, AssignGlobalLabel.v());
            } else {
                PointerKey pointerKey3 = this.heapModel.getPointerKeyForLocal(this.node, n2);
                this.g.addNode(pointerKey);
                this.g.addNode(pointerKey3);
                this.g.addEdge(pointerKey3, pointerKey, PutFieldLabel.make(iField));
            }
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction sSAInvokeInstruction) {
        }

        @Override
        public void visitNew(SSANewInstruction sSANewInstruction) {
            InstanceKey instanceKey = this.heapModel.getInstanceKeyForAllocation(this.node, sSANewInstruction.getNewSite());
            if (instanceKey == null) {
                return;
            }
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, sSANewInstruction.getDef());
            this.g.addNode(instanceKey);
            this.g.addNode(pointerKey);
            this.g.addEdge(pointerKey, instanceKey, NewLabel.v());
            NewMultiDimInfo newMultiDimInfo = DemandPointerFlowGraph.getInfoForNewMultiDim(sSANewInstruction, this.heapModel, this.node);
            if (newMultiDimInfo != null) {
                for (Pair<PointerKey, InstanceKey> pair : newMultiDimInfo.newInstrs) {
                    this.g.addNode(pair.fst);
                    this.g.addNode(pair.snd);
                    this.g.addEdge(pair.fst, pair.snd, NewLabel.v());
                }
                for (Pair<PointerKey, Object> pair : newMultiDimInfo.arrStoreInstrs) {
                    this.g.addNode(pair.fst);
                    this.g.addNode(pair.snd);
                    this.g.addEdge(pair.fst, pair.snd, PutFieldLabel.make(ArrayContents.v()));
                }
            }
        }

        @Override
        public void visitThrow(SSAThrowInstruction sSAThrowInstruction) {
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
            List<ProgramCounter> list = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, sSAGetCaughtExceptionInstruction.getDef());
            Set<IClass> set = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(sSAGetCaughtExceptionInstruction, this.ir);
            this.addExceptionDefConstraints(this.ir, this.node, list, pointerKey, set);
        }

        protected void addExceptionDefConstraints(IR iR, CGNode cGNode, List<ProgramCounter> list, PointerKey pointerKey, Set<IClass> set) {
            for (ProgramCounter programCounter : list) {
                Object object;
                Object object2;
                SSAInstruction sSAInstruction = iR.getPEI(programCounter);
                if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                    object2 = (SSAAbstractInvokeInstruction)sSAInstruction;
                    object = this.heapModel.getPointerKeyForLocal(cGNode, ((SSAAbstractInvokeInstruction)object2).getException());
                    this.g.addNode(pointerKey);
                    this.g.addNode(object);
                    this.g.addEdge(pointerKey, object, AssignLabel.noFilter());
                } else if (sSAInstruction instanceof SSAAbstractThrowInstruction) {
                    object2 = (SSAAbstractThrowInstruction)sSAInstruction;
                    object = this.heapModel.getPointerKeyForLocal(cGNode, ((SSAAbstractThrowInstruction)object2).getException());
                    this.g.addNode(pointerKey);
                    this.g.addNode(object);
                    this.g.addEdge(pointerKey, object, AssignLabel.noFilter());
                }
                object2 = sSAInstruction.getExceptionTypes();
                if (object2 == null) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    InstanceKey instanceKey;
                    TypeReference typeReference = (TypeReference)object.next();
                    if (typeReference == null || (instanceKey = this.heapModel.getInstanceKeyForPEI(cGNode, programCounter, typeReference)) == null) continue;
                    assert (instanceKey instanceof ConcreteTypeKey) : "uh oh: need to implement getCaughtException constraints for instance " + instanceKey;
                    ConcreteTypeKey concreteTypeKey = (ConcreteTypeKey)instanceKey;
                    IClass iClass = concreteTypeKey.getType();
                    if (!PropagationCallGraphBuilder.catches(set, iClass, this.cha)) continue;
                    this.g.addNode(pointerKey);
                    this.g.addNode(instanceKey);
                    this.g.addEdge(pointerKey, instanceKey, NewLabel.v());
                }
            }
        }

        @Override
        public void visitPi(SSAPiInstruction sSAPiInstruction) {
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, sSAPiInstruction.getDef());
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(this.node, sSAPiInstruction.getVal());
            this.g.addNode(pointerKey);
            this.g.addNode(pointerKey2);
            this.g.addEdge(pointerKey, pointerKey2, AssignLabel.noFilter());
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        @Override
        public void setBasicBlock(ISSABasicBlock iSSABasicBlock) {
            this.basicBlock = iSSABasicBlock;
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction sSALoadMetadataInstruction) {
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(this.node, sSALoadMetadataInstruction.getDef());
            assert (sSALoadMetadataInstruction.getType() == TypeReference.JavaLangClass);
            InstanceKey instanceKey = this.heapModel.getInstanceKeyForClassObject((TypeReference)sSALoadMetadataInstruction.getToken());
            this.g.addNode(instanceKey);
            this.g.addNode(pointerKey);
            this.g.addEdge(pointerKey, instanceKey, NewLabel.v());
        }
    }
}

