/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.DemandPointerFlowGraph;
import com.ibm.wala.demandpa.flowgraph.IFlowGraph;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.labeled.SlowSparseNumberedLabeledGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlowGraph
extends SlowSparseNumberedLabeledGraph<Object, IFlowLabel>
implements IFlowGraph {
    private static final IFlowLabel defaultLabel = new IFlowLabel(){

        public IFlowLabel bar() {
            return defaultLabel;
        }

        public boolean isBarred() {
            return false;
        }

        public void visit(IFlowLabel.IFlowLabelVisitor iFlowLabelVisitor, Object object) {
        }
    };
    protected final Map<PointerKey, SSAInvokeInstruction> callDefs = HashMapFactory.make();
    protected final Map<PointerKey, Set<SSAInvokeInstruction>> callParams = HashMapFactory.make();
    protected final Map<PointerKey, CGNode> params = HashMapFactory.make();
    protected final Map<PointerKey, CGNode> returns = HashMapFactory.make();
    protected final MemoryAccessMap mam;
    protected final HeapModel heapModel;
    protected final IClassHierarchy cha;
    protected final CallGraph cg;

    public AbstractFlowGraph(MemoryAccessMap memoryAccessMap, HeapModel heapModel, IClassHierarchy iClassHierarchy, CallGraph callGraph) {
        super(defaultLabel);
        this.mam = memoryAccessMap;
        this.heapModel = heapModel;
        this.cha = iClassHierarchy;
        this.cg = callGraph;
    }

    @Override
    public void visitSuccs(Object object, IFlowLabel.IFlowLabelVisitor iFlowLabelVisitor) {
        Iterator iterator = this.getSuccLabels(object);
        while (iterator.hasNext()) {
            IFlowLabel iFlowLabel = (IFlowLabel)iterator.next();
            Iterator<Object> iterator2 = this.getSuccNodes(object, iFlowLabel);
            while (iterator2.hasNext()) {
                iFlowLabel.visit(iFlowLabelVisitor, iterator2.next());
            }
        }
    }

    @Override
    public void visitPreds(Object object, IFlowLabel.IFlowLabelVisitor iFlowLabelVisitor) {
        Iterator iterator = this.getPredLabels(object);
        while (iterator.hasNext()) {
            IFlowLabel iFlowLabel = (IFlowLabel)iterator.next();
            Iterator<Object> iterator2 = this.getPredNodes(object, iFlowLabel);
            while (iterator2.hasNext()) {
                iFlowLabel.visit(iFlowLabelVisitor, iterator2.next());
            }
        }
    }

    protected void addNodesForInvocations(CGNode cGNode, IR iR) {
        Iterator<CallSiteReference> iterator = iR.iterateCallSites();
        while (iterator.hasNext()) {
            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray;
            CallSiteReference callSiteReference = iterator.next();
            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray2 = sSAAbstractInvokeInstructionArray = iR.getCalls(callSiteReference);
            int n = sSAAbstractInvokeInstructionArray.length;
            int n2 = 0;
            while (n2 < n) {
                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray2[n2];
                int n3 = 0;
                while (n3 < sSAAbstractInvokeInstruction.getNumberOfUses()) {
                    PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getUse(n3));
                    this.addNode(pointerKey);
                    Set<SSAInvokeInstruction> set = MapUtil.findOrCreateSet(this.callParams, pointerKey);
                    set.add((SSAInvokeInstruction)sSAAbstractInvokeInstruction);
                    ++n3;
                }
                if (sSAAbstractInvokeInstruction.hasDef()) {
                    PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getDef());
                    this.addNode(pointerKey);
                    this.callDefs.put(pointerKey, (SSAInvokeInstruction)sSAAbstractInvokeInstruction);
                }
                PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getException());
                this.addNode(pointerKey);
                this.callDefs.put(pointerKey, (SSAInvokeInstruction)sSAAbstractInvokeInstruction);
                ++n2;
            }
        }
    }

    @Override
    public boolean isParam(LocalPointerKey localPointerKey) {
        return this.params.get(localPointerKey) != null;
    }

    @Override
    public Iterator<SSAInvokeInstruction> getInstrsPassingParam(LocalPointerKey localPointerKey) {
        Set<SSAInvokeInstruction> set = this.callParams.get(localPointerKey);
        if (set == null) {
            return EmptyIterator.instance();
        }
        return set.iterator();
    }

    @Override
    public SSAInvokeInstruction getInstrReturningTo(LocalPointerKey localPointerKey) {
        return this.callDefs.get(localPointerKey);
    }

    @Override
    public Iterator<? extends Object> getWritesToStaticField(StaticFieldKey staticFieldKey) throws IllegalArgumentException {
        if (staticFieldKey == null) {
            throw new IllegalArgumentException("sfk == null");
        }
        Collection<MemoryAccess> collection = this.mam.getStaticFieldWrites(staticFieldKey.getField());
        for (MemoryAccess memoryAccess : collection) {
            this.addSubgraphForNode(memoryAccess.getNode());
        }
        return this.getSuccNodes(staticFieldKey, AssignGlobalLabel.v());
    }

    @Override
    public Iterator<? extends Object> getReadsOfStaticField(StaticFieldKey staticFieldKey) throws IllegalArgumentException {
        if (staticFieldKey == null) {
            throw new IllegalArgumentException("sfk == null");
        }
        Collection<MemoryAccess> collection = this.mam.getStaticFieldReads(staticFieldKey.getField());
        for (MemoryAccess memoryAccess : collection) {
            this.addSubgraphForNode(memoryAccess.getNode());
        }
        return this.getPredNodes(staticFieldKey, AssignGlobalLabel.v());
    }

    @Override
    public Iterator<PointerKey> getWritesToInstanceField(PointerKey pointerKey, IField iField) {
        if (iField == ArrayContents.v()) {
            return this.getArrayWrites(pointerKey);
        }
        pointerKey = AbstractFlowGraph.convertPointerKeyToHeapModel(pointerKey, this.mam.getHeapModel());
        Collection<MemoryAccess> collection = this.mam.getFieldWrites(pointerKey, iField);
        for (MemoryAccess memoryAccess : collection) {
            this.addSubgraphForNode(memoryAccess.getNode());
        }
        ArrayList<PointerKey> arrayList = new ArrayList<PointerKey>();
        for (MemoryAccess memoryAccess : collection) {
            IR iR = memoryAccess.getNode().getIR();
            SSAPutInstruction sSAPutInstruction = (SSAPutInstruction)iR.getInstructions()[memoryAccess.getInstructionIndex()];
            if (sSAPutInstruction == null) continue;
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(memoryAccess.getNode(), sSAPutInstruction.getVal());
            arrayList.add(pointerKey2);
        }
        return arrayList.iterator();
    }

    public static PointerKey convertPointerKeyToHeapModel(PointerKey pointerKey, HeapModel heapModel) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("null pk");
        }
        if (pointerKey instanceof LocalPointerKey) {
            LocalPointerKey localPointerKey = (LocalPointerKey)pointerKey;
            return heapModel.getPointerKeyForLocal(localPointerKey.getNode(), localPointerKey.getValueNumber());
        }
        if (pointerKey instanceof ArrayContentsKey) {
            ArrayContentsKey arrayContentsKey = (ArrayContentsKey)pointerKey;
            InstanceKey instanceKey = arrayContentsKey.getInstanceKey();
            if (instanceKey instanceof NormalAllocationInNode) {
                NormalAllocationInNode normalAllocationInNode = (NormalAllocationInNode)instanceKey;
                instanceKey = heapModel.getInstanceKeyForAllocation(normalAllocationInNode.getNode(), normalAllocationInNode.getSite());
            } else assert (false) : "need to handle " + instanceKey.getClass();
            return heapModel.getPointerKeyForArrayContents(instanceKey);
        }
        if (pointerKey instanceof ReturnValueKey) {
            ReturnValueKey returnValueKey = (ReturnValueKey)pointerKey;
            return heapModel.getPointerKeyForReturnValue(returnValueKey.getNode());
        }
        throw new UnsupportedOperationException("need to handle " + pointerKey.getClass());
    }

    @Override
    public Iterator<PointerKey> getReadsOfInstanceField(PointerKey pointerKey, IField iField) {
        if (iField == ArrayContents.v()) {
            return this.getArrayReads(pointerKey);
        }
        pointerKey = AbstractFlowGraph.convertPointerKeyToHeapModel(pointerKey, this.mam.getHeapModel());
        Collection<MemoryAccess> collection = this.mam.getFieldReads(pointerKey, iField);
        for (MemoryAccess memoryAccess : collection) {
            this.addSubgraphForNode(memoryAccess.getNode());
        }
        ArrayList<PointerKey> arrayList = new ArrayList<PointerKey>();
        for (MemoryAccess memoryAccess : collection) {
            IR iR = memoryAccess.getNode().getIR();
            SSAGetInstruction sSAGetInstruction = (SSAGetInstruction)iR.getInstructions()[memoryAccess.getInstructionIndex()];
            if (sSAGetInstruction == null) continue;
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(memoryAccess.getNode(), sSAGetInstruction.getDef());
            arrayList.add(pointerKey2);
        }
        return arrayList.iterator();
    }

    Iterator<PointerKey> getArrayWrites(PointerKey pointerKey) {
        pointerKey = AbstractFlowGraph.convertPointerKeyToHeapModel(pointerKey, this.mam.getHeapModel());
        Collection<MemoryAccess> collection = this.mam.getArrayWrites(pointerKey);
        for (MemoryAccess memoryAccess : collection) {
            this.addSubgraphForNode(memoryAccess.getNode());
        }
        ArrayList<PointerKey> arrayList = new ArrayList<PointerKey>();
        for (MemoryAccess memoryAccess : collection) {
            Object object;
            CGNode cGNode = memoryAccess.getNode();
            IR iR = cGNode.getIR();
            SSAInstruction sSAInstruction = iR.getInstructions()[memoryAccess.getInstructionIndex()];
            if (sSAInstruction == null) continue;
            if (sSAInstruction instanceof SSAArrayStoreInstruction) {
                object = (SSAArrayStoreInstruction)sSAInstruction;
                PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(cGNode, ((SSAArrayStoreInstruction)object).getValue());
                arrayList.add(pointerKey2);
                continue;
            }
            if (sSAInstruction instanceof SSANewInstruction) {
                object = DemandPointerFlowGraph.getInfoForNewMultiDim((SSANewInstruction)sSAInstruction, this.heapModel, cGNode);
                for (Pair<PointerKey, PointerKey> pair : ((DemandPointerFlowGraph.NewMultiDimInfo)object).arrStoreInstrs) {
                    arrayList.add((PointerKey)pair.snd);
                }
                continue;
            }
            Assertions.UNREACHABLE();
        }
        return arrayList.iterator();
    }

    protected Iterator<PointerKey> getArrayReads(PointerKey pointerKey) {
        pointerKey = AbstractFlowGraph.convertPointerKeyToHeapModel(pointerKey, this.mam.getHeapModel());
        Collection<MemoryAccess> collection = this.mam.getArrayReads(pointerKey);
        for (MemoryAccess object : collection) {
            this.addSubgraphForNode(object.getNode());
        }
        ArrayList arrayList = new ArrayList();
        for (MemoryAccess memoryAccess : collection) {
            IR iR = memoryAccess.getNode().getIR();
            SSAArrayLoadInstruction sSAArrayLoadInstruction = (SSAArrayLoadInstruction)iR.getInstructions()[memoryAccess.getInstructionIndex()];
            if (sSAArrayLoadInstruction == null) continue;
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(memoryAccess.getNode(), sSAArrayLoadInstruction.getDef());
            arrayList.add(pointerKey2);
        }
        return arrayList.iterator();
    }

    protected void addNodePassthruExceptionConstraints(CGNode cGNode, IR iR) {
        List<ProgramCounter> list = SSAPropagationCallGraphBuilder.getIncomingPEIs(iR, iR.getExitBlock());
        PointerKey pointerKey = this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode);
        IClass iClass = cGNode.getClassHierarchy().lookupClass(TypeReference.JavaLangThrowable);
        this.addExceptionDefConstraints(iR, cGNode, list, pointerKey, Collections.singleton(iClass));
    }

    protected void addExceptionDefConstraints(IR iR, CGNode cGNode, List<ProgramCounter> list, PointerKey pointerKey, Set<IClass> set) {
        for (ProgramCounter programCounter : list) {
            Object object;
            Object object2;
            SSAInstruction sSAInstruction = iR.getPEI(programCounter);
            if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                object2 = (SSAAbstractInvokeInstruction)sSAInstruction;
                object = this.heapModel.getPointerKeyForLocal(cGNode, ((SSAAbstractInvokeInstruction)object2).getException());
                this.addNode(pointerKey);
                this.addNode(object);
                this.addEdge(pointerKey, object, AssignLabel.noFilter());
            } else if (sSAInstruction instanceof SSAAbstractThrowInstruction) {
                object2 = (SSAAbstractThrowInstruction)sSAInstruction;
                object = this.heapModel.getPointerKeyForLocal(cGNode, ((SSAAbstractThrowInstruction)object2).getException());
                this.addNode(pointerKey);
                this.addNode(object);
                this.addEdge(pointerKey, object, AssignLabel.noFilter());
            }
            object2 = sSAInstruction.getExceptionTypes();
            if (object2 == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                InstanceKey instanceKey;
                TypeReference typeReference = (TypeReference)object.next();
                if (typeReference == null || (instanceKey = this.heapModel.getInstanceKeyForPEI(cGNode, programCounter, typeReference)) == null) continue;
                if (!(instanceKey instanceof ConcreteTypeKey)) assert (instanceKey instanceof ConcreteTypeKey) : "uh oh: need to implement getCaughtException constraints for instance " + instanceKey;
                ConcreteTypeKey concreteTypeKey = (ConcreteTypeKey)instanceKey;
                IClass iClass = concreteTypeKey.getType();
                if (!PropagationCallGraphBuilder.catches(set, iClass, this.cha)) continue;
                this.addNode(pointerKey);
                this.addNode(instanceKey);
                this.addEdge(pointerKey, instanceKey, NewLabel.v());
            }
        }
    }

    protected void addNodeConstantConstraints(CGNode cGNode, IR iR) {
        SymbolTable symbolTable = iR.getSymbolTable();
        int n = 1;
        while (n <= symbolTable.getMaxValueNumber()) {
            Object object;
            if (symbolTable.isConstant(n) && !((object = symbolTable.getConstantValue(n)) instanceof Number)) {
                InstanceKey instanceKey;
                Object object2 = symbolTable.getConstantValue(n);
                TypeReference typeReference = cGNode.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(object2);
                if (typeReference != null && (instanceKey = this.heapModel.getInstanceKeyForConstant(typeReference, object2)) != null) {
                    PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, n);
                    this.addNode(pointerKey);
                    this.addNode(instanceKey);
                    this.addEdge(pointerKey, instanceKey, NewLabel.v());
                }
            }
            ++n;
        }
    }
}

