/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg.refinepolicy;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.demandpa.alg.refinepolicy.FieldRefinePolicy;
import com.ibm.wala.demandpa.alg.statemachine.StateMachine;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManualFieldPolicy
implements FieldRefinePolicy {
    protected final Pattern refinePattern;
    private static final int NUM_DECISIONS_TO_TRACK = 10;
    private final boolean[] decisions = new boolean[10];
    private int curDecision;
    private final IClass[] encounteredClasses = new IClass[10];
    private final IClassHierarchy cha;

    public boolean shouldRefine(IField iField, PointerKey pointerKey, PointerKey pointerKey2, IFlowLabel iFlowLabel, StateMachine.State state) {
        if (iField == null) {
            throw new IllegalArgumentException("null field");
        }
        if (iField == ArrayContents.v()) {
            return true;
        }
        IClass iClass = iField.getDeclaringClass();
        Matcher matcher = this.refinePattern.matcher(iClass.toString());
        boolean bl = matcher.find();
        this.recordDecision(iClass, bl);
        return bl;
    }

    private void recordDecision(IClass iClass, boolean bl) {
        IClass iClass2;
        if (this.curDecision < 10 && this.notSuperOfAnyEncountered(iClass2 = this.removeInner(iClass))) {
            this.encounteredClasses[this.curDecision] = iClass2;
            this.decisions[this.curDecision] = bl;
            ++this.curDecision;
        }
    }

    private boolean notSuperOfAnyEncountered(IClass iClass) {
        int n = 0;
        while (n < this.curDecision) {
            if (this.cha.isAssignableFrom(iClass, this.encounteredClasses[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private IClass removeInner(IClass iClass) {
        ClassLoaderReference classLoaderReference = iClass.getClassLoader().getReference();
        String string = iClass.getName().toString();
        int n = string.indexOf(36);
        if (n == -1) {
            return iClass;
        }
        String string2 = string.substring(0, n);
        IClass iClass2 = this.cha.lookupClass(TypeReference.findOrCreate(classLoaderReference, string2));
        assert (iClass2 != null);
        return iClass2;
    }

    public ManualFieldPolicy(IClassHierarchy iClassHierarchy, Pattern pattern) {
        this.cha = iClassHierarchy;
        this.refinePattern = pattern;
    }

    public boolean nextPass() {
        return false;
    }

    public String getHistory() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.curDecision) {
            if (this.decisions[n]) {
                stringBuilder.append("refined ");
            } else {
                stringBuilder.append("skipped ");
            }
            stringBuilder.append(this.encounteredClasses[n]);
            if (n + 1 < this.curDecision) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

