/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThisFilteringHeapModel
implements HeapModel {
    private final HeapModel delegate;
    private final IClassHierarchy cha;

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.delegate.getClassHierarchy();
    }

    @Override
    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode cGNode, int n, FilteredPointerKey.TypeFilter typeFilter) {
        return this.delegate.getFilteredPointerKeyForLocal(cGNode, n, typeFilter);
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode cGNode, NewSiteReference newSiteReference) {
        return this.delegate.getInstanceKeyForAllocation(cGNode, newSiteReference);
    }

    @Override
    public InstanceKey getInstanceKeyForClassObject(TypeReference typeReference) {
        return this.delegate.getInstanceKeyForClassObject(typeReference);
    }

    public InstanceKey getInstanceKeyForConstant(TypeReference typeReference, Object object) {
        return this.delegate.getInstanceKeyForConstant(typeReference, object);
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode cGNode, NewSiteReference newSiteReference, int n) {
        return this.delegate.getInstanceKeyForMultiNewArray(cGNode, newSiteReference, n);
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode cGNode, ProgramCounter programCounter, TypeReference typeReference) {
        return this.delegate.getInstanceKeyForPEI(cGNode, programCounter, typeReference);
    }

    @Override
    public PointerKey getPointerKeyForArrayContents(InstanceKey instanceKey) {
        return this.delegate.getPointerKeyForArrayContents(instanceKey);
    }

    @Override
    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode cGNode) {
        return this.delegate.getPointerKeyForExceptionalReturnValue(cGNode);
    }

    @Override
    public PointerKey getPointerKeyForInstanceField(InstanceKey instanceKey, IField iField) {
        return this.delegate.getPointerKeyForInstanceField(instanceKey, iField);
    }

    @Override
    public PointerKey getPointerKeyForLocal(CGNode cGNode, int n) {
        if (!cGNode.getMethod().isStatic() && n == 1) {
            return this.delegate.getFilteredPointerKeyForLocal(cGNode, n, this.getFilter(cGNode));
        }
        return this.delegate.getPointerKeyForLocal(cGNode, n);
    }

    private FilteredPointerKey.TypeFilter getFilter(CGNode cGNode) {
        FilteredPointerKey.TypeFilter typeFilter = (FilteredPointerKey.TypeFilter)cGNode.getContext().get(ContextKey.FILTER);
        if (typeFilter != null) {
            return typeFilter;
        }
        IClass iClass = this.getReceiverClass(cGNode.getMethod());
        return new FilteredPointerKey.SingleClassFilter(iClass);
    }

    private IClass getReceiverClass(IMethod iMethod) {
        TypeReference typeReference = iMethod.getParameterType(0);
        IClass iClass = this.cha.lookupClass(typeReference);
        if (iMethod.isStatic()) {
            Assertions.UNREACHABLE("asked for receiver of static method " + iMethod);
        }
        if (iClass == null) {
            Assertions.UNREACHABLE("no class found for " + typeReference + " recv of " + iMethod);
        }
        return iClass;
    }

    @Override
    public PointerKey getPointerKeyForReturnValue(CGNode cGNode) {
        return this.delegate.getPointerKeyForReturnValue(cGNode);
    }

    @Override
    public PointerKey getPointerKeyForStaticField(IField iField) {
        return this.delegate.getPointerKeyForStaticField(iField);
    }

    @Override
    public Iterator<PointerKey> iteratePointerKeys() {
        return this.delegate.iteratePointerKeys();
    }

    public ThisFilteringHeapModel(HeapModel heapModel, IClassHierarchy iClassHierarchy) {
        if (heapModel == null) {
            throw new IllegalArgumentException("delegate null");
        }
        this.delegate = heapModel;
        this.cha = iClassHierarchy;
    }
}

