/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.demandpa.alg.CallStack;
import com.ibm.wala.demandpa.alg.statemachine.StateMachine;
import com.ibm.wala.demandpa.alg.statemachine.StateMachineFactory;
import com.ibm.wala.demandpa.alg.statemachine.StatesMergedException;
import com.ibm.wala.demandpa.flowgraph.AssignBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.GetFieldBarLabel;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.flowgraph.MatchBarLabel;
import com.ibm.wala.demandpa.flowgraph.MatchLabel;
import com.ibm.wala.demandpa.flowgraph.NewBarLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.ParamBarLabel;
import com.ibm.wala.demandpa.flowgraph.ParamLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldBarLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnBarLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnLabel;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextSensitiveStateMachine
implements StateMachine<IFlowLabel> {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RECURSION = false;
    private final CallStack emptyStack = CallStack.emptyCallStack();
    private final RecursionHandler recursionHandler;

    @Override
    public CallStack getStartState() {
        return this.emptyStack;
    }

    @Override
    public StateMachine.State transition(StateMachine.State state, IFlowLabel iFlowLabel) throws IllegalArgumentException, IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("prevState == null");
        }
        if (!(state instanceof CallStack)) {
            throw new IllegalArgumentException("not ( prevState instanceof com.ibm.wala.demandpa.alg.CallStack ) ");
        }
        CallStack callStack = (CallStack)state;
        if (!callStack.isEmpty() && this.recursionHandler.isRecursive((CallerSiteContext)callStack.peek())) {
            assert (false);
            return this.transition((StateMachine.State)callStack.pop(), iFlowLabel);
        }
        CSLabelVisitor cSLabelVisitor = new CSLabelVisitor(callStack);
        iFlowLabel.visit(cSLabelVisitor, null);
        return cSLabelVisitor.nextState;
    }

    private ContextSensitiveStateMachine(RecursionHandler recursionHandler) {
        this.recursionHandler = recursionHandler;
    }

    /* synthetic */ ContextSensitiveStateMachine(RecursionHandler recursionHandler, ContextSensitiveStateMachine contextSensitiveStateMachine) {
        this(recursionHandler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicRecursionHandler
    implements RecursionHandler {
        private final HashSet<CallerSiteContext> recursiveCallSites = HashSetFactory.make();

        @Override
        public boolean isRecursive(CallerSiteContext callerSiteContext) {
            return this.recursiveCallSites.contains(callerSiteContext);
        }

        @Override
        public void makeRecursive(Collection<CallerSiteContext> collection) {
            this.recursiveCallSites.addAll(collection);
        }

        @Override
        public RecursionHandler makeNew() {
            return new BasicRecursionHandler();
        }
    }

    private class CSLabelVisitor
    implements IFlowLabel.IFlowLabelVisitor {
        final CallStack prevStack;
        StateMachine.State nextState = null;

        CSLabelVisitor(CallStack callStack) {
            this.prevStack = callStack;
        }

        public void visitAssign(AssignLabel assignLabel, Object object) {
            this.nextState = this.prevStack;
        }

        public void visitAssignBar(AssignBarLabel assignBarLabel, Object object) {
            this.nextState = this.prevStack;
        }

        public void visitAssignGlobal(AssignGlobalLabel assignGlobalLabel, Object object) {
            this.nextState = ContextSensitiveStateMachine.this.emptyStack;
        }

        public void visitAssignGlobalBar(AssignGlobalBarLabel assignGlobalBarLabel, Object object) {
            this.nextState = ContextSensitiveStateMachine.this.emptyStack;
        }

        public void visitGetField(GetFieldLabel getFieldLabel, Object object) {
            this.nextState = this.prevStack;
        }

        public void visitGetFieldBar(GetFieldBarLabel getFieldBarLabel, Object object) {
            this.nextState = this.prevStack;
        }

        public void visitMatch(MatchLabel matchLabel, Object object) {
            this.nextState = ContextSensitiveStateMachine.this.emptyStack;
        }

        public void visitMatchBar(MatchBarLabel matchBarLabel, Object object) {
            this.nextState = ContextSensitiveStateMachine.this.emptyStack;
        }

        public void visitNew(NewLabel newLabel, Object object) {
            this.nextState = this.prevStack;
        }

        public void visitNewBar(NewBarLabel newBarLabel, Object object) {
            this.nextState = this.prevStack;
        }

        public void visitParam(ParamLabel paramLabel, Object object) {
            this.handleMethodExit(paramLabel.getCallSite());
        }

        private void handleMethodExit(CallerSiteContext callerSiteContext) {
            this.nextState = ContextSensitiveStateMachine.this.recursionHandler.isRecursive(callerSiteContext) ? this.prevStack : (this.prevStack.isEmpty() ? this.prevStack : (((CallerSiteContext)this.prevStack.peek()).equals(callerSiteContext) ? this.prevStack.pop() : ERROR));
        }

        public void visitParamBar(ParamBarLabel paramBarLabel, Object object) {
            this.handleMethodEntry(paramBarLabel.getCallSite());
        }

        private void handleMethodEntry(CallerSiteContext callerSiteContext) {
            if (ContextSensitiveStateMachine.this.recursionHandler.isRecursive(callerSiteContext)) {
                this.nextState = this.prevStack;
            } else {
                if (this.prevStack.contains(callerSiteContext)) {
                    CallerSiteContext callerSiteContext2 = null;
                    CallStack callStack = this.prevStack;
                    HashSet<CallerSiteContext> hashSet = HashSetFactory.make();
                    do {
                        callerSiteContext2 = (CallerSiteContext)callStack.peek();
                        hashSet.add(callerSiteContext2);
                        callStack = callStack.pop();
                    } while (!callerSiteContext2.equals(callerSiteContext) && !callStack.isEmpty());
                    ContextSensitiveStateMachine.this.recursionHandler.makeRecursive(hashSet);
                    throw new StatesMergedException();
                }
                this.nextState = this.prevStack.push(callerSiteContext);
            }
        }

        public void visitPutField(PutFieldLabel putFieldLabel, Object object) {
            this.nextState = this.prevStack;
        }

        public void visitPutFieldBar(PutFieldBarLabel putFieldBarLabel, Object object) {
            this.nextState = this.prevStack;
        }

        public void visitReturn(ReturnLabel returnLabel, Object object) {
            this.handleMethodEntry(returnLabel.getCallSite());
        }

        public void visitReturnBar(ReturnBarLabel returnBarLabel, Object object) {
            this.handleMethodExit(returnBarLabel.getCallSite());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements StateMachineFactory<IFlowLabel> {
        private final RecursionHandler prototype;

        public Factory(RecursionHandler recursionHandler) {
            this.prototype = recursionHandler;
        }

        public Factory() {
            this(new BasicRecursionHandler());
        }

        @Override
        public StateMachine<IFlowLabel> make() {
            return new ContextSensitiveStateMachine(this.prototype.makeNew(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RecursionHandler {
        public boolean isRecursive(CallerSiteContext var1);

        public void makeRecursive(Collection<CallerSiteContext> var1);

        public RecursionHandler makeNew();
    }
}

