/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.ssa;

import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixedpoint.impl.NullaryOperator;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSAInference<T extends IVariable>
extends DefaultFixedPointSolver<T> {
    static final boolean DEBUG = false;
    private IR ir;
    private SymbolTable symbolTable;
    private IVariable[] vars;

    protected void init(IR iR, VariableFactory variableFactory, OperatorFactory<T> operatorFactory) {
        this.ir = iR;
        this.symbolTable = iR.getSymbolTable();
        this.createVariables(variableFactory);
        this.createEquations(operatorFactory);
    }

    private void createEquations(OperatorFactory<T> operatorFactory) {
        SSAInstruction sSAInstruction;
        SSAInstruction[] sSAInstructionArray = this.ir.getInstructions();
        int n = 0;
        while (n < sSAInstructionArray.length) {
            sSAInstruction = sSAInstructionArray[n];
            this.makeEquationForInstruction(operatorFactory, sSAInstruction);
            ++n;
        }
        Iterator<? extends SSAInstruction> iterator = this.ir.iteratePhis();
        while (iterator.hasNext()) {
            sSAInstruction = iterator.next();
            this.makeEquationForInstruction(operatorFactory, sSAInstruction);
        }
        iterator = this.ir.iteratePis();
        while (iterator.hasNext()) {
            sSAInstruction = iterator.next();
            this.makeEquationForInstruction(operatorFactory, sSAInstruction);
        }
        iterator = this.ir.iterateCatchInstructions();
        while (iterator.hasNext()) {
            sSAInstruction = iterator.next();
            this.makeEquationForInstruction(operatorFactory, sSAInstruction);
        }
    }

    private void makeEquationForInstruction(OperatorFactory<T> operatorFactory, SSAInstruction sSAInstruction) {
        AbstractOperator<T> abstractOperator;
        if (sSAInstruction != null && sSAInstruction.hasDef() && (abstractOperator = operatorFactory.get(sSAInstruction)) != null) {
            T t = this.getVariable(sSAInstruction.getDef());
            if (abstractOperator instanceof NullaryOperator) {
                this.newStatement(t, (NullaryOperator)abstractOperator, false, false);
            } else {
                int n = sSAInstruction.getNumberOfUses();
                IVariable[] iVariableArray = new IVariable[n];
                int n2 = 0;
                while (n2 < n) {
                    if (sSAInstruction.getUse(n2) > -1) {
                        iVariableArray[n2] = this.getVariable(sSAInstruction.getUse(n2));
                        assert (iVariableArray[n2] != null);
                    }
                    ++n2;
                }
                this.newStatement(t, abstractOperator, iVariableArray, false, false);
            }
        }
    }

    private void createVariables(VariableFactory variableFactory) {
        this.vars = new IVariable[this.symbolTable.getMaxValueNumber() + 1];
        int n = 1;
        while (n < this.vars.length) {
            this.vars[n] = variableFactory.makeVariable(n);
            ++n;
        }
    }

    protected T getVariable(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal valueNumber " + n);
        }
        assert (this.vars != null) : "null vars array";
        return (T)this.vars[n];
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Type inference : \n");
        int n = 0;
        while (n < this.vars.length) {
            stringBuffer.append("v").append(n).append("  ").append(this.vars[n]).append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OperatorFactory<T extends IVariable> {
        public AbstractOperator<T> get(SSAInstruction var1);
    }

    public static interface VariableFactory {
        public IVariable makeVariable(int var1);
    }
}

