/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Iterator;

public class LocalPathEdges {
    private static final boolean PARANOID = false;
    private final SparseVector<IBinaryNaturalRelation> paths = new SparseVector(1, 1.1f);
    private final SparseVector<IBinaryNaturalRelation> altPaths;
    private final SparseVector<IntSet> identityPaths = new SparseVector(1, 1.1f);
    private final SparseVector<IntSet> zeroPaths = new SparseVector(1, 1.1f);

    public LocalPathEdges(boolean bl) {
        this.altPaths = bl ? new SparseVector(1, 1.1f) : null;
    }

    public void addPathEdge(int n, int n2, int n3) {
        if (n == 0) {
            this.addZeroPathEdge(n2, n3);
        } else if (n == n3) {
            this.addIdentityPathEdge(n, n2);
        } else {
            IBinaryNaturalRelation iBinaryNaturalRelation = this.paths.get(n3);
            if (iBinaryNaturalRelation == null) {
                iBinaryNaturalRelation = new BasicNaturalRelation(new byte[]{2}, 1);
                this.paths.set(n3, iBinaryNaturalRelation);
            }
            iBinaryNaturalRelation.add(n2, n);
            if (this.altPaths != null) {
                IBinaryNaturalRelation iBinaryNaturalRelation2 = this.altPaths.get(n);
                if (iBinaryNaturalRelation2 == null) {
                    iBinaryNaturalRelation2 = new BasicNaturalRelation(new byte[]{2}, 1);
                    this.altPaths.set(n, iBinaryNaturalRelation2);
                }
                iBinaryNaturalRelation2.add(n2, n3);
            }
        }
    }

    private void addIdentityPathEdge(int n, int n2) {
        BitVectorIntSet bitVectorIntSet = (BitVectorIntSet)this.identityPaths.get(n);
        if (bitVectorIntSet == null) {
            bitVectorIntSet = new BitVectorIntSet();
            this.identityPaths.set(n, bitVectorIntSet);
        }
        bitVectorIntSet.add(n2);
        if (this.altPaths != null) {
            IBinaryNaturalRelation iBinaryNaturalRelation = this.altPaths.get(n);
            if (iBinaryNaturalRelation == null) {
                iBinaryNaturalRelation = new BasicNaturalRelation(new byte[]{2}, 1);
                this.altPaths.set(n, iBinaryNaturalRelation);
            }
            iBinaryNaturalRelation.add(n2, n);
        }
    }

    private void addZeroPathEdge(int n, int n2) {
        BitVectorIntSet bitVectorIntSet = (BitVectorIntSet)this.zeroPaths.get(n2);
        if (bitVectorIntSet == null) {
            bitVectorIntSet = new BitVectorIntSet();
            this.zeroPaths.set(n2, bitVectorIntSet);
        }
        bitVectorIntSet.add(n);
        if (this.altPaths != null) {
            IBinaryNaturalRelation iBinaryNaturalRelation = this.altPaths.get(0);
            if (iBinaryNaturalRelation == null) {
                iBinaryNaturalRelation = new BasicNaturalRelation(new byte[]{2}, 1);
                this.altPaths.set(0, iBinaryNaturalRelation);
            }
            iBinaryNaturalRelation.add(n, n2);
        }
    }

    public IntSet getInverse(int n, int n2) {
        IBinaryNaturalRelation iBinaryNaturalRelation = this.paths.get(n2);
        BitVectorIntSet bitVectorIntSet = (BitVectorIntSet)this.identityPaths.get(n2);
        BitVectorIntSet bitVectorIntSet2 = (BitVectorIntSet)this.zeroPaths.get(n2);
        if (iBinaryNaturalRelation == null) {
            if (bitVectorIntSet == null) {
                if (bitVectorIntSet2 == null) {
                    return null;
                }
                return bitVectorIntSet2.contains(n) ? SparseIntSet.singleton(0) : null;
            }
            if (bitVectorIntSet.contains(n)) {
                if (bitVectorIntSet2 == null) {
                    return SparseIntSet.singleton(n2);
                }
                return bitVectorIntSet2.contains(n) ? SparseIntSet.pair(0, n2) : SparseIntSet.singleton(n2);
            }
            return null;
        }
        if (bitVectorIntSet == null) {
            if (bitVectorIntSet2 == null) {
                return iBinaryNaturalRelation.getRelated(n);
            }
            if (bitVectorIntSet2.contains(n)) {
                IntSet intSet = iBinaryNaturalRelation.getRelated(n);
                if (intSet == null) {
                    return SparseIntSet.singleton(0);
                }
                MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(intSet);
                mutableSparseIntSet.add(0);
                return mutableSparseIntSet;
            }
            return iBinaryNaturalRelation.getRelated(n);
        }
        if (bitVectorIntSet.contains(n)) {
            IntSet intSet = iBinaryNaturalRelation.getRelated(n);
            if (intSet == null) {
                if (bitVectorIntSet2 == null || !bitVectorIntSet2.contains(n)) {
                    return SparseIntSet.singleton(n2);
                }
                return SparseIntSet.pair(0, n2);
            }
            MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(intSet);
            mutableSparseIntSet.add(n2);
            if (bitVectorIntSet2 != null && bitVectorIntSet2.contains(n)) {
                mutableSparseIntSet.add(0);
            }
            return mutableSparseIntSet;
        }
        if (bitVectorIntSet2 == null || !bitVectorIntSet2.contains(n)) {
            return iBinaryNaturalRelation.getRelated(n);
        }
        IntSet intSet = iBinaryNaturalRelation.getRelated(n);
        MutableSparseIntSet mutableSparseIntSet = intSet == null ? MutableSparseIntSet.makeEmpty() : MutableSparseIntSet.make(intSet);
        mutableSparseIntSet.add(0);
        return mutableSparseIntSet;
    }

    public boolean contains(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid n: " + n2);
        }
        if (n == 0) {
            BitVectorIntSet bitVectorIntSet = (BitVectorIntSet)this.zeroPaths.get(n3);
            return bitVectorIntSet != null && bitVectorIntSet.contains(n2);
        }
        if (n == n3) {
            BitVectorIntSet bitVectorIntSet = (BitVectorIntSet)this.identityPaths.get(n);
            return bitVectorIntSet != null && bitVectorIntSet.contains(n2);
        }
        IBinaryNaturalRelation iBinaryNaturalRelation = this.paths.get(n3);
        if (iBinaryNaturalRelation == null) {
            return false;
        }
        return iBinaryNaturalRelation.contains(n2, n);
    }

    public IntSet getReachable(int n, int n2) {
        return this.altPaths == null ? this.getReachableSlow(n, n2) : this.getReachableFast(n, n2);
    }

    private IntSet getReachableSlow(int n, int n2) {
        Object object;
        int n3;
        IntIterator intIterator;
        Iterator<IntSet> iterator;
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        if (this.paths.size() > 0) {
            iterator = this.paths.iterator();
            intIterator = this.paths.iterateIndices();
            while (intIterator.hasNext()) {
                n3 = intIterator.next();
                object = (IBinaryNaturalRelation)((Object)iterator.next());
                if (object == null || !object.contains(n, n2)) continue;
                mutableSparseIntSet.add(n3);
            }
        }
        if (this.identityPaths.size() > 0 && (iterator = (BitVectorIntSet)this.identityPaths.get(n2)) != null && ((BitVectorIntSet)((Object)iterator)).contains(n)) {
            mutableSparseIntSet.add(n2);
        }
        if (n2 == 0 && this.zeroPaths.size() > 0) {
            iterator = this.zeroPaths.iterator();
            intIterator = this.zeroPaths.iterateIndices();
            while (intIterator.hasNext()) {
                n3 = intIterator.next();
                object = (BitVectorIntSet)iterator.next();
                if (object == null || !((BitVectorIntSet)object).contains(n)) continue;
                mutableSparseIntSet.add(n3);
            }
        }
        return mutableSparseIntSet;
    }

    private IntSet getReachableFast(int n, int n2) {
        IBinaryNaturalRelation iBinaryNaturalRelation = this.altPaths.get(n2);
        if (iBinaryNaturalRelation != null) {
            return iBinaryNaturalRelation.getRelated(n);
        }
        return null;
    }

    public IntSet getReachable(int n) {
        Object object;
        int n2;
        IntIterator intIterator;
        Iterator<Object> iterator;
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        if (this.paths.size() > 0) {
            iterator = this.paths.iterator();
            intIterator = this.paths.iterateIndices();
            while (intIterator.hasNext()) {
                n2 = intIterator.next();
                object = (IBinaryNaturalRelation)iterator.next();
                if (object == null || !object.anyRelated(n)) continue;
                mutableSparseIntSet.add(n2);
            }
        }
        if (this.identityPaths.size() > 0) {
            iterator = this.identityPaths.iterator();
            intIterator = this.identityPaths.iterateIndices();
            while (intIterator.hasNext()) {
                n2 = intIterator.next();
                object = (BitVectorIntSet)iterator.next();
                if (object == null || !((BitVectorIntSet)object).contains(n)) continue;
                mutableSparseIntSet.add(n2);
            }
        }
        if (this.zeroPaths.size() > 0) {
            iterator = this.zeroPaths.iterator();
            intIterator = this.zeroPaths.iterateIndices();
            while (intIterator.hasNext()) {
                n2 = intIterator.next();
                object = (BitVectorIntSet)iterator.next();
                if (object == null || !((BitVectorIntSet)object).contains(n)) continue;
                mutableSparseIntSet.add(n2);
            }
        }
        return mutableSparseIntSet;
    }

    public IntSet getReachedNodeNumbers() {
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        if (this.paths.size() > 0) {
            for (IBinaryNaturalRelation object : this.paths) {
                for (IntPair intPair : object) {
                    mutableSparseIntSet.add(intPair.getX());
                }
            }
        }
        if (this.identityPaths.size() > 0) {
            for (IntSet intSet : this.identityPaths) {
                mutableSparseIntSet.addAll(intSet);
            }
        }
        if (this.zeroPaths.size() > 0) {
            for (IntSet intSet : this.zeroPaths) {
                mutableSparseIntSet.addAll(intSet);
            }
        }
        return mutableSparseIntSet;
    }
}

