/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cfg.ExplodedInterproceduralCFG;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICFGSupergraph
implements ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> {
    private final AnalysisCache analysisCache;
    private final AnalysisOptions options = new AnalysisOptions();
    private final ExplodedInterproceduralCFG icfg;

    protected ICFGSupergraph(ExplodedInterproceduralCFG explodedInterproceduralCFG, AnalysisCache analysisCache) {
        this.icfg = explodedInterproceduralCFG;
        this.analysisCache = analysisCache;
    }

    public static ICFGSupergraph make(CallGraph callGraph, AnalysisCache analysisCache) {
        ICFGSupergraph iCFGSupergraph = new ICFGSupergraph(ExplodedInterproceduralCFG.make(callGraph), analysisCache);
        return iCFGSupergraph;
    }

    @Override
    public Graph<? extends CGNode> getProcedureGraph() {
        return this.icfg.getCallGraph();
    }

    public IClassHierarchy getClassHierarchy() {
        return this.icfg.getCallGraph().getClassHierarchy();
    }

    public IR getIR(IMethod iMethod, Context context) {
        IR iR = this.analysisCache.getSSACache().findOrCreateIR(iMethod, context, this.options.getSSAOptions());
        return iR;
    }

    public IR getIR(CGNode cGNode) {
        IR iR = this.analysisCache.getSSACache().findOrCreateIR(cGNode.getMethod(), cGNode.getContext(), this.options.getSSAOptions());
        return iR;
    }

    @Override
    public byte classifyEdge(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext, BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext2) {
        if (this.isCall(basicBlockInContext)) {
            if (this.isEntry(basicBlockInContext2)) {
                return 0;
            }
            return 2;
        }
        if (this.isExit(basicBlockInContext)) {
            return 1;
        }
        return 3;
    }

    @Override
    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> getCallSites(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext, CGNode cGNode) {
        return this.icfg.getCallSites(basicBlockInContext, cGNode);
    }

    @Override
    public Iterator<? extends BasicBlockInContext<IExplodedBasicBlock>> getCalledNodes(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        Filter<BasicBlockInContext<IExplodedBasicBlock>> filter = new Filter<BasicBlockInContext<IExplodedBasicBlock>>(){

            @Override
            public boolean accepts(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
                return basicBlockInContext.isEntryBlock();
            }
        };
        return new FilterIterator(this.getSuccNodes(basicBlockInContext), filter);
    }

    public BasicBlockInContext<IExplodedBasicBlock>[] getEntriesForProcedure(CGNode cGNode) {
        return new BasicBlockInContext[]{this.icfg.getEntry(cGNode)};
    }

    public BasicBlockInContext<IExplodedBasicBlock>[] getExitsForProcedure(CGNode cGNode) {
        return new BasicBlockInContext[]{this.icfg.getExit(cGNode)};
    }

    @Override
    public BasicBlockInContext<IExplodedBasicBlock> getLocalBlock(CGNode cGNode, int n) {
        IExplodedBasicBlock iExplodedBasicBlock = (IExplodedBasicBlock)this.icfg.getCFG(cGNode).getNode(n);
        return new BasicBlockInContext<IExplodedBasicBlock>(cGNode, iExplodedBasicBlock);
    }

    @Override
    public int getLocalBlockNumber(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return basicBlockInContext.getDelegate().getNumber();
    }

    public BasicBlockInContext<IExplodedBasicBlock> getMainEntry() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> getNormalSuccessors(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return EmptyIterator.instance();
    }

    @Override
    public int getNumberOfBlocks(CGNode cGNode) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public CGNode getProcOf(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.getCGNode(basicBlockInContext);
    }

    @Override
    public Iterator<? extends BasicBlockInContext<IExplodedBasicBlock>> getReturnSites(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext, CGNode cGNode) {
        return this.icfg.getReturnSites(basicBlockInContext);
    }

    @Override
    public boolean isCall(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return basicBlockInContext.getDelegate().getInstruction() instanceof SSAAbstractInvokeInstruction;
    }

    @Override
    public boolean isEntry(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return basicBlockInContext.getDelegate().isEntryBlock();
    }

    @Override
    public boolean isExit(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return basicBlockInContext.getDelegate().isExitBlock();
    }

    @Override
    public boolean isReturn(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.isReturn(basicBlockInContext);
    }

    @Override
    public void removeNodeAndEdges(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addNode(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean containsNode(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.containsNode(basicBlockInContext);
    }

    @Override
    public int getNumberOfNodes() {
        return this.icfg.getNumberOfNodes();
    }

    @Override
    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> iterator() {
        return this.icfg.iterator();
    }

    @Override
    public void removeNode(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addEdge(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext, BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext2) {
        Assertions.UNREACHABLE();
    }

    @Override
    public int getPredNodeCount(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.getPredNodeCount(basicBlockInContext);
    }

    @Override
    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> getPredNodes(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.getPredNodes(basicBlockInContext);
    }

    @Override
    public int getSuccNodeCount(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.getSuccNodeCount(basicBlockInContext);
    }

    @Override
    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> getSuccNodes(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.getSuccNodes(basicBlockInContext);
    }

    @Override
    public boolean hasEdge(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext, BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext2) {
        return this.icfg.hasEdge(basicBlockInContext, basicBlockInContext2);
    }

    @Override
    public void removeAllIncidentEdges(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeEdge(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext, BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext2) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeIncomingEdges(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public int getMaxNumber() {
        return this.icfg.getMaxNumber();
    }

    @Override
    public BasicBlockInContext<IExplodedBasicBlock> getNode(int n) {
        return this.icfg.getNode(n);
    }

    @Override
    public int getNumber(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.getNumber(basicBlockInContext);
    }

    @Override
    public Iterator<BasicBlockInContext<IExplodedBasicBlock>> iterateNodes(IntSet intSet) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.getPredNodeNumbers(basicBlockInContext);
    }

    @Override
    public IntSet getSuccNodeNumbers(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.getSuccNodeNumbers(basicBlockInContext);
    }

    public ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> getCFG(BasicBlockInContext<IExplodedBasicBlock> basicBlockInContext) {
        return this.icfg.getCFG(basicBlockInContext);
    }

    public ExplodedInterproceduralCFG getICFG() {
        return this.icfg;
    }

    public String toString() {
        return this.icfg.toString();
    }
}

