/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.client;

import com.ibm.wala.analysis.pointers.BasicHeapGraph;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.client.AnalysisEngine;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefaultIRFactory;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalysisEngine
implements AnalysisEngine {
    public static final String SYNTHETIC_J2SE_MODEL = "SyntheticJ2SEModel.txt";
    protected static final int DEBUG_LEVEL = 1;
    private String exclusionsFile = "J2SEClassHierarchyExclusions.txt";
    protected Collection moduleFiles;
    protected AnalysisScope scope;
    private AnalysisOptions options;
    private AnalysisCache cache = this.makeDefaultCache();
    protected Module[] j2seLibs;
    private boolean closedWorld = false;
    private IClassHierarchy cha;
    protected CallGraph cg;
    protected PointerAnalysis pointerAnalysis;
    private HeapGraph heapGraph;
    private EntrypointBuilder entrypointBuilder = new EntrypointBuilder(){

        @Override
        public Iterable<Entrypoint> createEntrypoints(AnalysisScope analysisScope, IClassHierarchy iClassHierarchy) {
            return AbstractAnalysisEngine.this.makeDefaultEntrypoints(analysisScope, iClassHierarchy);
        }
    };

    protected abstract CallGraphBuilder getCallGraphBuilder(IClassHierarchy var1, AnalysisOptions var2, AnalysisCache var3);

    protected CallGraphBuilder buildCallGraph(IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, boolean bl, IProgressMonitor iProgressMonitor) throws IllegalArgumentException, CancelException {
        CallGraphBuilder callGraphBuilder = this.getCallGraphBuilder(iClassHierarchy, analysisOptions, this.cache);
        this.cg = callGraphBuilder.makeCallGraph(analysisOptions, iProgressMonitor);
        if (bl) {
            this.pointerAnalysis = callGraphBuilder.getPointerAnalysis();
        }
        return callGraphBuilder;
    }

    @Override
    public void setModuleFiles(Collection collection) {
        this.moduleFiles = collection;
    }

    public void buildAnalysisScope() throws IOException {
        if (this.j2seLibs == null) {
            Assertions.UNREACHABLE("no j2selibs specified. You probably did not call AppAnalysisEngine.setJ2SELibrary.");
        }
        this.scope = AnalysisScopeReader.readJavaScope(SYNTHETIC_J2SE_MODEL, FileProvider.getFile(this.getExclusionsFile()), this.getClass().getClassLoader());
        int n = 0;
        while (n < this.j2seLibs.length) {
            this.scope.addToScope(this.scope.getPrimordialLoader(), this.j2seLibs[n]);
            ++n;
        }
        this.addApplicationModulesToScope();
    }

    public IClassHierarchy buildClassHierarchy() {
        ClassHierarchy classHierarchy = null;
        ClassLoaderFactoryImpl classLoaderFactoryImpl = new ClassLoaderFactoryImpl(this.getScope().getExclusions());
        try {
            classHierarchy = ClassHierarchy.make(this.getScope(), classLoaderFactoryImpl);
        }
        catch (ClassHierarchyException classHierarchyException) {
            System.err.println("Class Hierarchy construction failed");
            System.err.println(classHierarchyException.toString());
            classHierarchyException.printStackTrace();
        }
        return classHierarchy;
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    protected void setClassHierarchy(IClassHierarchy iClassHierarchy) {
        this.cha = iClassHierarchy;
    }

    protected CallGraph getCallGraph() {
        return this.cg;
    }

    protected void addApplicationModulesToScope() {
        ClassLoaderReference classLoaderReference = this.scope.getApplicationLoader();
        for (Object e : this.moduleFiles) {
            if (!(e instanceof Module)) {
                Assertions.UNREACHABLE("Unexpected type: " + e.getClass());
            }
            Module module = (Module)e;
            this.scope.addToScope(classLoaderReference, module);
        }
    }

    @Override
    public void setJ2SELibraries(JarFile[] jarFileArray) {
        if (jarFileArray == null) {
            throw new IllegalArgumentException("libs is null");
        }
        this.j2seLibs = new Module[jarFileArray.length];
        int n = 0;
        while (n < jarFileArray.length) {
            this.j2seLibs[n] = new JarFileModule(jarFileArray[n]);
            ++n;
        }
    }

    @Override
    public void setJ2SELibraries(Module[] moduleArray) {
        if (moduleArray == null) {
            throw new IllegalArgumentException("libs is null");
        }
        this.j2seLibs = new Module[moduleArray.length];
        int n = 0;
        while (n < moduleArray.length) {
            this.j2seLibs[n] = moduleArray[n];
            ++n;
        }
    }

    @Override
    public void setClosedWorld(boolean bl) {
        this.closedWorld = bl;
    }

    public boolean isClosedWorld() {
        return this.closedWorld;
    }

    protected AnalysisScope getScope() {
        return this.scope;
    }

    public PointerAnalysis getPointerAnalysis() {
        return this.pointerAnalysis;
    }

    public HeapGraph getHeapGraph() {
        if (this.heapGraph == null) {
            this.heapGraph = new BasicHeapGraph(this.getPointerAnalysis(), this.cg);
        }
        return this.heapGraph;
    }

    public String getExclusionsFile() {
        return this.exclusionsFile;
    }

    public void setExclusionsFile(String string) {
        this.exclusionsFile = string;
    }

    @Override
    public AnalysisOptions getDefaultOptions(Iterable<Entrypoint> iterable) {
        return new AnalysisOptions(this.getScope(), iterable);
    }

    public AnalysisCache makeDefaultCache() {
        return new AnalysisCache(new DefaultIRFactory());
    }

    protected Iterable<Entrypoint> makeDefaultEntrypoints(AnalysisScope analysisScope, IClassHierarchy iClassHierarchy) {
        return Util.makeMainEntrypoints(analysisScope, iClassHierarchy);
    }

    public void setEntrypointBuilder(EntrypointBuilder entrypointBuilder) {
        this.entrypointBuilder = entrypointBuilder;
    }

    public CallGraphBuilder defaultCallGraphBuilder() throws IllegalArgumentException, CancelException, IOException {
        this.buildAnalysisScope();
        IClassHierarchy iClassHierarchy = this.buildClassHierarchy();
        this.setClassHierarchy(iClassHierarchy);
        Iterable<Entrypoint> iterable = this.entrypointBuilder.createEntrypoints(this.scope, iClassHierarchy);
        this.options = this.getDefaultOptions(iterable);
        this.cache = this.makeDefaultCache();
        return this.buildCallGraph(iClassHierarchy, this.options, true, null);
    }

    public CallGraph buildDefaultCallGraph() throws IllegalArgumentException, CancelException, IOException {
        return this.defaultCallGraphBuilder().makeCallGraph(this.options, null);
    }

    public AnalysisCache getCache() {
        return this.cache;
    }

    public AnalysisOptions getOptions() {
        return this.options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntrypointBuilder {
        public Iterable<Entrypoint> createEntrypoints(AnalysisScope var1, IClassHierarchy var2);
    }
}

