/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryTreeModule
implements Module {
    protected final File root;

    DirectoryTreeModule(File file) throws IllegalArgumentException {
        this.root = file;
        if (file == null) {
            throw new IllegalArgumentException("null root");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("root is not a directory " + file);
        }
    }

    protected abstract FileModule makeFile(File var1);

    protected abstract boolean includeFile(File var1);

    private Set<ModuleEntry> getEntriesRecursive(File file) {
        HashSet<ModuleEntry> hashSet = HashSetFactory.make();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    hashSet.addAll(this.getEntriesRecursive(fileArray[n]));
                } else if (this.includeFile(fileArray[n])) {
                    hashSet.add(this.makeFile(fileArray[n]));
                }
                ++n;
            }
        } else {
            System.err.println("Warning: failed to retrieve files in " + file);
        }
        return hashSet;
    }

    @Override
    public Iterator<ModuleEntry> getEntries() {
        return this.getEntriesRecursive(this.root).iterator();
    }

    public String getPath() {
        return this.root.getAbsolutePath();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.getPath();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.root == null ? 0 : this.root.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DirectoryTreeModule directoryTreeModule = (DirectoryTreeModule)object;
        return !(this.root == null ? directoryTreeModule.root != null : !this.root.equals(directoryTreeModule.root));
    }
}

