/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderImpl;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class ClassLoaderFactoryImpl
implements ClassLoaderFactory {
    private final SetOfClasses exclusions;
    private final HashMap<ClassLoaderReference, IClassLoader> map = HashMapFactory.make(3);

    public ClassLoaderFactoryImpl(SetOfClasses setOfClasses) {
        this.exclusions = setOfClasses;
    }

    public IClassLoader getLoader(ClassLoaderReference classLoaderReference, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope) throws IOException {
        if (classLoaderReference == null) {
            throw new IllegalArgumentException("null classLoaderReference");
        }
        IClassLoader iClassLoader = this.map.get(classLoaderReference);
        if (iClassLoader == null) {
            ClassLoaderReference classLoaderReference2 = classLoaderReference.getParent();
            IClassLoader iClassLoader2 = null;
            if (classLoaderReference2 != null) {
                iClassLoader2 = this.getLoader(classLoaderReference2, iClassHierarchy, analysisScope);
            }
            IClassLoader iClassLoader3 = this.makeNewClassLoader(classLoaderReference, iClassHierarchy, iClassLoader2, analysisScope);
            this.map.put(classLoaderReference, iClassLoader3);
            iClassLoader = iClassLoader3;
        }
        return iClassLoader;
    }

    protected IClassLoader makeNewClassLoader(ClassLoaderReference classLoaderReference, IClassHierarchy iClassHierarchy, IClassLoader iClassLoader, AnalysisScope analysisScope) throws IOException {
        IClassLoader iClassLoader2;
        String string = analysisScope.getLoaderImpl(classLoaderReference);
        if (string == null) {
            iClassLoader2 = new ClassLoaderImpl(classLoaderReference, analysisScope.getArrayClassLoader(), iClassLoader, this.exclusions, iClassHierarchy);
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getDeclaredConstructor(ClassLoaderReference.class, IClassLoader.class, SetOfClasses.class, IClassHierarchy.class);
                iClassLoader2 = (IClassLoader)constructor.newInstance(classLoaderReference, iClassLoader, this.exclusions, iClassHierarchy);
            }
            catch (Exception exception) {
                Warnings.add(InvalidClassLoaderImplementation.create(string));
                iClassLoader2 = new ClassLoaderImpl(classLoaderReference, analysisScope.getArrayClassLoader(), iClassLoader, this.exclusions, iClassHierarchy);
            }
        }
        iClassLoader2.init(analysisScope.getModules(classLoaderReference));
        return iClassLoader2;
    }

    public SetOfClasses getExclusions() {
        return this.exclusions;
    }

    private static class InvalidClassLoaderImplementation
    extends Warning {
        final String impl;

        InvalidClassLoaderImplementation(String string) {
            super((byte)2);
            this.impl = string;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.impl;
        }

        public static InvalidClassLoaderImplementation create(String string) {
            return new InvalidClassLoaderImplementation(string);
        }
    }
}

