/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.HashMap;

public class ArrayClassLoader {
    private static final boolean DEBUG = false;
    private final HashMap<TypeReference, ArrayClass> arrayClasses = HashMapFactory.make();

    public IClass lookupClass(TypeName typeName, IClassLoader iClassLoader, IClassHierarchy iClassHierarchy) throws IllegalArgumentException {
        ArrayClass arrayClass;
        if (iClassLoader == null) {
            throw new IllegalArgumentException("delegator must not be null");
        }
        TypeReference typeReference = TypeReference.findOrCreate(iClassLoader.getReference(), typeName);
        TypeReference typeReference2 = typeReference.getArrayElementType();
        if (typeReference2.isPrimitiveType()) {
            TypeReference typeReference3 = TypeReference.findOrCreateArrayOf(typeReference2);
            arrayClass = this.arrayClasses.get(typeReference3);
            IClassLoader iClassLoader2 = ArrayClassLoader.getRootClassLoader(iClassLoader);
            if (arrayClass == null) {
                arrayClass = new ArrayClass(typeReference3, iClassLoader2, iClassHierarchy);
                this.arrayClasses.put(typeReference3, arrayClass);
            }
        } else {
            arrayClass = this.arrayClasses.get(typeReference);
            if (arrayClass == null) {
                IClass iClass = iClassLoader.lookupClass(typeReference2.getName());
                if (iClass == null) {
                    return null;
                }
                TypeReference typeReference4 = TypeReference.findOrCreateArrayOf(iClass.getReference());
                arrayClass = this.arrayClasses.get(typeReference4);
                if (arrayClass == null) {
                    arrayClass = new ArrayClass(typeReference4, iClass.getClassLoader(), iClassHierarchy);
                }
            }
            this.arrayClasses.put(typeReference, arrayClass);
        }
        return arrayClass;
    }

    private static IClassLoader getRootClassLoader(IClassLoader iClassLoader) {
        while (iClassLoader.getParent() != null) {
            iClassLoader = iClassLoader.getParent();
        }
        return iClassLoader;
    }

    public int getNumberOfClasses() {
        return this.arrayClasses.size();
    }
}

