/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static SSAInstruction getLastInstruction(ControlFlowGraph controlFlowGraph, IBasicBlock iBasicBlock) {
        if (iBasicBlock == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (controlFlowGraph == null) {
            throw new IllegalArgumentException("G is null");
        }
        return (SSAInstruction)controlFlowGraph.getInstructions()[iBasicBlock.getLastInstructionIndex()];
    }

    public static boolean endsWithConditionalBranch(ControlFlowGraph controlFlowGraph, IBasicBlock iBasicBlock) {
        return Util.getLastInstruction(controlFlowGraph, iBasicBlock) instanceof SSAConditionalBranchInstruction;
    }

    public static boolean endsWithSwitch(ControlFlowGraph controlFlowGraph, IBasicBlock iBasicBlock) {
        return Util.getLastInstruction(controlFlowGraph, iBasicBlock) instanceof SSASwitchInstruction;
    }

    public static <I, T extends IBasicBlock<I>> T getFallThruBlock(ControlFlowGraph<I, T> controlFlowGraph, T t) {
        if (t == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (controlFlowGraph == null) {
            throw new IllegalArgumentException("G is null");
        }
        return controlFlowGraph.getBlockForInstruction(t.getLastInstructionIndex() + 1);
    }

    public static <I, T extends IBasicBlock<I>> T getNotTakenSuccessor(ControlFlowGraph<I, T> controlFlowGraph, T t) {
        if (controlFlowGraph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (!Util.endsWithConditionalBranch(controlFlowGraph, t)) {
            throw new IllegalArgumentException(String.valueOf(t.toString()) + " does not end with a conditional branch");
        }
        return Util.getFallThruBlock(controlFlowGraph, t);
    }

    public static <I, T extends IBasicBlock<I>> T getTakenSuccessor(ControlFlowGraph<I, T> controlFlowGraph, T t) {
        if (controlFlowGraph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (!Util.endsWithConditionalBranch(controlFlowGraph, t)) {
            throw new IllegalArgumentException(String.valueOf(t.toString()) + " does not end with a conditional branch");
        }
        T t2 = Util.getNotTakenSuccessor(controlFlowGraph, t);
        Iterator<T> iterator = controlFlowGraph.getSuccNodes(t);
        while (iterator.hasNext()) {
            T t3 = iterator.next();
            if (t3 == t2) continue;
            return t3;
        }
        return t2;
    }

    public static <I, T extends IBasicBlock<I>> T resolveSwitch(ControlFlowGraph<I, T> controlFlowGraph, T t, int n) {
        assert (Util.endsWithSwitch(controlFlowGraph, t));
        SSASwitchInstruction sSASwitchInstruction = (SSASwitchInstruction)Util.getLastInstruction(controlFlowGraph, t);
        int[] nArray = sSASwitchInstruction.getCasesAndLabels();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return controlFlowGraph.getBlockForInstruction(nArray[n2 + 1]);
            }
            n2 += 2;
        }
        return controlFlowGraph.getBlockForInstruction(sSASwitchInstruction.getDefault());
    }

    public static <I, T extends IBasicBlock<I>> boolean isSwitchDefault(ControlFlowGraph<I, T> controlFlowGraph, T t, T t2) {
        if (controlFlowGraph == null) {
            throw new IllegalArgumentException("G is null");
        }
        assert (Util.endsWithSwitch(controlFlowGraph, t));
        SSASwitchInstruction sSASwitchInstruction = (SSASwitchInstruction)Util.getLastInstruction(controlFlowGraph, t);
        assert (controlFlowGraph.getBlockForInstruction(sSASwitchInstruction.getDefault()) != null);
        return controlFlowGraph.getBlockForInstruction(sSASwitchInstruction.getDefault()).equals(t2);
    }

    public static <I, T extends IBasicBlock<I>> int getSwitchLabel(ControlFlowGraph<I, T> controlFlowGraph, T t, T t2) {
        assert (Util.endsWithSwitch(controlFlowGraph, t));
        SSASwitchInstruction sSASwitchInstruction = (SSASwitchInstruction)Util.getLastInstruction(controlFlowGraph, t);
        int[] nArray = sSASwitchInstruction.getCasesAndLabels();
        int n = 0;
        while (n < nArray.length) {
            if (controlFlowGraph.getBlockForInstruction(nArray[n + 1]).equals(t2)) {
                return nArray[n];
            }
            n += 2;
        }
        Assertions.UNREACHABLE();
        return -1;
    }

    public static <I, T extends IBasicBlock<I>> T resolveBranch(ControlFlowGraph<I, T> controlFlowGraph, T t, int n, int n2) {
        SSAConditionalBranchInstruction sSAConditionalBranchInstruction = (SSAConditionalBranchInstruction)Util.getLastInstruction(controlFlowGraph, t);
        switch ((IConditionalBranchInstruction.Operator)sSAConditionalBranchInstruction.getOperator()) {
            case EQ: {
                if (n == n2) {
                    return Util.getTakenSuccessor(controlFlowGraph, t);
                }
                return Util.getNotTakenSuccessor(controlFlowGraph, t);
            }
            case NE: {
                if (n != n2) {
                    return Util.getTakenSuccessor(controlFlowGraph, t);
                }
                return Util.getNotTakenSuccessor(controlFlowGraph, t);
            }
            case LT: {
                if (n < n2) {
                    return Util.getTakenSuccessor(controlFlowGraph, t);
                }
                return Util.getNotTakenSuccessor(controlFlowGraph, t);
            }
            case GE: {
                if (n >= n2) {
                    return Util.getTakenSuccessor(controlFlowGraph, t);
                }
                return Util.getNotTakenSuccessor(controlFlowGraph, t);
            }
            case GT: {
                if (n > n2) {
                    return Util.getTakenSuccessor(controlFlowGraph, t);
                }
                return Util.getNotTakenSuccessor(controlFlowGraph, t);
            }
            case LE: {
                if (n <= n2) {
                    return Util.getTakenSuccessor(controlFlowGraph, t);
                }
                return Util.getNotTakenSuccessor(controlFlowGraph, t);
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public static <I, T extends IBasicBlock<I>> int whichPred(ControlFlowGraph<I, T> controlFlowGraph, T t, T t2) {
        if (controlFlowGraph == null) {
            throw new IllegalArgumentException("cfg is null");
        }
        if (t == null) {
            throw new IllegalArgumentException("a is null");
        }
        if (t2 == null) {
            throw new IllegalArgumentException("b is null");
        }
        int n = 0;
        Iterator<T> iterator = controlFlowGraph.getPredNodes(t2);
        while (iterator.hasNext()) {
            if (iterator.next().equals(t)) {
                return n;
            }
            ++n;
        }
        Assertions.UNREACHABLE("Invalid: a must be a predecessor of b! " + t + " " + t2);
        return -1;
    }
}

