/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InducedCFG
extends AbstractCFG<SSAInstruction, BasicBlock> {
    private static final boolean DEBUG = false;
    private final BasicBlock[] i2block;
    private final Context context;
    private final SSAInstruction[] instructions;

    public InducedCFG(SSAInstruction[] sSAInstructionArray, IMethod iMethod, Context context) {
        super(iMethod);
        if (sSAInstructionArray == null) {
            throw new IllegalArgumentException("instructions is null");
        }
        if (iMethod == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.context = context;
        this.instructions = sSAInstructionArray;
        this.i2block = new BasicBlock[sSAInstructionArray.length];
        if (sSAInstructionArray.length == 0) {
            this.makeEmptyBlocks();
        } else {
            this.makeBasicBlocks();
        }
        this.init();
        this.computeEdges();
    }

    @Override
    public int hashCode() {
        return this.context.hashCode() ^ this.getMethod().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof InducedCFG && this.getMethod().equals(((InducedCFG)object).getMethod()) && this.context.equals(((InducedCFG)object).context);
    }

    public SSAInstruction[] getInstructions() {
        return this.instructions;
    }

    private void computeEdges() {
        for (BasicBlock basicBlock : this) {
            if (basicBlock.equals(this.exit())) continue;
            basicBlock.computeOutgoingEdges();
        }
        this.clearPis(this.getInstructions());
    }

    private void clearPis(SSAInstruction[] sSAInstructionArray) {
        int n = 0;
        while (n < sSAInstructionArray.length) {
            if (sSAInstructionArray[n] instanceof SSAPiInstruction) {
                sSAInstructionArray[n] = null;
            }
            ++n;
        }
    }

    private void makeEmptyBlocks() {
        BasicBlock basicBlock = new BasicBlock(-1);
        this.addNode(basicBlock);
    }

    protected BranchVisitor makeBranchVisitor(boolean[] blArray) {
        return new BranchVisitor(blArray);
    }

    protected PEIVisitor makePEIVisitor(boolean[] blArray) {
        return new PEIVisitor(blArray);
    }

    private void makeBasicBlocks() {
        SSAInstruction[] sSAInstructionArray = this.getInstructions();
        boolean[] blArray = new boolean[sSAInstructionArray.length];
        blArray[0] = true;
        BranchVisitor branchVisitor = this.makeBranchVisitor(blArray);
        PEIVisitor pEIVisitor = this.makePEIVisitor(blArray);
        int n = 0;
        while (n < sSAInstructionArray.length) {
            if (sSAInstructionArray[n] != null) {
                branchVisitor.setIndex(n);
                sSAInstructionArray[n].visit(branchVisitor);
                pEIVisitor.setIndex(n);
                sSAInstructionArray[n].visit(pEIVisitor);
            }
            ++n;
        }
        BasicBlock basicBlock = null;
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                basicBlock = new BasicBlock(n2);
                this.addNode(basicBlock);
                int n3 = n2;
                while (sSAInstructionArray[n3] instanceof SSAPhiInstruction) {
                    basicBlock.addPhi((SSAPhiInstruction)sSAInstructionArray[n3]);
                    ++n3;
                }
            }
            if (sSAInstructionArray[n2] instanceof SSAPiInstruction) {
                basicBlock.addPi((SSAPiInstruction)sSAInstructionArray[n2]);
            }
            this.i2block[n2] = basicBlock;
            ++n2;
        }
        BasicBlock basicBlock2 = new BasicBlock(-1);
        this.addNode(basicBlock2);
        this.clearPhis(sSAInstructionArray);
    }

    private void clearPhis(SSAInstruction[] sSAInstructionArray) {
        int n = 0;
        while (n < sSAInstructionArray.length) {
            if (sSAInstructionArray[n] instanceof SSAPhiInstruction) {
                sSAInstructionArray[n] = null;
            }
            ++n;
        }
    }

    @Override
    public BasicBlock getBlockForInstruction(int n) {
        if (this.i2block[n] == null) {
            Assertions.productionAssertion(false, "unexpected null for " + n);
        }
        return this.i2block[n];
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (BasicBlock basicBlock : this) {
            stringBuffer.append("BB").append(this.getNumber(basicBlock)).append("\n");
            int n = basicBlock.getFirstInstructionIndex();
            while (n <= basicBlock.getLastInstructionIndex()) {
                stringBuffer.append("  ").append(n).append("  ").append(this.getInstructions()[n]).append("\n");
                ++n;
            }
            Iterator<BasicBlock> iterator = this.getSuccNodes(basicBlock);
            while (iterator.hasNext()) {
                stringBuffer.append("    -> BB").append(this.getNumber(iterator.next())).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public int getProgramCounter(int n) {
        if (this.getInstructions().length <= n) {
            throw new IllegalArgumentException("invalid index " + n + " " + this.getInstructions().length);
        }
        if (this.getInstructions()[n] instanceof SSAInvokeInstruction) {
            return ((SSAInvokeInstruction)this.getInstructions()[n]).getCallSite().getProgramCounter();
        }
        return n;
    }

    public Collection<SSAPhiInstruction> getAllPhiInstructions() {
        HashSet<SSAPhiInstruction> hashSet = HashSetFactory.make();
        for (BasicBlock basicBlock : this) {
            hashSet.addAll(basicBlock.getPhis());
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BasicBlock
    extends NodeWithNumber
    implements IBasicBlock<SSAInstruction> {
        private Collection<SSAPhiInstruction> phis;
        private ArrayList<SSAPiInstruction> pis;
        private final int start;

        public Collection<SSAPhiInstruction> getPhis() {
            return this.phis == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.phis);
        }

        public void addPhi(SSAPhiInstruction sSAPhiInstruction) {
            if (this.phis == null) {
                this.phis = new ArrayList<SSAPhiInstruction>(1);
            }
            this.phis.add(sSAPhiInstruction);
        }

        public Collection<SSAPiInstruction> getPis() {
            return this.pis == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.pis);
        }

        public void addPi(SSAPiInstruction sSAPiInstruction) {
            if (this.pis == null) {
                this.pis = new ArrayList(1);
            }
            this.pis.add(sSAPiInstruction);
        }

        public boolean equals(Object object) {
            if (object != null && this.getClass().equals(object.getClass())) {
                BasicBlock basicBlock = (BasicBlock)object;
                return this.start == basicBlock.start && this.getMethod().equals(basicBlock.getMethod());
            }
            return false;
        }

        BasicBlock(int n) {
            this.start = n;
        }

        private void addExceptionalEdges(SSAInstruction sSAInstruction) {
            if (sSAInstruction.isPEI()) {
                this.addExceptionalEdgeTo((BasicBlock)InducedCFG.this.exit());
            }
        }

        private void addNormalEdgeTo(BasicBlock basicBlock) {
            InducedCFG.this.addNormalEdge(this, basicBlock);
        }

        private void addExceptionalEdgeTo(BasicBlock basicBlock) {
            InducedCFG.this.addExceptionalEdge(this, basicBlock);
        }

        private void computeOutgoingEdges() {
            SSAInstruction sSAInstruction = InducedCFG.this.getInstructions()[this.getLastInstructionIndex()];
            this.addExceptionalEdges(sSAInstruction);
            int n = this.getGraphNodeId() + 1;
            this.addNormalEdgeTo((BasicBlock)InducedCFG.this.getNode(n));
            if (this.pis != null) {
                this.updatePiInstrs(n);
            }
            if (sSAInstruction instanceof SSAReturnInstruction) {
                BasicBlock basicBlock = (BasicBlock)InducedCFG.this.exit();
                this.addNormalEdgeTo(basicBlock);
            }
        }

        private void updatePiInstrs(int n) {
            int n2 = 0;
            while (n2 < this.pis.size()) {
                SSAPiInstruction sSAPiInstruction = this.pis.get(n2);
                SSAInstructionFactory sSAInstructionFactory = this.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory();
                this.pis.set(n2, sSAInstructionFactory.PiInstruction(sSAPiInstruction.getDef(), sSAPiInstruction.getVal(), this.getGraphNodeId(), n, sSAPiInstruction.getCause()));
                ++n2;
            }
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.start;
        }

        @Override
        public int getLastInstructionIndex() {
            int n = InducedCFG.this.getNumber((BasicBlock)InducedCFG.this.exit());
            if (this.getGraphNodeId() == n) {
                return -2;
            }
            if (this.getGraphNodeId() == n - 1) {
                return InducedCFG.this.getInstructions().length - 1;
            }
            BasicBlock basicBlock = (BasicBlock)InducedCFG.this.getNode(this.getGraphNodeId() + 1);
            return basicBlock.getFirstInstructionIndex() - 1;
        }

        @Override
        public boolean isCatchBlock() {
            return false;
        }

        public int hashCode() {
            return 1153 * this.getGraphNodeId() + this.getMethod().hashCode();
        }

        public String toString() {
            return "BB[Induced]" + this.getNumber() + " - " + this.getMethod().getSignature();
        }

        @Override
        public boolean isExitBlock() {
            return this.getLastInstructionIndex() == -2;
        }

        @Override
        public boolean isEntryBlock() {
            return this.getNumber() == 0;
        }

        @Override
        public IMethod getMethod() {
            return InducedCFG.this.getMethod();
        }

        public boolean endsInPEI() {
            return InducedCFG.this.getInstructions()[this.getLastInstructionIndex()].isPEI();
        }

        public boolean endsInReturn() {
            return InducedCFG.this.getInstructions()[this.getLastInstructionIndex()] instanceof SSAReturnInstruction;
        }

        @Override
        public int getNumber() {
            return InducedCFG.this.getNumber(this);
        }

        @Override
        public Iterator<SSAInstruction> iterator() {
            return new ArrayIterator<SSAInstruction>(InducedCFG.this.getInstructions(), this.getFirstInstructionIndex(), this.getLastInstructionIndex());
        }
    }

    public class BranchVisitor
    extends SSAInstruction.Visitor {
        private final boolean[] r;
        int index = 0;

        protected BranchVisitor(boolean[] blArray) {
            this.r = blArray;
        }

        void setIndex(int n) {
            this.index = n;
        }

        public void visitGoto(SSAGotoInstruction sSAGotoInstruction) {
            Assertions.UNREACHABLE("haven't implemented logic for goto yet.");
            this.breakBasicBlock(this.index);
        }

        public void visitConditionalBranch(SSAConditionalBranchInstruction sSAConditionalBranchInstruction) {
            Assertions.UNREACHABLE("haven't implemented logic for cbranch yet.");
            this.breakBasicBlock(this.index);
        }

        public void visitSwitch(SSASwitchInstruction sSASwitchInstruction) {
            Assertions.UNREACHABLE("haven't implemented logic for switch yet.");
        }

        public void visitPhi(SSAPhiInstruction sSAPhiInstruction) {
            if (!(InducedCFG.this.instructions[this.index - 1] instanceof SSAPhiInstruction)) {
                this.breakBasicBlock(this.index - 1);
            }
        }

        public void visitReturn(SSAReturnInstruction sSAReturnInstruction) {
            this.breakBasicBlock(this.index);
        }

        public void visitThrow(SSAThrowInstruction sSAThrowInstruction) {
            this.breakBasicBlock(this.index);
        }

        protected void breakBasicBlock(int n) {
            int n2 = n + 1;
            while (n2 < InducedCFG.this.instructions.length && InducedCFG.this.instructions[n2] instanceof SSAPiInstruction) {
                ++n2;
            }
            if (n2 < InducedCFG.this.instructions.length && !this.r[n2]) {
                this.r[n2] = true;
            }
        }
    }

    public class PEIVisitor
    extends SSAInstruction.Visitor {
        private final boolean[] r;
        int index = 0;

        protected PEIVisitor(boolean[] blArray) {
            this.r = blArray;
        }

        void setIndex(int n) {
            this.index = n;
        }

        protected void breakBasicBlock() {
            int n = this.index + 1;
            while (n < InducedCFG.this.instructions.length && InducedCFG.this.instructions[n] instanceof SSAPiInstruction) {
                ++n;
            }
            if (n < InducedCFG.this.instructions.length && !this.r[n]) {
                this.r[n] = true;
            }
        }

        public void visitArrayLength(SSAArrayLengthInstruction sSAArrayLengthInstruction) {
            this.breakBasicBlock();
        }

        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            this.breakBasicBlock();
        }

        public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
            this.breakBasicBlock();
        }

        public void visitCheckCast(SSACheckCastInstruction sSACheckCastInstruction) {
            this.breakBasicBlock();
        }

        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            this.breakBasicBlock();
        }

        public void visitInvoke(SSAInvokeInstruction sSAInvokeInstruction) {
            this.breakBasicBlock();
        }

        public void visitMonitor(SSAMonitorInstruction sSAMonitorInstruction) {
            this.breakBasicBlock();
        }

        public void visitNew(SSANewInstruction sSANewInstruction) {
            this.breakBasicBlock();
        }

        public void visitPut(SSAPutInstruction sSAPutInstruction) {
            this.breakBasicBlock();
        }

        public void visitThrow(SSAThrowInstruction sSAThrowInstruction) {
            this.breakBasicBlock();
        }
    }
}

