/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public class PointType
extends TypeAbstraction {
    private final IClass type;

    public PointType(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = iClass;
        assert (iClass.getReference().isReferenceType());
    }

    public TypeAbstraction meet(TypeAbstraction typeAbstraction) {
        if (typeAbstraction == TOP) {
            return this;
        }
        if (typeAbstraction instanceof PointType) {
            PointType pointType = (PointType)typeAbstraction;
            if (this.type.equals(pointType.type)) {
                return this;
            }
            if (this.type.isArrayClass() || pointType.type.isArrayClass()) {
                return new ConeType(this.type.getClassHierarchy().getRootClass());
            }
            return new ConeType(this.type.getClassHierarchy().getLeastCommonSuperclass(this.type, pointType.type));
        }
        if (typeAbstraction instanceof ConeType) {
            ConeType coneType = (ConeType)typeAbstraction;
            TypeReference typeReference = coneType.getType().getReference();
            if (this.type.isArrayClass() || typeReference.isArrayType()) {
                return new ConeType(this.type.getClassHierarchy().getRootClass());
            }
            IClass iClass = this.type;
            if (this.type.getClassHierarchy().isSubclassOf(iClass, coneType.getType())) {
                return coneType;
            }
            if (coneType.isInterface() && this.type.getClassHierarchy().implementsInterface(iClass, coneType.getType())) {
                return coneType;
            }
            return coneType.meet(new ConeType(this.getType()));
        }
        Assertions.UNREACHABLE("Unexpected type: " + typeAbstraction.getClass());
        return null;
    }

    public String toString() {
        return "point: " + this.type.toString();
    }

    public IClass getType() {
        return this.type;
    }

    public TypeReference getTypeReference() {
        return this.type.getReference();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PointType)) {
            return false;
        }
        PointType pointType = (PointType)object;
        if (!this.type.getClassHierarchy().equals(pointType.type.getClassHierarchy())) {
            Assertions.UNREACHABLE("different chas " + this + " " + pointType);
        }
        return this.type.equals(pointType.type);
    }

    public int hashCode() {
        return 37 * this.type.hashCode();
    }

    public boolean isArrayType() {
        return this.getType().isArrayClass();
    }

    public IClass getIClass() {
        return this.type;
    }
}

