/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

public class ConeType
extends TypeAbstraction {
    private final IClass type;

    public ConeType(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("type is null");
        }
        assert (iClass.getReference().isReferenceType());
        this.type = iClass;
    }

    public TypeAbstraction meet(TypeAbstraction typeAbstraction) {
        if (typeAbstraction == TOP) {
            return this;
        }
        if (typeAbstraction instanceof ConeType) {
            ConeType coneType = (ConeType)typeAbstraction;
            if (this.type.equals(coneType.type)) {
                return this;
            }
            if (this.type.isArrayClass() || coneType.type.isArrayClass()) {
                return new ConeType(this.type.getClassHierarchy().getRootClass());
            }
            return new ConeType(this.type.getClassHierarchy().getLeastCommonSuperclass(this.type, coneType.type));
        }
        if (typeAbstraction instanceof PointType) {
            return typeAbstraction.meet(this);
        }
        if (typeAbstraction instanceof PrimitiveType) {
            return TOP;
        }
        Assertions.UNREACHABLE("unexpected type " + typeAbstraction.getClass());
        return null;
    }

    public String toString() {
        return "cone:" + this.type.toString();
    }

    public IClass getType() {
        return this.type;
    }

    public TypeReference getTypeReference() {
        return this.type.getReference();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConeType)) {
            return false;
        }
        ConeType coneType = (ConeType)object;
        if (coneType == TOP) {
            return false;
        }
        if (!this.type.getClassHierarchy().equals(coneType.type.getClassHierarchy())) {
            Assertions.UNREACHABLE("different chas " + this + " " + coneType);
        }
        return this.type.equals(coneType.type);
    }

    public int hashCode() {
        return 39 * this.type.hashCode();
    }

    public boolean isArrayType() {
        return this.getType().isArrayClass();
    }

    public boolean isInterface() {
        return this.getType().isInterface();
    }

    public Iterator iterateImplementors() {
        return this.type.getClassHierarchy().getImplementors(this.getType().getReference()).iterator();
    }

    public IClassHierarchy getClassHierarchy() {
        return this.type.getClassHierarchy();
    }
}

