/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.stackMachine;

import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BasicFramework;
import com.ibm.wala.dataflow.graph.DataflowSolver;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixedpoint.impl.AbstractVariable;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.shrike.ShrikeUtil;
import java.util.Iterator;

public abstract class AbstractIntStackMachine
implements FixedPointConstants {
    private static final boolean DEBUG = false;
    public static final int TOP = -1;
    public static final int BOTTOM = -2;
    public static final int UNANALYZED = -3;
    public static final int IGNORE = -4;
    private DataflowSolver solver;
    private final ShrikeCFG cfg;
    private final int maxStackHeight;
    protected final int maxLocals;
    public static final boolean OPTIMISTIC = true;

    protected AbstractIntStackMachine(ShrikeCFG shrikeCFG) {
        if (shrikeCFG == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.maxStackHeight = shrikeCFG.getMaxStackHeight();
        this.maxLocals = shrikeCFG.getMaxLocals();
        this.cfg = shrikeCFG;
    }

    protected void init(Meeter meeter, final FlowProvider flowProvider) {
        final MeetOperator meetOperator = new MeetOperator(meeter);
        ITransferFunctionProvider<ShrikeCFG.BasicBlock, MachineState> iTransferFunctionProvider = new ITransferFunctionProvider<ShrikeCFG.BasicBlock, MachineState>(){

            @Override
            public boolean hasNodeTransferFunctions() {
                return flowProvider.needsNodeFlow();
            }

            @Override
            public boolean hasEdgeTransferFunctions() {
                return flowProvider.needsEdgeFlow();
            }

            @Override
            public UnaryOperator<MachineState> getNodeTransferFunction(final ShrikeCFG.BasicBlock basicBlock) {
                return new UnaryOperator<MachineState>(){

                    @Override
                    public byte evaluate(MachineState machineState, MachineState machineState2) {
                        MachineState machineState3 = machineState;
                        MachineState machineState4 = machineState2;
                        MachineState machineState5 = flowProvider.flow(machineState4, basicBlock);
                        if (machineState5.stateEquals(machineState3)) {
                            return 0;
                        }
                        machineState3.copyState(machineState5);
                        return 1;
                    }

                    @Override
                    public String toString() {
                        return "NODE-FLOW";
                    }

                    @Override
                    public int hashCode() {
                        return 9973 * basicBlock.hashCode();
                    }

                    @Override
                    public boolean equals(Object object) {
                        return this == object;
                    }
                };
            }

            @Override
            public UnaryOperator<MachineState> getEdgeTransferFunction(final ShrikeCFG.BasicBlock basicBlock, final ShrikeCFG.BasicBlock basicBlock2) {
                return new UnaryOperator<MachineState>(){

                    @Override
                    public byte evaluate(MachineState machineState, MachineState machineState2) {
                        MachineState machineState3 = machineState;
                        MachineState machineState4 = machineState2;
                        MachineState machineState5 = flowProvider.flow(machineState4, basicBlock, basicBlock2);
                        if (machineState5.stateEquals(machineState3)) {
                            return 0;
                        }
                        machineState3.copyState(machineState5);
                        return 1;
                    }

                    @Override
                    public String toString() {
                        return "EDGE-FLOW";
                    }

                    @Override
                    public int hashCode() {
                        return 9973 * (basicBlock.hashCode() ^ basicBlock2.hashCode());
                    }

                    @Override
                    public boolean equals(Object object) {
                        return this == object;
                    }
                };
            }

            @Override
            public AbstractMeetOperator<MachineState> getMeetOperator() {
                return meetOperator;
            }
        };
        BasicFramework<ShrikeCFG.BasicBlock, MachineState> basicFramework = new BasicFramework<ShrikeCFG.BasicBlock, MachineState>(this.cfg, iTransferFunctionProvider);
        this.solver = new DataflowSolver<ShrikeCFG.BasicBlock, MachineState>(basicFramework){
            private MachineState entry;

            @Override
            protected MachineState makeNodeVariable(ShrikeCFG.BasicBlock basicBlock, boolean bl) {
                if (!$assertionsDisabled && basicBlock == null) {
                    throw new AssertionError();
                }
                MachineState machineState = new MachineState(basicBlock);
                if (bl && basicBlock.equals(AbstractIntStackMachine.this.cfg.entry())) {
                    this.entry = machineState;
                }
                return machineState;
            }

            @Override
            protected MachineState makeEdgeVariable(ShrikeCFG.BasicBlock basicBlock, ShrikeCFG.BasicBlock basicBlock2) {
                if (!$assertionsDisabled && basicBlock == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && basicBlock2 == null) {
                    throw new AssertionError();
                }
                MachineState machineState = new MachineState(basicBlock);
                return machineState;
            }

            @Override
            protected void initializeWorkList() {
                super.buildEquations(false, false);
                Iterator iterator = this.getFixedPointSystem().getStatementsThatUse(this.entry);
                while (iterator.hasNext()) {
                    AbstractStatement abstractStatement = (AbstractStatement)iterator.next();
                    this.addToWorkList(abstractStatement);
                }
            }

            @Override
            protected void initializeVariables() {
                super.initializeVariables();
                AbstractIntStackMachine.this.initializeVariables();
            }
        };
    }

    public boolean solve() {
        try {
            return this.solver.solve(null);
        }
        catch (CancelException cancelException) {
            throw new CancelRuntimeException(cancelException);
        }
    }

    protected void initializeVariables() {
    }

    public MachineState getEntryState() {
        return (MachineState)this.solver.getIn(this.cfg.entry());
    }

    public MachineState getIn(ShrikeCFG.BasicBlock basicBlock) {
        return (MachineState)this.solver.getIn(basicBlock);
    }

    private boolean meet(IVariable iVariable, IVariable[] iVariableArray, ShrikeCFG.BasicBlock basicBlock, Meeter meeter) {
        boolean bl = this.meetStacks(iVariable, iVariableArray, basicBlock, meeter);
        return bl |= this.meetLocals(iVariable, iVariableArray, basicBlock, meeter);
    }

    private boolean meetForCatchBlock(IVariable iVariable, IVariable[] iVariableArray, ShrikeCFG.BasicBlock basicBlock, Meeter meeter) {
        boolean bl = this.meetStacksAtCatchBlock(iVariable, basicBlock, meeter);
        return bl |= this.meetLocals(iVariable, iVariableArray, basicBlock, meeter);
    }

    private boolean meetStacksAtCatchBlock(IVariable iVariable, ShrikeCFG.BasicBlock basicBlock, Meeter meeter) {
        boolean bl = false;
        MachineState machineState = (MachineState)iVariable;
        if (machineState.stack == null) {
            machineState.allocateStack();
            machineState.stackHeight = 1;
        }
        int n = meeter.meetStackAtCatchBlock(basicBlock);
        if (machineState.stack[0] == -1) {
            if (n != -1) {
                bl = true;
                ((MachineState)machineState).stack[0] = n;
            }
        } else if (n != machineState.stack[0]) {
            bl = true;
            ((MachineState)machineState).stack[0] = n;
        }
        return bl;
    }

    private boolean meetStacks(IVariable iVariable, IVariable[] iVariableArray, ShrikeCFG.BasicBlock basicBlock, Meeter meeter) {
        boolean bl = false;
        MachineState machineState = (MachineState)iVariable;
        int n = AbstractIntStackMachine.computeMeetStackHeight(iVariableArray);
        if (n > -1 && machineState.stack == null) {
            machineState.allocateStack();
            machineState.stackHeight = n;
            bl = true;
        }
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = new int[iVariableArray.length];
            int n3 = 0;
            while (n3 < nArray.length) {
                MachineState machineState2 = (MachineState)iVariableArray[n3];
                if (machineState2.stack == null) {
                    nArray[n3] = -1;
                } else {
                    nArray[n3] = machineState2.stack[n2];
                    if (nArray[n3] == 0) {
                        nArray[n3] = -1;
                    }
                }
                ++n3;
            }
            n3 = meeter.meetStack(n2, nArray, basicBlock);
            if (machineState.stack[n2] == -1) {
                if (n3 != -1) {
                    bl = true;
                    ((MachineState)machineState).stack[n2] = n3;
                }
            } else if (n3 != machineState.stack[n2]) {
                bl = true;
                ((MachineState)machineState).stack[n2] = n3;
            }
            ++n2;
        }
        return bl;
    }

    private boolean meetLocals(IVariable iVariable, IVariable[] iVariableArray, ShrikeCFG.BasicBlock basicBlock, Meeter meeter) {
        boolean bl = false;
        MachineState machineState = (MachineState)iVariable;
        int n = AbstractIntStackMachine.computeMeetNLocals(iVariableArray);
        if (n > -1 && machineState.locals == null) {
            machineState.allocateLocals();
        }
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = new int[iVariableArray.length];
            int n3 = 0;
            while (n3 < iVariableArray.length) {
                nArray[n3] = ((MachineState)iVariableArray[n3]).getLocal(n2);
                ++n3;
            }
            n3 = meeter.meetLocal(n2, nArray, basicBlock);
            if (machineState.locals[n2] == -1) {
                if (n3 != -1) {
                    bl = true;
                    ((MachineState)machineState).locals[n2] = n3;
                }
            } else if (n3 != machineState.locals[n2]) {
                bl = true;
                ((MachineState)machineState).locals[n2] = n3;
            }
            ++n2;
        }
        return bl;
    }

    private static int computeMeetNLocals(IVariable[] iVariableArray) {
        MachineState machineState = (MachineState)iVariableArray[0];
        int n = -1;
        if (machineState.locals != null) {
            n = machineState.locals.length;
        } else {
            int n2 = 1;
            while (n2 < iVariableArray.length) {
                MachineState machineState2 = (MachineState)iVariableArray[n2];
                if (machineState2.locals != null) {
                    n = machineState2.locals.length;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private static int computeMeetStackHeight(IVariable[] iVariableArray) {
        MachineState machineState = (MachineState)iVariableArray[0];
        int n = -1;
        if (machineState.stack != null) {
            n = machineState.stackHeight;
        } else {
            int n2 = 1;
            while (n2 < iVariableArray.length) {
                MachineState machineState2 = (MachineState)iVariableArray[n2];
                if (machineState2.stack != null) {
                    n = machineState2.stackHeight;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    public int[] allocateNewLocalsArray() {
        int[] nArray = new int[this.maxLocals];
        int n = 0;
        while (n < this.maxLocals) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    protected static abstract class BasicStackFlowProvider
    implements FlowProvider,
    Constants {
        private final ShrikeCFG cfg;
        protected MachineState workingState;
        private BasicStackMachineVisitor visitor;
        private IInstruction.Visitor edgeVisitor;
        private int currentInstructionIndex = 0;
        private ShrikeCFG.BasicBlock currentBlock;
        private ShrikeCFG.BasicBlock currentSuccessorBlock;

        protected BasicStackFlowProvider(ShrikeCFG shrikeCFG) {
            this.cfg = shrikeCFG;
        }

        protected void init(BasicStackMachineVisitor basicStackMachineVisitor, IInstruction.Visitor visitor) {
            this.visitor = basicStackMachineVisitor;
            this.edgeVisitor = visitor;
        }

        public boolean needsNodeFlow() {
            return true;
        }

        public boolean needsEdgeFlow() {
            return false;
        }

        public MachineState flow(MachineState machineState, ShrikeCFG.BasicBlock basicBlock) {
            this.workingState = machineState.duplicate();
            this.currentBlock = basicBlock;
            this.currentSuccessorBlock = null;
            IInstruction[] iInstructionArray = this.getInstructions();
            int n = basicBlock.getFirstInstructionIndex();
            while (n <= basicBlock.getLastInstructionIndex()) {
                this.currentInstructionIndex = n;
                iInstructionArray[n].visit((IInstruction.Visitor)this.visitor);
                ++n;
            }
            return this.workingState;
        }

        public MachineState flow(MachineState machineState, ShrikeCFG.BasicBlock basicBlock, ShrikeCFG.BasicBlock basicBlock2) {
            this.workingState = machineState.duplicate();
            this.currentBlock = basicBlock;
            this.currentSuccessorBlock = basicBlock2;
            IInstruction[] iInstructionArray = this.getInstructions();
            int n = basicBlock.getFirstInstructionIndex();
            while (n <= basicBlock.getLastInstructionIndex()) {
                this.currentInstructionIndex = n;
                iInstructionArray[n].visit(this.edgeVisitor);
                ++n;
            }
            return this.workingState;
        }

        protected int getCurrentInstructionIndex() {
            return this.currentInstructionIndex;
        }

        protected int getCurrentProgramCounter() {
            return this.cfg.getProgramCounter(this.currentInstructionIndex);
        }

        protected ShrikeCFG.BasicBlock getCurrentBlock() {
            return this.currentBlock;
        }

        protected ShrikeCFG.BasicBlock getCurrentSuccessor() {
            return this.currentSuccessorBlock;
        }

        public abstract IInstruction[] getInstructions();

        protected class BasicStackMachineVisitor
        extends IInstruction.Visitor {
            protected BasicStackMachineVisitor() {
            }

            public void visitArrayLength(ArrayLengthInstruction arrayLengthInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitArrayLoad(IArrayLoadInstruction iArrayLoadInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitArrayStore(IArrayStoreInstruction iArrayStoreInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitBinaryOp(IBinaryOpInstruction iBinaryOpInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitComparison(IComparisonInstruction iComparisonInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitConditionalBranch(IConditionalBranchInstruction iConditionalBranchInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitConstant(ConstantInstruction constantInstruction) {
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitConversion(IConversionInstruction iConversionInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitDup(DupInstruction dupInstruction) {
                int n;
                int n2 = dupInstruction.getSize();
                int n3 = dupInstruction.getDelta();
                assert (n2 == 1 || n2 == 2);
                assert (n3 == 0 || n3 == 1 || n3 == 2);
                int n4 = n2 + n3;
                int n5 = BasicStackFlowProvider.this.workingState.pop();
                int n6 = n4 > 1 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                int n7 = n4 > 2 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                int n8 = n = n4 > 3 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                if (n2 > 1) {
                    BasicStackFlowProvider.this.workingState.push(n6);
                }
                BasicStackFlowProvider.this.workingState.push(n5);
                if (n != -4) {
                    BasicStackFlowProvider.this.workingState.push(n);
                }
                if (n7 != -4) {
                    BasicStackFlowProvider.this.workingState.push(n7);
                }
                if (n6 != -4) {
                    BasicStackFlowProvider.this.workingState.push(n6);
                }
                BasicStackFlowProvider.this.workingState.push(n5);
            }

            public void visitGet(IGetInstruction iGetInstruction) {
                this.popN((IInstruction)iGetInstruction);
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            protected void popN(IInstruction iInstruction) {
                int n = 0;
                while (n < iInstruction.getPoppedCount()) {
                    BasicStackFlowProvider.this.workingState.pop();
                    ++n;
                }
            }

            public void visitInstanceof(IInstanceofInstruction iInstanceofInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitInvoke(IInvokeInstruction iInvokeInstruction) {
                this.popN((IInstruction)iInvokeInstruction);
                ClassLoaderReference classLoaderReference = BasicStackFlowProvider.this.cfg.getMethod().getDeclaringClass().getClassLoader().getReference();
                TypeReference typeReference = ShrikeUtil.makeTypeReference(classLoaderReference, Util.getReturnType((String)iInvokeInstruction.getMethodSignature()));
                if (!typeReference.equals(TypeReference.Void)) {
                    BasicStackFlowProvider.this.workingState.push(-3);
                }
            }

            public void visitMonitor(MonitorInstruction monitorInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitLocalLoad(ILoadInstruction iLoadInstruction) {
                int n = BasicStackFlowProvider.this.workingState.getLocal(iLoadInstruction.getVarIndex());
                BasicStackFlowProvider.this.workingState.push(n);
            }

            public void visitLocalStore(IStoreInstruction iStoreInstruction) {
                int n = iStoreInstruction.getVarIndex();
                BasicStackFlowProvider.this.workingState.setLocal(n, BasicStackFlowProvider.this.workingState.pop());
            }

            public void visitNew(NewInstruction newInstruction) {
                this.popN((IInstruction)newInstruction);
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitPop(PopInstruction popInstruction) {
                if (popInstruction.getPoppedCount() > 0) {
                    BasicStackFlowProvider.this.workingState.pop();
                }
            }

            public void visitPut(IPutInstruction iPutInstruction) {
                this.popN((IInstruction)iPutInstruction);
            }

            public void visitShift(IShiftInstruction iShiftInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitSwap(SwapInstruction swapInstruction) {
                BasicStackFlowProvider.this.workingState.swap();
            }

            public void visitSwitch(SwitchInstruction switchInstruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitThrow(ThrowInstruction throwInstruction) {
                int n = BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.clearStack();
                BasicStackFlowProvider.this.workingState.push(n);
            }

            public void visitUnaryOp(IUnaryOpInstruction iUnaryOpInstruction) {
            }
        }
    }

    public static interface FlowProvider {
        public boolean needsNodeFlow();

        public boolean needsEdgeFlow();

        public MachineState flow(MachineState var1, ShrikeCFG.BasicBlock var2);

        public MachineState flow(MachineState var1, ShrikeCFG.BasicBlock var2, ShrikeCFG.BasicBlock var3);
    }

    public class MachineState
    extends AbstractVariable {
        private int[] stack;
        private int[] locals;
        private int stackHeight;
        private final ShrikeCFG.BasicBlock bb;

        public MachineState duplicate() {
            MachineState machineState = new MachineState(this.bb);
            machineState.copyState(this);
            return machineState;
        }

        public MachineState(ShrikeCFG.BasicBlock basicBlock) {
            this.setTOP();
            this.bb = basicBlock;
        }

        public ShrikeCFG.BasicBlock getBasicBlock() {
            return this.bb;
        }

        void setTOP() {
            this.stackHeight = -1;
        }

        boolean isTOP() {
            return this.stackHeight == -1;
        }

        public void push(int n) {
            if (this.stack == null) {
                this.allocateStack();
            }
            this.stack[this.stackHeight++] = n;
        }

        public int pop() {
            if (this.stackHeight <= 0) assert (this.stackHeight > 0) : "can't pop stack of height " + this.stackHeight;
            --this.stackHeight;
            return this.stack[this.stackHeight];
        }

        public int peek() {
            return this.stack[this.stackHeight - 1];
        }

        public void swap() {
            int n = this.stack[this.stackHeight - 1];
            this.stack[this.stackHeight - 1] = this.stack[this.stackHeight - 2];
            this.stack[this.stackHeight - 2] = n;
        }

        private void allocateStack() {
            this.stack = new int[AbstractIntStackMachine.this.maxStackHeight + 1];
            this.stackHeight = 0;
        }

        private void allocateLocals() {
            this.locals = AbstractIntStackMachine.this.allocateNewLocalsArray();
        }

        public void clearStack() {
            this.stackHeight = 0;
        }

        public void setLocal(int n, int n2) {
            if (this.locals == null) {
                if (n2 == -1) {
                    return;
                }
                this.allocateLocals();
            }
            this.locals[n] = n2;
        }

        public int getLocal(int n) {
            if (this.locals == null) {
                return -1;
            }
            return this.locals[n];
        }

        public void replaceValue(int n, int n2) {
            int n3;
            if (this.stack != null) {
                n3 = 0;
                while (n3 < this.stackHeight) {
                    if (this.stack[n3] == n) {
                        this.stack[n3] = n2;
                    }
                    ++n3;
                }
            }
            if (this.locals != null) {
                n3 = 0;
                while (n3 < AbstractIntStackMachine.this.maxLocals) {
                    if (this.locals[n3] == n) {
                        this.locals[n3] = n2;
                    }
                    ++n3;
                }
            }
        }

        public boolean hasValue(int n) {
            int n2;
            if (this.stack != null) {
                n2 = 0;
                while (n2 < this.stackHeight) {
                    if (this.stack[n2] == n) {
                        return true;
                    }
                    ++n2;
                }
            }
            if (this.locals != null) {
                n2 = 0;
                while (n2 < AbstractIntStackMachine.this.maxLocals) {
                    if (this.locals[n2] == n) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public String toString() {
            if (this.isTOP()) {
                return "<TOP>@" + System.identityHashCode(this);
            }
            StringBuffer stringBuffer = new StringBuffer("<");
            stringBuffer.append("S");
            if (this.stackHeight == 0) {
                stringBuffer.append("[empty]");
            } else {
                stringBuffer.append(this.array2StringBuffer(this.stack, this.stackHeight));
            }
            stringBuffer.append("L");
            stringBuffer.append(this.array2StringBuffer(this.locals, AbstractIntStackMachine.this.maxLocals));
            stringBuffer.append(">");
            return stringBuffer.toString();
        }

        private StringBuffer array2StringBuffer(int[] nArray, int n) {
            StringBuffer stringBuffer = new StringBuffer("[");
            if (nArray == null) {
                stringBuffer.append("TOP");
            } else {
                int n2 = 0;
                while (n2 < n - 1) {
                    stringBuffer.append(nArray[n2]).append(",");
                    ++n2;
                }
                stringBuffer.append(nArray[n - 1]);
            }
            stringBuffer.append("]");
            return stringBuffer;
        }

        public void copyState(IVariable iVariable) {
            MachineState machineState = (MachineState)iVariable;
            if (machineState.stack == null) {
                this.stack = null;
            } else {
                this.stack = new int[machineState.stack.length];
                System.arraycopy(machineState.stack, 0, this.stack, 0, machineState.stack.length);
            }
            if (machineState.locals == null) {
                this.locals = null;
            } else {
                this.locals = new int[machineState.locals.length];
                System.arraycopy(machineState.locals, 0, this.locals, 0, machineState.locals.length);
            }
            this.stackHeight = machineState.stackHeight;
        }

        boolean stateEquals(MachineState machineState) {
            if (this.stackHeight != machineState.stackHeight) {
                return false;
            }
            if (this.locals == null) {
                if (machineState.locals != null) {
                    return false;
                }
            } else {
                if (machineState.locals == null) {
                    return false;
                }
                if (this.locals.length != machineState.locals.length) {
                    return false;
                }
            }
            int n = 0;
            while (n < this.stackHeight) {
                if (this.stack[n] != machineState.stack[n]) {
                    return false;
                }
                ++n;
            }
            if (this.locals != null) {
                n = 0;
                while (n < this.locals.length) {
                    if (this.locals[n] == -1 && machineState.locals[n] != -1) {
                        return false;
                    }
                    if (this.locals[n] != machineState.locals[n]) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }

        public int getStackHeight() {
            return this.stackHeight;
        }

        public int[] getLocals() {
            return this.locals;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MeetOperator
    extends AbstractMeetOperator<MachineState> {
        private final Meeter meeter;

        MeetOperator(Meeter meeter) {
            this.meeter = meeter;
        }

        @Override
        public boolean isUnaryNoOp() {
            return false;
        }

        @Override
        public byte evaluate(MachineState machineState, IVariable[] iVariableArray) {
            ShrikeCFG.BasicBlock basicBlock = machineState.getBasicBlock();
            if (!basicBlock.isCatchBlock()) {
                return AbstractIntStackMachine.this.meet(machineState, iVariableArray, basicBlock, this.meeter) ? (byte)1 : 0;
            }
            return AbstractIntStackMachine.this.meetForCatchBlock(machineState, iVariableArray, basicBlock, this.meeter) ? (byte)1 : 0;
        }

        @Override
        public int hashCode() {
            return 72223 * this.meeter.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof MeetOperator) {
                MeetOperator meetOperator = (MeetOperator)object;
                return this.meeter.equals(meetOperator.meeter);
            }
            return false;
        }

        @Override
        public String toString() {
            return "MEETER";
        }
    }

    protected static interface Meeter {
        public int meetStack(int var1, int[] var2, ShrikeCFG.BasicBlock var3);

        public int meetStackAtCatchBlock(ShrikeCFG.BasicBlock var1);

        public int meetLocal(int var1, int[] var2, ShrikeCFG.BasicBlock var3);
    }
}

