/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.IllegalArgumentExceptionContext;
import com.ibm.wala.analysis.reflection.ReflectiveInvocationInterpreter;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

class ReflectiveInvocationSelector
implements ContextSelector {
    public Context getCalleeTarget(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod, InstanceKey instanceKey) {
        int n;
        if (!this.mayUnderstand(cGNode, callSiteReference, iMethod, instanceKey)) {
            return null;
        }
        IR iR = cGNode.getIR();
        SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = iR.getCalls(callSiteReference);
        if (sSAAbstractInvokeInstructionArray.length != 1) {
            return new ReceiverInstanceContext(instanceKey);
        }
        SymbolTable symbolTable = iR.getSymbolTable();
        ConstantKey constantKey = (ConstantKey)instanceKey;
        IMethod iMethod2 = (IMethod)constantKey.getValue();
        boolean bl = iMethod2.isStatic();
        boolean bl2 = this.isConstructorConstant(instanceKey);
        if (!bl2 && symbolTable.isNullConstant(n = sSAAbstractInvokeInstructionArray[0].getUse(1)) && !bl) {
            return null;
        }
        n = bl ? iMethod2.getNumberOfParameters() : iMethod2.getNumberOfParameters() - 1;
        int n2 = bl2 ? 1 : 2;
        int n3 = sSAAbstractInvokeInstructionArray[0].getUse(n2);
        SSAInstruction sSAInstruction = cGNode.getDU().getDef(n3);
        if (!(sSAInstruction instanceof SSANewInstruction)) {
            return new ReceiverInstanceContext(instanceKey);
        }
        SSANewInstruction sSANewInstruction = (SSANewInstruction)sSAInstruction;
        if (!sSANewInstruction.getConcreteType().isArrayType()) {
            return null;
        }
        int n4 = sSANewInstruction.getUse(0);
        try {
            int n5 = symbolTable.getIntValue(n4);
            if (n5 == n) {
                return new ReceiverInstanceContext(instanceKey);
            }
            return new IllegalArgumentExceptionContext();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new ReceiverInstanceContext(instanceKey);
        }
    }

    private boolean mayUnderstand(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod, InstanceKey instanceKey) {
        return instanceKey instanceof ConstantKey && (iMethod.getReference().equals(ReflectiveInvocationInterpreter.METHOD_INVOKE) || this.isConstructorConstant(instanceKey) && iMethod.getReference().equals(ReflectiveInvocationInterpreter.CTOR_NEW_INSTANCE));
    }

    private boolean isConstructorConstant(InstanceKey instanceKey) {
        ConstantKey constantKey;
        return instanceKey instanceof ConstantKey && (constantKey = (ConstantKey)instanceKey).getConcreteType().getReference().equals(TypeReference.JavaLangReflectConstructor);
    }
}

