/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLangClassContextInterpreter
implements SSAContextInterpreter {
    public static final MethodReference GET_CONSTRUCTOR = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
    public static final MethodReference GET_CONSTRUCTORS = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getConstructors", "()[Ljava/lang/reflect/Constructor;");
    public static final MethodReference GET_METHOD = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
    public static final MethodReference GET_METHODS = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getMethods", "()[Ljava/lang/reflect/Method;");
    public static final MethodReference GET_DECLARED_CONSTRUCTOR = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
    public static final MethodReference GET_DECLARED_CONSTRUCTORS = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;");
    public static final MethodReference GET_DECLARED_METHOD = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
    public static final MethodReference GET_DECLARED_METHODS = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getDeclaredMethods", "()[Ljava/lang/reflect/Method;");
    private static final boolean DEBUG = false;

    @Override
    public IR getIR(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        IMethod iMethod = cGNode.getMethod();
        JavaTypeContext javaTypeContext = (JavaTypeContext)cGNode.getContext();
        HashMap<Integer, ConstantValue> hashMap = HashMapFactory.make();
        if (iMethod.getReference().equals(GET_CONSTRUCTOR)) {
            SSAInstruction[] sSAInstructionArray = this.makeGetCtorStatements(javaTypeContext, hashMap);
            return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), hashMap);
        }
        if (iMethod.getReference().equals(GET_CONSTRUCTORS)) {
            SSAInstruction[] sSAInstructionArray = this.makeGetCtorsStatements(javaTypeContext, hashMap);
            return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), hashMap);
        }
        if (iMethod.getReference().equals(GET_METHOD)) {
            SSAInstruction[] sSAInstructionArray = this.makeGetMethodStatements(javaTypeContext, hashMap);
            return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), hashMap);
        }
        if (iMethod.getReference().equals(GET_METHODS)) {
            SSAInstruction[] sSAInstructionArray = this.makeGetMethodsStatments(javaTypeContext, hashMap);
            return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), hashMap);
        }
        if (iMethod.getReference().equals(GET_DECLARED_CONSTRUCTOR)) {
            SSAInstruction[] sSAInstructionArray = this.makeGetDeclCtorStatements(javaTypeContext, hashMap);
            return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), hashMap);
        }
        if (iMethod.getReference().equals(GET_DECLARED_CONSTRUCTORS)) {
            SSAInstruction[] sSAInstructionArray = this.makeGetDeclCtorsStatements(javaTypeContext, hashMap);
            return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), hashMap);
        }
        if (iMethod.getReference().equals(GET_DECLARED_METHOD)) {
            SSAInstruction[] sSAInstructionArray = this.makeGetDeclaredMethodStatements(javaTypeContext, hashMap);
            return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), hashMap);
        }
        if (iMethod.getReference().equals(GET_DECLARED_METHODS)) {
            SSAInstruction[] sSAInstructionArray = this.makeGetDeclaredMethodsStatements(javaTypeContext, hashMap);
            return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), hashMap);
        }
        Assertions.UNREACHABLE("Unexpected method " + cGNode);
        return null;
    }

    @Override
    public int getNumberOfStatements(CGNode cGNode) {
        assert (this.understands(cGNode));
        return this.getIR(cGNode).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!(cGNode.getContext() instanceof JavaTypeContext)) {
            return false;
        }
        MethodReference methodReference = cGNode.getMethod().getReference();
        return methodReference.equals(GET_CONSTRUCTOR) || methodReference.equals(GET_CONSTRUCTORS) || methodReference.equals(GET_METHOD) || methodReference.equals(GET_METHODS) || methodReference.equals(GET_DECLARED_CONSTRUCTOR) || methodReference.equals(GET_DECLARED_CONSTRUCTORS) || methodReference.equals(GET_DECLARED_METHOD) || methodReference.equals(GET_DECLARED_METHODS);
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        JavaTypeContext javaTypeContext = (JavaTypeContext)cGNode.getContext();
        TypeReference typeReference = javaTypeContext.getType().getTypeReference();
        if (typeReference != null) {
            return new NonNullSingletonIterator<NewSiteReference>(NewSiteReference.make(0, typeReference));
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode cGNode) {
        assert (this.understands(cGNode));
        return EmptyIterator.instance();
    }

    private Collection<IMethod> getDeclaredNormalMethods(IClass iClass) {
        HashSet<IMethod> hashSet = HashSetFactory.make();
        for (IMethod iMethod : iClass.getDeclaredMethods()) {
            if (iMethod.isInit() || iMethod.isClinit()) continue;
            hashSet.add(iMethod);
        }
        return hashSet;
    }

    private Collection<IMethod> getAllNormalPublicMethods(IClass iClass) {
        HashSet<IMethod> hashSet = HashSetFactory.make();
        Collection<IMethod> collection = null;
        collection = iClass.getAllMethods();
        for (IMethod iMethod : collection) {
            if (iMethod.isInit() || iMethod.isClinit() || !iMethod.isPublic()) continue;
            hashSet.add(iMethod);
        }
        return hashSet;
    }

    private Collection<IMethod> getConstructors(IClass iClass) {
        HashSet<IMethod> hashSet = HashSetFactory.make();
        for (IMethod iMethod : iClass.getDeclaredMethods()) {
            if (!iMethod.isInit()) continue;
            hashSet.add(iMethod);
        }
        return hashSet;
    }

    private Collection<IMethod> getPublicConstructors(IClass iClass) {
        HashSet<IMethod> hashSet = HashSetFactory.make();
        for (IMethod iMethod : iClass.getDeclaredMethods()) {
            if (!iMethod.isInit() || !iMethod.isPublic()) continue;
            hashSet.add(iMethod);
        }
        return hashSet;
    }

    private SSAInstruction[] getMethodArrayStatements(MethodReference methodReference, Collection<IMethod> collection, JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        int n;
        Object object;
        SSAInstruction[] sSAInstructionArray;
        ArrayList<SSAInstruction> arrayList = new ArrayList<SSAInstruction>();
        int n2 = methodReference.getNumberOfParameters() + 2;
        int n3 = n2++;
        IClass iClass = javaTypeContext.getType().getType();
        SSAInstructionFactory sSAInstructionFactory = javaTypeContext.getType().getType().getClassLoader().getInstructionFactory();
        if (iClass != null) {
            sSAInstructionArray = methodReference.getReturnType();
            object = new NewSiteReference(n3, (TypeReference)sSAInstructionArray);
            n = n2++;
            map.put(n, new ConstantValue(collection.size()));
            SSANewInstruction sSANewInstruction = sSAInstructionFactory.NewInstruction(n3, (NewSiteReference)object, new int[]{n});
            arrayList.add(sSANewInstruction);
            int n4 = 0;
            for (IMethod object22 : collection) {
                int n5 = n2++;
                map.put(n5, new ConstantValue(object22));
                int n6 = n4++;
                int n7 = n2++;
                map.put(n7, new ConstantValue(n6));
                SSAArrayStoreInstruction sSAArrayStoreInstruction = sSAInstructionFactory.ArrayStoreInstruction(n3, n7, n5, TypeReference.JavaLangReflectConstructor);
                arrayList.add(sSAArrayStoreInstruction);
            }
            SSAReturnInstruction sSAReturnInstruction = sSAInstructionFactory.ReturnInstruction(n3, false);
            arrayList.add(sSAReturnInstruction);
        }
        sSAInstructionArray = new SSAInstruction[arrayList.size()];
        object = arrayList.iterator();
        n = 0;
        while (n < sSAInstructionArray.length) {
            sSAInstructionArray[n] = (SSAInstruction)object.next();
            ++n;
        }
        return sSAInstructionArray;
    }

    private SSAInstruction[] getParticularMethodStatements(MethodReference methodReference, Collection<IMethod> collection, JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        int n;
        ArrayList<SSAReturnInstruction> arrayList = new ArrayList<SSAReturnInstruction>();
        int n2 = methodReference.getNumberOfParameters() + 2;
        IClass iClass = javaTypeContext.getType().getType();
        SSAInstructionFactory sSAInstructionFactory = javaTypeContext.getType().getType().getClassLoader().getInstructionFactory();
        if (iClass != null) {
            for (IMethod sSAInstructionArray2 : collection) {
                n = n2++;
                map.put(n, new ConstantValue(sSAInstructionArray2));
                SSAReturnInstruction sSAReturnInstruction = sSAInstructionFactory.ReturnInstruction(n, false);
                arrayList.add(sSAReturnInstruction);
            }
        }
        SSAInstruction[] sSAInstructionArray = new SSAInstruction[arrayList.size()];
        Iterator<IMethod> iterator = arrayList.iterator();
        n = 0;
        while (n < sSAInstructionArray.length) {
            sSAInstructionArray[n] = (SSAInstruction)((Object)iterator.next());
            ++n;
        }
        return sSAInstructionArray;
    }

    private SSAInstruction[] makeGetCtorStatements(JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        IClass iClass = javaTypeContext.getType().getType();
        if (iClass == null) {
            return this.getParticularMethodStatements(GET_CONSTRUCTOR, null, javaTypeContext, map);
        }
        return this.getParticularMethodStatements(GET_CONSTRUCTOR, this.getPublicConstructors(iClass), javaTypeContext, map);
    }

    private SSAInstruction[] makeGetCtorsStatements(JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        IClass iClass = javaTypeContext.getType().getType();
        if (iClass == null) {
            return this.getMethodArrayStatements(GET_DECLARED_CONSTRUCTORS, null, javaTypeContext, map);
        }
        return this.getMethodArrayStatements(GET_DECLARED_CONSTRUCTORS, this.getPublicConstructors(iClass), javaTypeContext, map);
    }

    private SSAInstruction[] makeGetMethodStatements(JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        IClass iClass = javaTypeContext.getType().getType();
        if (iClass == null) {
            return this.getParticularMethodStatements(GET_METHOD, null, javaTypeContext, map);
        }
        return this.getParticularMethodStatements(GET_METHOD, this.getAllNormalPublicMethods(iClass), javaTypeContext, map);
    }

    private SSAInstruction[] makeGetMethodsStatments(JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        IClass iClass = javaTypeContext.getType().getType();
        if (iClass == null) {
            return this.getMethodArrayStatements(GET_METHODS, null, javaTypeContext, map);
        }
        return this.getMethodArrayStatements(GET_METHODS, this.getAllNormalPublicMethods(iClass), javaTypeContext, map);
    }

    private SSAInstruction[] makeGetDeclCtorStatements(JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        IClass iClass = javaTypeContext.getType().getType();
        if (iClass == null) {
            return this.getParticularMethodStatements(GET_DECLARED_CONSTRUCTOR, null, javaTypeContext, map);
        }
        return this.getParticularMethodStatements(GET_DECLARED_CONSTRUCTOR, this.getConstructors(iClass), javaTypeContext, map);
    }

    private SSAInstruction[] makeGetDeclCtorsStatements(JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        IClass iClass = javaTypeContext.getType().getType();
        if (iClass == null) {
            return this.getMethodArrayStatements(GET_DECLARED_CONSTRUCTORS, null, javaTypeContext, map);
        }
        return this.getMethodArrayStatements(GET_DECLARED_CONSTRUCTORS, this.getConstructors(iClass), javaTypeContext, map);
    }

    private SSAInstruction[] makeGetDeclaredMethodStatements(JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        IClass iClass = javaTypeContext.getType().getType();
        if (iClass == null) {
            return this.getParticularMethodStatements(GET_DECLARED_METHOD, null, javaTypeContext, map);
        }
        return this.getParticularMethodStatements(GET_DECLARED_METHOD, this.getDeclaredNormalMethods(iClass), javaTypeContext, map);
    }

    private SSAInstruction[] makeGetDeclaredMethodsStatements(JavaTypeContext javaTypeContext, Map<Integer, ConstantValue> map) {
        IClass iClass = javaTypeContext.getType().getType();
        if (iClass == null) {
            return this.getMethodArrayStatements(GET_DECLARED_METHODS, null, javaTypeContext, map);
        }
        return this.getMethodArrayStatements(GET_DECLARED_METHODS, this.getDeclaredNormalMethods(iClass), javaTypeContext, map);
    }

    @Override
    public boolean recordFactoryType(CGNode cGNode, IClass iClass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode cGNode) {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode cGNode) {
        return EmptyIterator.instance();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode cGNode) {
        return this.getIR(cGNode).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode cGNode) {
        return new DefUse(this.getIR(cGNode));
    }
}

