/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractReflectionInterpreter
implements SSAContextInterpreter {
    protected static final boolean DEBUG = false;
    protected static final int CONE_BOUND = 10;
    protected int indexLocal = 100;
    protected final Map<TypeReference, Integer> typeIndexMap = HashMapFactory.make();
    protected AnalysisOptions options;
    protected AnalysisCache cache;

    protected int getLocalForType(TypeReference typeReference) {
        Integer n = this.typeIndexMap.get(typeReference);
        if (n == null) {
            n = new Integer(this.indexLocal += 2);
            this.typeIndexMap.put(typeReference, n);
        }
        return n;
    }

    protected int getExceptionsForType(TypeReference typeReference) {
        return this.getLocalForType(typeReference) + 1;
    }

    protected int getCallSiteForType(TypeReference typeReference) {
        return this.getLocalForType(typeReference);
    }

    protected int getNewSiteForType(TypeReference typeReference) {
        return this.getLocalForType(typeReference) + 1;
    }

    protected TypeAbstraction typeRef2TypeAbstraction(IClassHierarchy iClassHierarchy, TypeReference typeReference) {
        IClass iClass = iClassHierarchy.lookupClass(typeReference);
        if (iClass != null) {
            return new ConeType(iClass);
        }
        Assertions.UNREACHABLE(typeReference.toString());
        return null;
    }

    protected static class IgnoreSerializableWarning
    extends Warning {
        private static final IgnoreSerializableWarning instance = new IgnoreSerializableWarning();

        protected IgnoreSerializableWarning() {
        }

        public String getMsg() {
            return this.getClass().toString();
        }

        public static IgnoreSerializableWarning create() {
            return instance;
        }
    }

    protected static class ManySubtypesWarning
    extends Warning {
        final int nImplementors;
        final TypeAbstraction T;

        ManySubtypesWarning(TypeAbstraction typeAbstraction, int n) {
            super((byte)1);
            this.T = typeAbstraction;
            this.nImplementors = n;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.T + " " + this.nImplementors;
        }

        public static ManySubtypesWarning create(TypeAbstraction typeAbstraction, int n) {
            return new ManySubtypesWarning(typeAbstraction, n);
        }
    }

    protected static class NoSubtypesWarning
    extends Warning {
        final TypeAbstraction T;

        NoSubtypesWarning(TypeAbstraction typeAbstraction) {
            super((byte)2);
            this.T = typeAbstraction;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.T;
        }

        public static NoSubtypesWarning create(TypeAbstraction typeAbstraction) {
            return new NoSubtypesWarning(typeAbstraction);
        }
    }

    protected class SpecializedMethod
    extends SyntheticMethod {
        protected final HashSet<TypeReference> typesAllocated;
        protected final ArrayList<SSAInstruction> allocations;
        protected final ArrayList<SSAInstruction> calls;
        protected final ArrayList<SSAInstruction> allInstructions;
        private final SSAInstructionFactory insts;

        public SpecializedMethod(MethodReference methodReference, IClass iClass, boolean bl, boolean bl2) {
            super(methodReference, iClass, bl, bl2);
            this.typesAllocated = HashSetFactory.make(5);
            this.allocations = new ArrayList();
            this.calls = new ArrayList();
            this.allInstructions = new ArrayList();
            this.insts = this.declaringClass.getClassLoader().getInstructionFactory();
        }

        public SpecializedMethod(IMethod iMethod, IClass iClass, boolean bl, boolean bl2) {
            super(iMethod, iClass, bl, bl2);
            this.typesAllocated = HashSetFactory.make(5);
            this.allocations = new ArrayList();
            this.calls = new ArrayList();
            this.allInstructions = new ArrayList();
            this.insts = this.declaringClass.getClassLoader().getInstructionFactory();
        }

        protected void addInstruction(TypeReference typeReference, SSAInstruction sSAInstruction, boolean bl) {
            if (bl) {
                if (this.typesAllocated.contains(typeReference)) {
                    return;
                }
                this.typesAllocated.add(typeReference);
            }
            this.allInstructions.add(sSAInstruction);
            if (bl) {
                this.allocations.add(sSAInstruction);
            }
        }

        protected int addStatementsForConcreteSimpleType(TypeReference typeReference) {
            assert (!this.typesAllocated.contains(typeReference));
            NewSiteReference newSiteReference = NewSiteReference.make(AbstractReflectionInterpreter.this.getNewSiteForType(typeReference), typeReference);
            int n = AbstractReflectionInterpreter.this.getLocalForType(typeReference);
            if (typeReference.isArrayType()) {
                int n2 = typeReference.getDimensionality();
                int[] nArray = new int[n2];
                Arrays.fill(nArray, 1);
                SSANewInstruction sSANewInstruction = this.insts.NewInstruction(n, newSiteReference, nArray);
                this.addInstruction(typeReference, sSANewInstruction, true);
            } else {
                SSANewInstruction sSANewInstruction = this.insts.NewInstruction(n, newSiteReference);
                this.addInstruction(typeReference, sSANewInstruction, true);
                this.addCtorInvokeInstruction(typeReference, n);
            }
            SSAReturnInstruction sSAReturnInstruction = this.insts.ReturnInstruction(n, false);
            this.addInstruction(typeReference, sSAReturnInstruction, false);
            return n;
        }

        protected void addCtorInvokeInstruction(TypeReference typeReference, int n) {
            MethodReference methodReference = MethodReference.findOrCreate(typeReference, MethodReference.initAtom, MethodReference.defaultInitDesc);
            CallSiteReference callSiteReference = CallSiteReference.make(AbstractReflectionInterpreter.this.getCallSiteForType(typeReference), methodReference, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
            int[] nArray = new int[]{n};
            int n2 = AbstractReflectionInterpreter.this.getExceptionsForType(typeReference);
            SSAInvokeInstruction sSAInvokeInstruction = this.insts.InvokeInstruction(nArray, n2, callSiteReference);
            this.calls.add(sSAInvokeInstruction);
            this.allInstructions.add(sSAInvokeInstruction);
        }
    }
}

