/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.pointers;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.IntMapIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.IntFunction;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicHeapGraph
extends HeapGraph {
    private static final boolean VERBOSE = false;
    private static final int VERBOSE_INTERVAL = 10000;
    private static final MutableSparseIntSetFactory factory = new MutableSparseIntSetFactory();
    private final NumberedGraph<Object> G;
    private final CallGraph callGraph;

    public BasicHeapGraph(final PointerAnalysis pointerAnalysis, CallGraph callGraph) throws NullPointerException {
        super(pointerAnalysis);
        this.callGraph = callGraph;
        final OrdinalSetMapping<PointerKey> ordinalSetMapping = this.getPointerKeys();
        final NumberedNodeManager<Object> numberedNodeManager = new NumberedNodeManager<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new CompoundIterator<Object>(ordinalSetMapping.iterator(), pointerAnalysis.getInstanceKeyMapping().iterator());
            }

            @Override
            public int getNumberOfNodes() {
                return ordinalSetMapping.getSize() + pointerAnalysis.getInstanceKeyMapping().getSize();
            }

            @Override
            public void addNode(Object object) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNode(Object object) {
                Assertions.UNREACHABLE();
            }

            @Override
            public int getNumber(Object object) {
                int n;
                if (object instanceof PointerKey) {
                    return ordinalSetMapping.getMappedIndex((PointerKey)object);
                }
                if (!(object instanceof InstanceKey)) {
                    Assertions.UNREACHABLE(object.getClass().toString());
                }
                return (n = pointerAnalysis.getInstanceKeyMapping().getMappedIndex((InstanceKey)object)) == -1 ? -1 : n + ordinalSetMapping.getMaximumIndex() + 1;
            }

            @Override
            public Object getNode(int n) {
                if (n > ordinalSetMapping.getMaximumIndex()) {
                    return pointerAnalysis.getInstanceKeyMapping().getMappedObject(n - ordinalSetMapping.getSize());
                }
                return ordinalSetMapping.getMappedObject(n);
            }

            @Override
            public int getMaxNumber() {
                return this.getNumberOfNodes() - 1;
            }

            @Override
            public boolean containsNode(Object object) {
                return this.getNumber(object) != -1;
            }

            @Override
            public Iterator<Object> iterateNodes(IntSet intSet) {
                return new NumberedNodeIterator<Object>(intSet, this);
            }
        };
        IBinaryNaturalRelation iBinaryNaturalRelation = this.computePredecessors(numberedNodeManager);
        IntFunction<Object> intFunction = new IntFunction<Object>(){

            @Override
            public Object apply(int n) {
                return numberedNodeManager.getNode(n);
            }
        };
        this.G = new AbstractNumberedGraph<Object>(iBinaryNaturalRelation, (IntFunction)intFunction){
            private final EdgeManager<Object> edgeMgr;
            {
                this.edgeMgr = new EdgeManager<Object>(){

                    @Override
                    public Iterator<Object> getPredNodes(Object object) {
                        int n = numberedNodeManager2.getNumber(object);
                        IntSet intSet = iBinaryNaturalRelation.getRelated(n);
                        if (intSet == null) {
                            return EmptyIterator.instance();
                        }
                        return new IntMapIterator<Object>(intSet.intIterator(), intFunction);
                    }

                    @Override
                    public int getPredNodeCount(Object object) {
                        int n = numberedNodeManager2.getNumber(object);
                        return iBinaryNaturalRelation.getRelatedCount(n);
                    }

                    @Override
                    public Iterator<Object> getSuccNodes(Object object) {
                        int[] nArray = BasicHeapGraph.this.computeSuccNodeNumbers(object, numberedNodeManager2);
                        if (nArray == null) {
                            return EmptyIterator.instance();
                        }
                        MutableSparseIntSet mutableSparseIntSet = factory.make(nArray);
                        return new IntMapIterator<Object>(mutableSparseIntSet.intIterator(), intFunction);
                    }

                    @Override
                    public int getSuccNodeCount(Object object) {
                        int[] nArray = BasicHeapGraph.this.computeSuccNodeNumbers(object, numberedNodeManager2);
                        return nArray == null ? 0 : nArray.length;
                    }

                    @Override
                    public void addEdge(Object object, Object object2) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public void removeEdge(Object object, Object object2) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public void removeAllIncidentEdges(Object object) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public void removeIncomingEdges(Object object) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public void removeOutgoingEdges(Object object) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public boolean hasEdge(Object object, Object object2) {
                        Assertions.UNREACHABLE();
                        return false;
                    }
                };
            }

            @Override
            protected NodeManager<Object> getNodeManager() {
                return numberedNodeManager;
            }

            @Override
            protected EdgeManager<Object> getEdgeManager() {
                return this.edgeMgr;
            }
        };
    }

    private OrdinalSetMapping<PointerKey> getPointerKeys() {
        MutableMapping<PointerKey> mutableMapping = MutableMapping.make();
        for (PointerKey pointerKey : this.getPointerAnalysis().getPointerKeys()) {
            mutableMapping.add(pointerKey);
        }
        return mutableMapping;
    }

    private int[] computeSuccNodeNumbers(Object object, NumberedNodeManager<Object> numberedNodeManager) {
        if (object instanceof PointerKey) {
            PointerKey pointerKey = (PointerKey)object;
            OrdinalSet<InstanceKey> ordinalSet = this.getPointerAnalysis().getPointsToSet(pointerKey);
            int[] nArray = new int[ordinalSet.size()];
            int n = 0;
            Iterator<InstanceKey> iterator = ordinalSet.iterator();
            while (iterator.hasNext()) {
                nArray[n] = numberedNodeManager.getNumber(iterator.next());
                ++n;
            }
            return nArray;
        }
        if (object instanceof InstanceKey) {
            InstanceKey instanceKey = (InstanceKey)object;
            TypeReference typeReference = instanceKey.getConcreteType().getReference();
            if (typeReference == null) assert (typeReference != null) : "null concrete type from " + instanceKey.getClass();
            if (typeReference.isArrayType()) {
                PointerKey pointerKey = this.getHeapModel().getPointerKeyForArrayContents(instanceKey);
                if (pointerKey == null || !numberedNodeManager.containsNode(pointerKey)) {
                    return null;
                }
                return new int[]{numberedNodeManager.getNumber(pointerKey)};
            }
            IClass iClass = this.getHeapModel().getClassHierarchy().lookupClass(typeReference);
            if (iClass == null) assert (iClass != null) : "null klass for type " + typeReference;
            MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
            for (IField iField : iClass.getAllInstanceFields()) {
                PointerKey pointerKey;
                if (iField.getReference().getFieldType().isPrimitiveType() || (pointerKey = this.getHeapModel().getPointerKeyForInstanceField(instanceKey, iField)) == null || !numberedNodeManager.containsNode(pointerKey)) continue;
                mutableSparseIntSet.add(numberedNodeManager.getNumber(pointerKey));
            }
            return mutableSparseIntSet.toIntArray();
        }
        Assertions.UNREACHABLE("Unexpected type: " + object.getClass());
        return null;
    }

    private IBinaryNaturalRelation computePredecessors(NumberedNodeManager<Object> numberedNodeManager) {
        BasicNaturalRelation basicNaturalRelation = new BasicNaturalRelation(new byte[1], 0);
        this.computePredecessorsForNonLocals(numberedNodeManager, basicNaturalRelation);
        this.computePredecessorsForLocals(numberedNodeManager, basicNaturalRelation);
        return basicNaturalRelation;
    }

    private void computePredecessorsForNonLocals(NumberedNodeManager<Object> numberedNodeManager, BasicNaturalRelation basicNaturalRelation) {
        int n = numberedNodeManager.getMaxNumber();
        while (n >= 0) {
            int[] nArray;
            Object object = numberedNodeManager.getNode(n);
            if (!(object instanceof LocalPointerKey) && (nArray = this.computeSuccNodeNumbers(object, numberedNodeManager)) != null) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = nArray[n2];
                    basicNaturalRelation.add(n3, n);
                    ++n2;
                }
            }
            --n;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computePredecessorsForLocals(NumberedNodeManager<Object> numberedNodeManager, BasicNaturalRelation basicNaturalRelation) {
        void var5_7;
        ArrayList<LocalPointerKey> arrayList = new ArrayList<LocalPointerKey>();
        for (Object t : numberedNodeManager) {
            if (!(t instanceof LocalPointerKey)) continue;
            arrayList.add((LocalPointerKey)t);
        }
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray, new LocalPointerComparator());
        boolean n = false;
        while (var5_7 < objectArray.length) {
            LocalPointerKey localPointerKey = (LocalPointerKey)objectArray[var5_7];
            int n2 = numberedNodeManager.getNumber(localPointerKey);
            int[] nArray = this.computeSuccNodeNumbers(localPointerKey, numberedNodeManager);
            if (nArray != null) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    int n4 = nArray[n3];
                    basicNaturalRelation.add(n4, n2);
                    ++n3;
                }
            }
            ++var5_7;
        }
    }

    @Override
    public int getNumber(Object object) {
        return this.G.getNumber(object);
    }

    @Override
    public Object getNode(int n) {
        return this.G.getNode(n);
    }

    @Override
    public int getMaxNumber() {
        return this.G.getMaxNumber();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.G.iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.G.getNumberOfNodes();
    }

    @Override
    public Iterator<Object> getPredNodes(Object object) {
        return this.G.getPredNodes(object);
    }

    @Override
    public int getPredNodeCount(Object object) {
        return this.G.getPredNodeCount(object);
    }

    @Override
    public Iterator<Object> getSuccNodes(Object object) {
        return this.G.getSuccNodes(object);
    }

    @Override
    public int getSuccNodeCount(Object object) {
        return this.G.getSuccNodeCount(object);
    }

    @Override
    public void addNode(Object object) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeNode(Object object) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addEdge(Object object, Object object2) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeEdge(Object object, Object object2) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean hasEdge(Object object, Object object2) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public void removeAllIncidentEdges(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(Object object) {
        return this.G.containsNode(object);
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Nodes:\n");
        int n = 0;
        while (n <= this.getMaxNumber()) {
            object = this.getNode(n);
            if (object != null) {
                stringBuffer.append(n).append("  ").append(object).append("\n");
            }
            ++n;
        }
        stringBuffer.append("Edges:\n");
        n = 0;
        while (n <= this.getMaxNumber()) {
            object = this.getNode(n);
            if (object != null) {
                stringBuffer.append(n).append(" -> ");
                Iterator<Object> iterator = this.getSuccNodes(object);
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    stringBuffer.append(this.getNumber(object2)).append(" ");
                }
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public void removeIncomingEdges(Object object) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(Object object) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public IntSet getSuccNodeNumbers(Object object) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(Object object) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LocalPointerComparator
    implements Comparator<Object> {
        private LocalPointerComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            LocalPointerKey localPointerKey = (LocalPointerKey)object;
            LocalPointerKey localPointerKey2 = (LocalPointerKey)object2;
            if (localPointerKey.getNode().equals(localPointerKey2.getNode())) {
                return localPointerKey.getValueNumber() - localPointerKey2.getValueNumber();
            }
            return BasicHeapGraph.this.callGraph.getNumber(localPointerKey.getNode()) - BasicHeapGraph.this.callGraph.getNumber(localPointerKey2.getNode());
        }
    }
}

