/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class SourceBuffer {
    private String[] lines;
    private final CAstSourcePositionMap.Position p;

    public SourceBuffer(CAstSourcePositionMap.Position position) throws IOException {
        this.p = position;
        this.lines = new String[position.getLastLine() - position.getFirstLine() + 1];
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(position.getInputStream()));
        int n = 1;
        while (n <= position.getLastLine()) {
            String string = bufferedReader.readLine();
            if (n >= position.getFirstLine()) {
                this.lines[n - position.getFirstLine()] = n == position.getLastLine() ? string.substring(0, Math.min(string.length(), position.getLastCol() + 1)) : string;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.lines.length) {
            if (n == 0) {
                stringBuffer.append(this.lines[n].substring(this.p.getFirstCol())).append("\n");
            } else if (n == this.lines.length - 1) {
                stringBuffer.append(this.lines[n]);
            } else {
                stringBuffer.append(this.lines[n]).append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void substitute(CAstSourcePositionMap.Position position, String string) {
        String[] stringArray;
        int n;
        int n2 = position.getFirstLine() - this.p.getFirstLine();
        if (n2 != (n = position.getLastLine() - this.p.getFirstLine())) {
            stringArray = new String[this.lines.length - (n - n2)];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = this.lines[n3];
                ++n3;
            }
            stringArray[n3++] = String.valueOf(this.lines[n2].substring(0, position.getFirstCol())) + this.lines[n].substring(position.getLastCol());
            while (n3 < stringArray.length) {
                stringArray[n3] = this.lines[n3 + (n - n2)];
                ++n3;
            }
            this.lines = stringArray;
            n = n2;
            final CAstSourcePositionMap.Position position2 = position;
            position = new AbstractSourcePosition(){

                public int getFirstLine() {
                    return position2.getFirstLine();
                }

                public int getLastLine() {
                    return position2.getFirstLine();
                }

                public int getFirstCol() {
                    return position2.getFirstCol();
                }

                public int getLastCol() {
                    return position2.getFirstCol();
                }

                public int getFirstOffset() {
                    return position2.getFirstOffset();
                }

                public int getLastOffset() {
                    return position2.getFirstOffset();
                }

                public URL getURL() {
                    return position2.getURL();
                }

                public InputStream getInputStream() throws IOException {
                    return position2.getInputStream();
                }
            };
        }
        if ((stringArray = string.split("\n")).length == 1) {
            this.lines[n2] = String.valueOf(this.lines[n2].substring(0, position.getFirstCol())) + stringArray[0] + this.lines[n2].substring(position.getLastCol() + 1);
        } else {
            String[] stringArray2 = new String[this.lines.length + stringArray.length - 1];
            int n4 = 0;
            while (n4 < n2) {
                stringArray2[n4] = this.lines[n4];
                ++n4;
            }
            stringArray2[n4++] = String.valueOf(this.lines[n2].substring(0, position.getFirstCol())) + stringArray[0];
            int n5 = 1;
            while (n5 < stringArray.length - 1) {
                this.lines[n4++] = stringArray[n5];
                ++n5;
            }
            stringArray2[n4++] = String.valueOf(stringArray[stringArray.length - 1]) + this.lines[n].substring(position.getLastCol() + 1);
            while (n4 < stringArray2.length) {
                stringArray2[n4] = this.lines[n4 - stringArray.length + 1];
                ++n4;
            }
            this.lines = stringArray2;
        }
    }
}

