/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.ir.translator.TranslatorToIR;
import com.ibm.wala.cast.loader.CAstAbstractLoader;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.cast.util.TemporaryFile;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.classLoader.SourceURLModule;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.warnings.Warning;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CAstAbstractModuleLoader
extends CAstAbstractLoader {
    private static final boolean DEBUG = false;

    public CAstAbstractModuleLoader(IClassHierarchy iClassHierarchy, IClassLoader iClassLoader) {
        super(iClassHierarchy, iClassLoader);
    }

    public CAstAbstractModuleLoader(IClassHierarchy iClassHierarchy) {
        this(iClassHierarchy, null);
    }

    protected abstract TranslatorToCAst getTranslatorToCAst(CAst var1, ModuleEntry var2, URL var3, String var4);

    protected TranslatorToCAst getTranslatorToCAst(CAst cAst, ModuleEntry moduleEntry, File file, String string) throws MalformedURLException {
        return this.getTranslatorToCAst(cAst, moduleEntry, file.toURI().toURL(), string);
    }

    protected abstract boolean shouldTranslate(CAstEntity var1);

    protected abstract TranslatorToIR initTranslator();

    protected void finishTranslation() {
    }

    public void init(List<Module> list) {
        CAstImpl cAstImpl = new CAstImpl();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        TranslatorToIR translatorToIR = this.initTranslator();
        class TranslatorNestingHack {
            private final /* synthetic */ CAst val$ast;
            private final /* synthetic */ Set val$topLevelEntities;
            private final /* synthetic */ List val$modules;
            private final /* synthetic */ TranslatorToIR val$xlatorToIR;

            TranslatorNestingHack(CAst cAst, Set set, List list, TranslatorToIR translatorToIR) {
                this.val$ast = cAst;
                this.val$topLevelEntities = set;
                this.val$modules = list;
                this.val$xlatorToIR = translatorToIR;
            }

            private void init(ModuleEntry moduleEntry) {
                try {
                    if (moduleEntry.isModuleFile()) {
                        this.init(moduleEntry.asModule());
                    } else if (moduleEntry instanceof SourceFileModule) {
                        String string;
                        File file = ((SourceFileModule)moduleEntry).getFile();
                        TranslatorToCAst translatorToCAst = CAstAbstractModuleLoader.this.getTranslatorToCAst(this.val$ast, moduleEntry, file, string = file.toString());
                        CAstEntity cAstEntity = translatorToCAst.translateToCAst();
                        if (cAstEntity != null) {
                            this.val$topLevelEntities.add(Pair.make((Object)cAstEntity, (Object)string));
                        } else {
                            CAstAbstractModuleLoader.this.addMessage(moduleEntry, new Warning(2){

                                public String getMsg() {
                                    return "parse error";
                                }
                            });
                        }
                    } else if (moduleEntry instanceof SourceURLModule) {
                        URL uRL = ((SourceURLModule)moduleEntry).getURL();
                        String string = ((SourceURLModule)moduleEntry).getName();
                        String string2 = string.replace('/', '_');
                        File file = TemporaryFile.streamToFile(string2, ((SourceURLModule)moduleEntry).getInputStream());
                        TranslatorToCAst translatorToCAst = CAstAbstractModuleLoader.this.getTranslatorToCAst(this.val$ast, moduleEntry, uRL, string2);
                        CAstEntity cAstEntity = translatorToCAst.translateToCAst();
                        if (cAstEntity != null) {
                            this.val$topLevelEntities.add(Pair.make((Object)cAstEntity, (Object)string));
                        } else {
                            CAstAbstractModuleLoader.this.addMessage(moduleEntry, new Warning(2){

                                public String getMsg() {
                                    return "parse error";
                                }
                            });
                        }
                        file.delete();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    CAstAbstractModuleLoader.this.addMessage(moduleEntry, new Warning(2){

                        public String getMsg() {
                            return "Malformed URL issue: " + malformedURLException.getMessage();
                        }
                    });
                }
                catch (IOException iOException) {
                    CAstAbstractModuleLoader.this.addMessage(moduleEntry, new Warning(2){

                        public String getMsg() {
                            return "I/O issue: " + iOException.getMessage();
                        }
                    });
                }
                catch (RuntimeException runtimeException) {
                    final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(byteArrayOutputStream);
                    runtimeException.printStackTrace(printStream);
                    CAstAbstractModuleLoader.this.addMessage(moduleEntry, new Warning(2){

                        public String getMsg() {
                            return "Parsing issue: " + new String(byteArrayOutputStream.toByteArray());
                        }
                    });
                }
            }

            private void init(Module module) {
                Iterator iterator = module.getEntries();
                while (iterator.hasNext()) {
                    this.init((ModuleEntry)iterator.next());
                }
            }

            private void init() {
                Iterator iterator = this.val$modules.iterator();
                while (iterator.hasNext()) {
                    this.init((Module)iterator.next());
                }
                for (Pair pair : this.val$topLevelEntities) {
                    if (!CAstAbstractModuleLoader.this.shouldTranslate((CAstEntity)pair.fst)) continue;
                    this.val$xlatorToIR.translate((CAstEntity)pair.fst, (String)pair.snd);
                }
            }
        }
        new TranslatorNestingHack(cAstImpl, linkedHashSet, list, translatorToIR).init();
        for (TypeName typeName : this.types.keySet()) {
        }
        this.finishTranslation();
    }
}

