/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;

public class AstField
implements IField {
    private final Collection qualifiers;
    private final FieldReference ref;
    private final IClass declaringClass;
    private final IClassHierarchy cha;

    public AstField(FieldReference fieldReference, Collection collection, IClass iClass, IClassHierarchy iClassHierarchy) {
        this.declaringClass = iClass;
        this.qualifiers = collection;
        this.ref = fieldReference;
        this.cha = iClassHierarchy;
    }

    public IClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        return "field " + this.ref.getName();
    }

    public Atom getName() {
        return this.ref.getName();
    }

    public TypeReference getFieldTypeReference() {
        return this.ref.getFieldType();
    }

    public FieldReference getReference() {
        return this.ref;
    }

    public boolean isStatic() {
        return this.qualifiers.contains(CAstQualifier.STATIC);
    }

    public boolean isFinal() {
        return this.qualifiers.contains(CAstQualifier.CONST) || this.qualifiers.contains(CAstQualifier.FINAL);
    }

    public boolean isPrivate() {
        return this.qualifiers.contains(CAstQualifier.PRIVATE);
    }

    public boolean isProtected() {
        return this.qualifiers.contains(CAstQualifier.PROTECTED);
    }

    public boolean isPublic() {
        return this.qualifiers.contains(CAstQualifier.PUBLIC);
    }

    public boolean isVolatile() {
        return this.qualifiers.contains(CAstQualifier.VOLATILE);
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

