/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa.analysis;

import com.ibm.wala.cast.ir.cfg.Util;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveAnalysis {
    public static Result perform(IR iR) {
        return LiveAnalysis.perform((ControlFlowGraph<SSAInstruction, ISSABasicBlock>)iR.getControlFlowGraph(), iR.getSymbolTable());
    }

    public static Result perform(ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph, SymbolTable symbolTable) {
        return LiveAnalysis.perform(controlFlowGraph, symbolTable, new BitVector());
    }

    public static Result perform(final ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph, final SymbolTable symbolTable, final BitVector bitVector) {
        final BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(bitVector);
        final SSAInstruction[] sSAInstructionArray = (SSAInstruction[])controlFlowGraph.getInstructions();
        final BitVectorSolver bitVectorSolver = new BitVectorSolver((IKilldallFramework)new IKilldallFramework<ISSABasicBlock, BitVectorVariable>(){
            private final Graph<ISSABasicBlock> G;
            {
                this.G = GraphInverter.invert((Graph)controlFlowGraph2);
            }

            public Graph<ISSABasicBlock> getFlowGraph() {
                return this.G;
            }

            public ITransferFunctionProvider<ISSABasicBlock, BitVectorVariable> getTransferFunctionProvider() {
                return new ITransferFunctionProvider<ISSABasicBlock, BitVectorVariable>(){

                    public boolean hasNodeTransferFunctions() {
                        return true;
                    }

                    public boolean hasEdgeTransferFunctions() {
                        return false;
                    }

                    public UnaryOperator<BitVectorVariable> getNodeTransferFunction(ISSABasicBlock iSSABasicBlock) {
                        if (iSSABasicBlock.isExitBlock()) {
                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            final class ExitBlockGenKillOperator
                            extends UnaryOperator<BitVectorVariable> {
                                private final /* synthetic */ BitVector val$considerLiveAtExit;
                                private final /* synthetic */ BitVectorIntSet val$liveAtExit;

                                ExitBlockGenKillOperator(BitVector bitVector, BitVectorIntSet bitVectorIntSet) {
                                    this.val$considerLiveAtExit = bitVector;
                                    this.val$liveAtExit = bitVectorIntSet;
                                }

                                public String toString() {
                                    return "ExitGenKill";
                                }

                                public boolean equals(Object object) {
                                    return object == this;
                                }

                                public int hashCode() {
                                    return 37721;
                                }

                                public byte evaluate(BitVectorVariable bitVectorVariable, BitVectorVariable bitVectorVariable2) {
                                    boolean bl = bitVectorVariable.getValue() == null ? !this.val$considerLiveAtExit.isZero() : !bitVectorVariable.getValue().sameValue((IntSet)this.val$liveAtExit);
                                    bitVectorVariable.addAll(this.val$considerLiveAtExit);
                                    return bl ? (byte)1 : 0;
                                }
                            }
                            return new ExitBlockGenKillOperator(bitVector, bitVectorIntSet);
                        }
                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        final class BlockValueGenKillOperator
                        extends UnaryOperator<BitVectorVariable> {
                            private final ISSABasicBlock block;
                            private final /* synthetic */ SymbolTable val$symtab;
                            private final /* synthetic */ ControlFlowGraph val$cfg;
                            private final /* synthetic */ SSAInstruction[] val$instructions;

                            BlockValueGenKillOperator(ISSABasicBlock iSSABasicBlock, SymbolTable symbolTable, ControlFlowGraph controlFlowGraph, SSAInstruction[] sSAInstructionArray) {
                                this.val$symtab = symbolTable;
                                this.val$cfg = controlFlowGraph;
                                this.val$instructions = sSAInstructionArray;
                                this.block = iSSABasicBlock;
                            }

                            public String toString() {
                                return "GenKill:" + this.block;
                            }

                            public boolean equals(Object object) {
                                return object instanceof BlockValueGenKillOperator && ((BlockValueGenKillOperator)((Object)object)).block.equals(this.block);
                            }

                            public int hashCode() {
                                return this.block.hashCode() * 17;
                            }

                            private void processDefs(SSAInstruction sSAInstruction, BitVector bitVector) {
                                int n = 0;
                                while (n < sSAInstruction.getNumberOfDefs()) {
                                    bitVector.clear(sSAInstruction.getDef(n));
                                    ++n;
                                }
                            }

                            private void processUses(SSAInstruction sSAInstruction, BitVector bitVector) {
                                int n = 0;
                                while (n < sSAInstruction.getNumberOfUses()) {
                                    if (!$assertionsDisabled && sSAInstruction.getUse(n) == -1) {
                                        throw new AssertionError((Object)sSAInstruction.toString());
                                    }
                                    if (!this.val$symtab.isConstant(sSAInstruction.getUse(n))) {
                                        bitVector.set(sSAInstruction.getUse(n));
                                    }
                                    ++n;
                                }
                            }

                            public byte evaluate(BitVectorVariable bitVectorVariable, BitVectorVariable bitVectorVariable2) {
                                ISSABasicBlock iSSABasicBlock;
                                BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
                                IntSet intSet = bitVectorVariable2.getValue();
                                if (intSet != null) {
                                    bitVectorIntSet.addAll(intSet);
                                }
                                Iterator iterator = this.val$cfg.getSuccNodes((Object)this.block);
                                while (iterator.hasNext()) {
                                    iSSABasicBlock = (ISSABasicBlock)iterator.next();
                                    int n = Util.whichPred(this.val$cfg, iSSABasicBlock, this.block);
                                    Iterator iterator2 = iSSABasicBlock.iteratePhis();
                                    while (iterator2.hasNext()) {
                                        bitVectorIntSet.add(((SSAPhiInstruction)iterator2.next()).getUse(n));
                                    }
                                }
                                int n = this.block.getLastInstructionIndex();
                                while (n >= this.block.getFirstInstructionIndex()) {
                                    iSSABasicBlock = this.val$instructions[n];
                                    if (iSSABasicBlock != null) {
                                        this.processDefs((SSAInstruction)iSSABasicBlock, bitVectorIntSet.getBitVector());
                                        this.processUses((SSAInstruction)iSSABasicBlock, bitVectorIntSet.getBitVector());
                                    }
                                    --n;
                                }
                                Iterator iterator3 = this.block.iteratePhis();
                                while (iterator3.hasNext()) {
                                    this.processDefs((SSAInstruction)iterator3.next(), bitVectorIntSet.getBitVector());
                                }
                                iterator3 = new BitVectorVariable();
                                iterator3.addAll(bitVectorIntSet.getBitVector());
                                if (!bitVectorVariable.sameValue((BitVectorVariable)iterator3)) {
                                    bitVectorVariable.copyState((BitVectorVariable)iterator3);
                                    return 1;
                                }
                                return 0;
                            }
                        }
                        return new BlockValueGenKillOperator(iSSABasicBlock, symbolTable, controlFlowGraph, sSAInstructionArray);
                    }

                    public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(ISSABasicBlock iSSABasicBlock, ISSABasicBlock iSSABasicBlock2) {
                        Assertions.UNREACHABLE();
                        return null;
                    }

                    public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
                        return BitVectorUnion.instance();
                    }
                };
            }
        });
        try {
            bitVectorSolver.solve(null);
        }
        catch (CancelException cancelException) {
            throw new CancelRuntimeException((Exception)((Object)cancelException));
        }
        return new Result(){

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < controlFlowGraph.getNumberOfNodes()) {
                    ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)controlFlowGraph.getNode(n);
                    stringBuffer.append("live entering ").append(iSSABasicBlock).append(":").append(bitVectorSolver.getOut((Object)iSSABasicBlock)).append("\n");
                    stringBuffer.append("live exiting ").append(iSSABasicBlock).append(":").append(bitVectorSolver.getIn((Object)iSSABasicBlock)).append("\n");
                    ++n;
                }
                return stringBuffer.toString();
            }

            public boolean isLiveEntry(ISSABasicBlock iSSABasicBlock, int n) {
                return ((BitVectorVariable)bitVectorSolver.getOut((Object)iSSABasicBlock)).get(n);
            }

            public boolean isLiveExit(ISSABasicBlock iSSABasicBlock, int n) {
                return ((BitVectorVariable)bitVectorSolver.getIn((Object)iSSABasicBlock)).get(n);
            }

            public BitVector getLiveBefore(int n) {
                ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)controlFlowGraph.getBlockForInstruction(n);
                BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
                IntSet intSet = ((BitVectorVariable)bitVectorSolver.getIn((Object)iSSABasicBlock)).getValue();
                if (intSet != null) {
                    bitVectorIntSet.addAll(intSet);
                }
                int n2 = iSSABasicBlock.getLastInstructionIndex();
                while (n2 >= n) {
                    SSAInstruction sSAInstruction = sSAInstructionArray[n2];
                    if (sSAInstruction != null) {
                        int n3 = 0;
                        while (n3 < sSAInstruction.getNumberOfDefs()) {
                            bitVectorIntSet.remove(sSAInstruction.getDef(n3));
                            ++n3;
                        }
                        n3 = 0;
                        while (n3 < sSAInstruction.getNumberOfUses()) {
                            if (!symbolTable.isConstant(sSAInstruction.getUse(n3))) {
                                bitVectorIntSet.add(sSAInstruction.getUse(n3));
                            }
                            ++n3;
                        }
                    }
                    --n2;
                }
                return bitVectorIntSet.getBitVector();
            }
        };
    }

    public static interface Result {
        public boolean isLiveEntry(ISSABasicBlock var1, int var2);

        public boolean isLiveExit(ISSABasicBlock var1, int var2);

        public BitVector getLiveBefore(int var1);
    }
}

