/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.AstInstructionFactory;
import com.ibm.wala.cast.ir.ssa.AstInstructionVisitor;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstIsDefinedInstruction
extends SSAInstruction {
    private final FieldReference fieldRef;
    private final int fieldVal;
    private final int rval;
    private final int lval;

    public AstIsDefinedInstruction(int n, int n2, int n3, FieldReference fieldReference) {
        this.lval = n;
        this.rval = n2;
        this.fieldVal = n3;
        this.fieldRef = fieldReference;
    }

    public AstIsDefinedInstruction(int n, int n2, FieldReference fieldReference) {
        this.lval = n;
        this.rval = n2;
        this.fieldVal = -1;
        this.fieldRef = fieldReference;
    }

    public AstIsDefinedInstruction(int n, int n2, int n3) {
        this.lval = n;
        this.rval = n2;
        this.fieldVal = n3;
        this.fieldRef = null;
    }

    public AstIsDefinedInstruction(int n, int n2) {
        this.lval = n;
        this.rval = n2;
        this.fieldVal = -1;
        this.fieldRef = null;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        assert (this.fieldVal == -1 || this.fieldRef == null);
        return ((AstInstructionFactory)sSAInstructionFactory).IsDefinedInstruction(nArray == null ? this.lval : nArray[0], nArray2 == null ? this.rval : nArray2[0], nArray2 == null || this.fieldVal == -1 ? this.fieldVal : nArray2[1], this.fieldRef);
    }

    public String toString(SymbolTable symbolTable) {
        if (this.fieldVal == -1 && this.fieldRef == null) {
            return String.valueOf(this.getValueString(symbolTable, this.lval)) + " = isDefined(" + this.getValueString(symbolTable, this.rval) + ")";
        }
        if (this.fieldVal == -1) {
            return String.valueOf(this.getValueString(symbolTable, this.lval)) + " = isDefined(" + this.getValueString(symbolTable, this.rval) + "," + this.fieldRef.getName() + ")";
        }
        if (this.fieldRef == null) {
            return String.valueOf(this.getValueString(symbolTable, this.lval)) + " = isDefined(" + this.getValueString(symbolTable, this.rval) + "," + this.getValueString(symbolTable, this.fieldVal) + ")";
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        ((AstInstructionVisitor)iVisitor).visitIsDefined(this);
    }

    public Collection<TypeReference> getExceptionTypes() {
        return Collections.emptySet();
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.lval;
    }

    public int getDef(int n) {
        assert (n == 0);
        return this.lval;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getNumberOfUses() {
        return this.fieldVal == -1 ? 1 : 2;
    }

    public int getUse(int n) {
        if (n == 0) {
            return this.rval;
        }
        if (n == 1 && this.fieldVal != -1) {
            return this.fieldVal;
        }
        Assertions.UNREACHABLE();
        return -1;
    }

    public boolean isFallThrough() {
        return true;
    }

    public int hashCode() {
        return 3077 * this.fieldVal * this.rval;
    }

    public FieldReference getFieldRef() {
        return this.fieldRef;
    }
}

