/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.MultiReturnValueInvokeInstruction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ssa.SymbolTable;

public abstract class AbstractLexicalInvoke
extends MultiReturnValueInvokeInstruction {
    protected AstLexicalAccess.Access[] lexicalReads = null;
    protected AstLexicalAccess.Access[] lexicalWrites = null;

    protected AbstractLexicalInvoke(int[] nArray, int n, CallSiteReference callSiteReference) {
        super(nArray, n, callSiteReference);
    }

    protected AbstractLexicalInvoke(int n, int n2, CallSiteReference callSiteReference) {
        this(new int[]{n}, n2, callSiteReference);
    }

    protected AbstractLexicalInvoke(int[] nArray, int n, CallSiteReference callSiteReference, AstLexicalAccess.Access[] accessArray, AstLexicalAccess.Access[] accessArray2) {
        this(nArray, n, callSiteReference);
        this.lexicalReads = accessArray;
        this.lexicalWrites = accessArray2;
    }

    public int getNumberOfUses() {
        if (this.lexicalReads == null) {
            return this.getNumberOfParameters();
        }
        return this.getNumberOfParameters() + this.lexicalReads.length;
    }

    public int getNumberOfLexicalWrites() {
        if (this.lexicalWrites == null) {
            return 0;
        }
        return this.lexicalWrites.length;
    }

    public int getNumberOfLexicalReads() {
        if (this.lexicalReads == null) {
            return 0;
        }
        return this.lexicalReads.length;
    }

    public final int getLastLexicalUse() {
        if (this.lexicalReads == null) {
            return -1;
        }
        return this.getNumberOfParameters() + this.lexicalReads.length - 1;
    }

    public int getUse(int n) {
        assert (n >= this.getNumberOfParameters());
        assert (this.lexicalReads != null);
        assert (this.lexicalReads[n - this.getNumberOfParameters()] != null);
        return this.lexicalReads[n - this.getNumberOfParameters()].valueNumber;
    }

    public int getNumberOfDefs() {
        if (this.lexicalWrites == null) {
            return super.getNumberOfDefs();
        }
        return super.getNumberOfDefs() + this.lexicalWrites.length;
    }

    public int getDef(int n) {
        if (n < super.getNumberOfDefs()) {
            return super.getDef(n);
        }
        return this.lexicalWrites[n - super.getNumberOfDefs()].valueNumber;
    }

    private AstLexicalAccess.Access[] addAccess(AstLexicalAccess.Access[] accessArray, AstLexicalAccess.Access access) {
        if (accessArray == null) {
            return new AstLexicalAccess.Access[]{access};
        }
        AstLexicalAccess.Access[] accessArray2 = new AstLexicalAccess.Access[accessArray.length + 1];
        System.arraycopy(accessArray, 0, accessArray2, 0, accessArray.length);
        accessArray2[accessArray.length] = access;
        return accessArray2;
    }

    public boolean isLexicalUse(int n) {
        return n >= super.getNumberOfUses();
    }

    public void addLexicalUse(AstLexicalAccess.Access access) {
        this.lexicalReads = this.addAccess(this.lexicalReads, access);
    }

    public AstLexicalAccess.Access getLexicalUse(int n) {
        return this.lexicalReads[n - this.getNumberOfParameters()];
    }

    public boolean isLexicalDef(int n) {
        return n >= super.getNumberOfDefs();
    }

    public void addLexicalDef(AstLexicalAccess.Access access) {
        this.lexicalWrites = this.addAccess(this.lexicalWrites, access);
    }

    public AstLexicalAccess.Access getLexicalDef(int n) {
        return this.lexicalWrites[n - super.getNumberOfDefs()];
    }

    public int hashCode() {
        return this.site.hashCode() * 7529;
    }

    public String toString(SymbolTable symbolTable) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.toString(symbolTable));
        if (this.lexicalReads != null) {
            stringBuffer.append(" (reads:");
            n = 0;
            while (n < this.lexicalReads.length) {
                stringBuffer.append(" ").append(this.lexicalReads[n].variableName).append(":").append(this.getValueString(symbolTable, this.lexicalReads[n].valueNumber));
                ++n;
            }
            stringBuffer.append(")");
        }
        if (this.lexicalWrites != null) {
            stringBuffer.append(" (writes:");
            n = 0;
            while (n < this.lexicalWrites.length) {
                stringBuffer.append(" ").append(this.lexicalWrites[n].variableName).append(":").append(this.getValueString(symbolTable, this.lexicalWrites[n].valueNumber));
                ++n;
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

