/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.types;

import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class JavaPrimitiveTypeMap {
    public static final Map<String, JavaPrimitiveType> primNameMap = HashMapFactory.make();
    public static final JavaPrimitiveType VoidType = new JavaPrimitiveType("void", "V");

    static {
        primNameMap.put("int", new JavaPrimitiveType("int", "I"));
        primNameMap.put("long", new JavaPrimitiveType("long", "J"));
        primNameMap.put("short", new JavaPrimitiveType("short", "S"));
        primNameMap.put("char", new JavaPrimitiveType("char", "C"));
        primNameMap.put("byte", new JavaPrimitiveType("byte", "B"));
        primNameMap.put("boolean", new JavaPrimitiveType("boolean", "Z"));
        primNameMap.put("float", new JavaPrimitiveType("float", "F"));
        primNameMap.put("double", new JavaPrimitiveType("double", "D"));
        primNameMap.put("void", VoidType);
    }

    public static String getShortName(String string) {
        return primNameMap.get(string).getName();
    }

    public static JavaPrimitiveType lookupType(String string) {
        return primNameMap.get(string);
    }

    public static class JavaPrimitiveType
    implements CAstType.Primitive {
        String fLongName;
        String fShortName;

        private JavaPrimitiveType(String string, String string2) {
            this.fLongName = string;
            this.fShortName = string2;
        }

        public String getName() {
            return this.fShortName;
        }

        public String getLongName() {
            return this.fLongName;
        }

        public Collection getSupertypes() {
            return Collections.EMPTY_LIST;
        }
    }
}

