/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.ipa.slicer;

import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.java.ipa.modref.AstJavaModRef;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.PartialCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstJavaSlicer
extends Slicer {
    public static Collection<Statement> computeBackwardSlice(SDG sDG, Collection<Statement> collection) throws IllegalArgumentException, CancelException {
        return AstJavaSlicer.computeSlice(sDG, collection, true);
    }

    public static Collection<Statement> computeSlice(SDG sDG, Collection<Statement> collection, boolean bl) throws CancelException {
        return new AstJavaSlicer().slice(sDG, collection, bl);
    }

    public static Set<Statement> gatherStatements(CallGraph callGraph, Collection<CGNode> collection, Filter<SSAInstruction> filter) {
        HashSet<Statement> hashSet = new HashSet<Statement>();
        for (CGNode cGNode : DFS.getReachableNodes((Graph)callGraph, collection)) {
            IR iR = cGNode.getIR();
            if (iR == null) continue;
            SSAInstruction[] sSAInstructionArray = iR.getInstructions();
            int n = 0;
            while (n < sSAInstructionArray.length) {
                if (filter.accepts((Object)sSAInstructionArray[n])) {
                    hashSet.add((Statement)new NormalStatement(cGNode, n));
                }
                ++n;
            }
        }
        return hashSet;
    }

    public static Set<Statement> gatherAssertions(CallGraph callGraph, Collection<CGNode> collection) {
        return AstJavaSlicer.gatherStatements(callGraph, collection, new Filter<SSAInstruction>(){

            public boolean accepts(SSAInstruction sSAInstruction) {
                return sSAInstruction instanceof AstAssertInstruction;
            }
        });
    }

    public static Set<Statement> gatherMonitors(CallGraph callGraph, Collection<CGNode> collection) {
        return AstJavaSlicer.gatherStatements(callGraph, collection, new Filter<SSAInstruction>(){

            public boolean accepts(SSAInstruction sSAInstruction) {
                return sSAInstruction instanceof SSAMonitorInstruction;
            }
        });
    }

    public static Set<Statement> gatherWrites(CallGraph callGraph, Collection<CGNode> collection) {
        return AstJavaSlicer.gatherStatements(callGraph, collection, new Filter<SSAInstruction>(){

            public boolean accepts(SSAInstruction sSAInstruction) {
                return sSAInstruction instanceof SSAPutInstruction || sSAInstruction instanceof SSAArrayStoreInstruction;
            }
        });
    }

    public static Set<Statement> gatherReads(CallGraph callGraph, Collection<CGNode> collection) {
        return AstJavaSlicer.gatherStatements(callGraph, collection, new Filter<SSAInstruction>(){

            public boolean accepts(SSAInstruction sSAInstruction) {
                return sSAInstruction instanceof SSAGetInstruction || sSAInstruction instanceof SSAArrayLoadInstruction;
            }
        });
    }

    public static Pair<Collection<Statement>, SDG> computeAssertionSlice(CallGraph callGraph, PointerAnalysis pointerAnalysis, Collection<CGNode> collection, boolean bl) throws IllegalArgumentException, CancelException {
        PartialCallGraph partialCallGraph = PartialCallGraph.make((CallGraph)callGraph, new LinkedHashSet<CGNode>(collection));
        SDG sDG = new SDG((CallGraph)partialCallGraph, pointerAnalysis, (ModRef)new AstJavaModRef(), Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.FULL);
        System.err.println("SDG:\n" + sDG);
        Set<Statement> set = AstJavaSlicer.gatherAssertions(callGraph, collection);
        if (bl) {
            set.addAll(AstJavaSlicer.gatherReads(callGraph, collection));
            set.addAll(AstJavaSlicer.gatherWrites(callGraph, collection));
            set.addAll(AstJavaSlicer.gatherMonitors(callGraph, collection));
        }
        return Pair.make(AstJavaSlicer.computeBackwardSlice(sDG, set), (Object)sDG);
    }
}

