/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.client;

import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.java.client.impl.ZeroCFABuilderFactory;
import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.FileOfClasses;
import java.io.File;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaSourceAnalysisEngine
extends AbstractAnalysisEngine {
    private final Set<Module> userEntries = HashSetFactory.make();
    private final Set<Module> sourceEntries = HashSetFactory.make();
    private final Set<Module> systemEntries = HashSetFactory.make();

    public void addSourceModule(Module module) {
        this.sourceEntries.add(module);
    }

    public void addCompiledModule(Module module) {
        this.userEntries.add(module);
    }

    public void addSystemModule(Module module) {
        this.systemEntries.add(module);
    }

    protected void addApplicationModulesToScope() {
        Module module2;
        ClassLoaderReference classLoaderReference = this.scope.getApplicationLoader();
        for (Module module2 : this.userEntries) {
            this.scope.addToScope(classLoaderReference, module2);
        }
        module2 = ((JavaSourceAnalysisScope)this.scope).getSourceLoader();
        for (Module module3 : this.sourceEntries) {
            this.scope.addToScope((ClassLoaderReference)module2, module3);
        }
    }

    public void buildAnalysisScope() throws IOException {
        this.scope = this.makeSourceAnalysisScope();
        if (this.getExclusionsFile() != null) {
            this.scope.setExclusions((SetOfClasses)FileOfClasses.createFileOfClasses((File)new File(this.getExclusionsFile())));
        }
        for (Module module : this.systemEntries) {
            this.scope.addToScope(this.scope.getPrimordialLoader(), module);
        }
        this.addApplicationModulesToScope();
    }

    protected AnalysisScope makeSourceAnalysisScope() {
        return new JavaSourceAnalysisScope();
    }

    protected abstract ClassLoaderFactory getClassLoaderFactory(SetOfClasses var1);

    public IClassHierarchy buildClassHierarchy() {
        ClassHierarchy classHierarchy = null;
        ClassLoaderFactory classLoaderFactory = this.getClassLoaderFactory(this.scope.getExclusions());
        try {
            classHierarchy = ClassHierarchy.make((AnalysisScope)this.getScope(), (ClassLoaderFactory)classLoaderFactory);
        }
        catch (ClassHierarchyException classHierarchyException) {
            System.err.println("Class Hierarchy construction failed");
            System.err.println(classHierarchyException.toString());
            classHierarchyException.printStackTrace();
        }
        return classHierarchy;
    }

    protected Iterable<Entrypoint> makeDefaultEntrypoints(AnalysisScope analysisScope, IClassHierarchy iClassHierarchy) {
        return Util.makeMainEntrypoints((ClassLoaderReference)JavaSourceAnalysisScope.SOURCE, (IClassHierarchy)iClassHierarchy);
    }

    public AnalysisCache makeDefaultCache() {
        return new AnalysisCache(AstIRFactory.makeDefaultFactory());
    }

    public AnalysisOptions getDefaultOptions(Iterable<Entrypoint> iterable) {
        AnalysisOptions analysisOptions = new AnalysisOptions(this.getScope(), iterable);
        SSAOptions sSAOptions = new SSAOptions();
        sSAOptions.setDefaultValues(new SSAOptions.DefaultValues(){

            public int getDefaultValue(SymbolTable symbolTable, int n) {
                return symbolTable.getDefaultValue(n);
            }
        });
        analysisOptions.setSSAOptions(sSAOptions);
        return analysisOptions;
    }

    protected CallGraphBuilder getCallGraphBuilder(IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache) {
        return new ZeroCFABuilderFactory().make(analysisOptions, analysisCache, iClassHierarchy, this.scope, false);
    }
}

