/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.analysis.typeInference.TypeVariable;
import com.ibm.wala.cast.analysis.typeInference.AstTypeInference;
import com.ibm.wala.cast.ir.ssa.AstConstants;
import com.ibm.wala.cast.java.ssa.AstJavaInstructionVisitor;
import com.ibm.wala.cast.java.ssa.AstJavaInvokeInstruction;
import com.ibm.wala.cast.java.ssa.EnclosingObjectReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.dataflow.ssa.SSAInference;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public class AstJavaTypeInference
extends AstTypeInference {
    protected final IClass stringClass;

    public AstJavaTypeInference(IR iR, IClassHierarchy iClassHierarchy, boolean bl) {
        super(iR, iClassHierarchy, (TypeAbstraction)JavaPrimitiveType.BOOLEAN, bl);
        this.stringClass = iClassHierarchy.lookupClass(TypeReference.JavaLangString);
    }

    protected void initialize() {
        this.init(this.ir, (SSAInference.VariableFactory)new AstJavaTypeVarFactory(), (SSAInference.OperatorFactory)new AstJavaTypeOperatorFactory());
    }

    public TypeAbstraction getConstantPrimitiveType(int n) {
        SymbolTable symbolTable = this.ir.getSymbolTable();
        if (symbolTable.isBooleanConstant(n)) {
            return this.language.getPrimitive(this.language.getConstantType((Object)Boolean.TRUE));
        }
        return super.getConstantPrimitiveType(n);
    }

    protected class AstJavaTypeOperatorFactory
    extends AstTypeInference.AstTypeOperatorFactory
    implements AstJavaInstructionVisitor {
        protected AstJavaTypeOperatorFactory() {
            super((AstTypeInference)AstJavaTypeInference.this);
        }

        public void visitBinaryOp(SSABinaryOpInstruction sSABinaryOpInstruction) {
            if (AstJavaTypeInference.this.doPrimitives) {
                IBinaryOpInstruction.IOperator iOperator = sSABinaryOpInstruction.getOperator();
                this.result = iOperator == AstConstants.BinaryOp.EQ || iOperator == AstConstants.BinaryOp.NE || iOperator == AstConstants.BinaryOp.LT || iOperator == AstConstants.BinaryOp.GE || iOperator == AstConstants.BinaryOp.GT || iOperator == AstConstants.BinaryOp.LE ? new TypeInference.DeclaredTypeOperator((TypeAbstraction)AstJavaTypeInference.this.language.getPrimitive(AstJavaTypeInference.this.language.getConstantType((Object)Boolean.TRUE))) : new PrimAndStringOp();
            }
        }

        public void visitEnclosingObjectReference(EnclosingObjectReference enclosingObjectReference) {
            TypeReference typeReference = enclosingObjectReference.getEnclosingType();
            IClass iClass = AstJavaTypeInference.this.cha.lookupClass(typeReference);
            if (iClass == null) {
                Assertions.UNREACHABLE();
            } else {
                this.result = new TypeInference.DeclaredTypeOperator((TypeAbstraction)new ConeType(iClass));
            }
        }

        public void visitJavaInvoke(AstJavaInvokeInstruction astJavaInvokeInstruction) {
            IClass iClass;
            TypeReference typeReference = astJavaInvokeInstruction.getDeclaredResultType();
            this.result = typeReference.isReferenceType() ? ((iClass = AstJavaTypeInference.this.cha.lookupClass(typeReference)) == null ? new TypeInference.DeclaredTypeOperator(AstJavaTypeInference.this.BOTTOM) : new TypeInference.DeclaredTypeOperator((TypeAbstraction)new ConeType(iClass))) : (AstJavaTypeInference.this.doPrimitives && typeReference.isPrimitiveType() ? new TypeInference.DeclaredTypeOperator((TypeAbstraction)PrimitiveType.getPrimitive((TypeReference)typeReference)) : null);
        }
    }

    public class AstJavaTypeVarFactory
    extends TypeInference.TypeVarFactory {
        public AstJavaTypeVarFactory() {
            super((TypeInference)AstJavaTypeInference.this);
        }

        public IVariable makeVariable(int n) {
            SymbolTable symbolTable = AstJavaTypeInference.this.ir.getSymbolTable();
            if (symbolTable.isStringConstant(n)) {
                IClass iClass = AstJavaTypeInference.this.cha.lookupClass(TypeReference.JavaLangString);
                PointType pointType = new PointType(iClass);
                return new TypeVariable((TypeAbstraction)pointType);
            }
            return super.makeVariable(n);
        }
    }

    protected class PrimAndStringOp
    extends TypeInference.PrimitivePropagateOperator {
        private PrimAndStringOp() {
        }

        public byte evaluate(TypeVariable typeVariable, IVariable[] iVariableArray) {
            TypeAbstraction typeAbstraction;
            PointType pointType = null;
            int n = 0;
            while (n < iVariableArray.length) {
                if (iVariableArray[n] != null) {
                    typeAbstraction = (TypeVariable)iVariableArray[n];
                    TypeAbstraction typeAbstraction2 = typeAbstraction.getType();
                    if (typeAbstraction2 instanceof PointType) {
                        if (typeAbstraction2.getType().equals(AstJavaTypeInference.this.stringClass)) {
                            pointType = new PointType(typeAbstraction2.getType());
                            break;
                        }
                    } else if (typeAbstraction2 instanceof ConeType && typeAbstraction2.getType().equals(AstJavaTypeInference.this.stringClass)) {
                        pointType = new PointType(typeAbstraction2.getType());
                        break;
                    }
                }
                ++n;
            }
            if (pointType == null) {
                return super.evaluate(typeVariable, iVariableArray);
            }
            TypeVariable typeVariable2 = typeVariable;
            typeAbstraction = typeVariable2.getType();
            if (typeAbstraction.equals(pointType)) {
                return 0;
            }
            typeVariable2.setType(pointType);
            return 1;
        }

        public int hashCode() {
            return 71292;
        }

        public boolean equals(Object object) {
            return object != null && object.getClass().equals(((Object)((Object)this)).getClass());
        }
    }
}

