/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.impl.ColumnImpl;
import org.apache.ws.jaxme.sqls.impl.ColumnSetImpl;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;
import org.apache.ws.jaxme.sqls.impl.TableImpl;

public class IndexImpl
extends ColumnSetImpl
implements Index {
    private final List columns = new ArrayList();
    private final boolean unique;
    private final boolean primaryKey;
    private Index.Name name;

    IndexImpl(Table pTable, boolean pUnique, boolean pPrimaryKey) {
        super(pTable);
        this.unique = pUnique;
        this.primaryKey = pPrimaryKey;
        if (this.primaryKey && !this.unique) {
            throw new IllegalArgumentException("A primary key must be unique.");
        }
        this.setName(pTable.getName() + "_" + "I" + ((TableImpl)pTable).indexNameCounter++);
    }

    public void setName(Index.Name pName) {
        if (pName == null) {
            throw new NullPointerException("An index name must not be null.");
        }
        this.name = pName;
    }

    public void setName(String pName) {
        if (pName == null) {
            throw new NullPointerException("An index name must not be null.");
        }
        this.setName(new NameImpl(pName));
    }

    public Index.Name getName() {
        return this.name;
    }

    public void addColumn(Column pColumn) {
        if (this.columns.contains(pColumn)) {
            throw new IllegalStateException("The column " + pColumn.getName() + " was already added to the key.");
        }
        this.columns.add(pColumn);
    }

    public void addColumn(Column.Name pName) {
        Column column = this.getTable().getColumn(pName);
        if (column == null) {
            throw new NullPointerException("The table " + this.getTable().getName() + " doesn't contain a column " + pName);
        }
        this.addColumn(column);
    }

    public void addColumn(String pName) {
        this.addColumn(new ColumnImpl.NameImpl(pName));
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Iterator getColumns() {
        return this.columns.iterator();
    }

    public static class NameImpl
    extends SQLFactoryImpl.IdentImpl
    implements Index.Name {
        public NameImpl(String pName) {
            super(pName);
        }
    }
}

