/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.common;

import com.horstmann.violet.framework.diagram.DiagramLink;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.RectangularNode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Locale;
import java.util.ResourceBundle;

public class DiagramLinkNode
extends RectangularNode {
    private MultiLineString label = new MultiLineString();
    private DiagramLink diagramLink;
    private static int DEFAULT_WIDTH = 48;
    private static int DEFAULT_HEIGHT = 32;
    private static int DEFAULT_SIZE = 32;

    public DiagramLinkNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        Rectangle2D.Double top = new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
        Rectangle2D bot = this.getLabel().getBounds(g2);
        this.snapBounds(grid, Math.max(((RectangularShape)top).getWidth(), bot.getWidth()), ((RectangularShape)top).getHeight() + bot.getHeight());
    }

    @Override
    public void draw(Graphics2D g2) {
        Rectangle2D bounds = this.getBounds();
        GeneralPath path1 = new GeneralPath();
        float x1 = (float)(bounds.getCenterX() - (double)(DEFAULT_SIZE / 2) + (double)(DEFAULT_SIZE / 8));
        float y1 = (float)(bounds.getCenterY() - (double)(DEFAULT_SIZE / 2));
        float x2 = x1 + (float)(DEFAULT_SIZE / 4);
        float y2 = y1;
        float x3 = x2 + (float)(DEFAULT_SIZE / 4);
        float y3 = y2 + (float)(DEFAULT_SIZE / 4);
        float x4 = x3;
        float y4 = y3 + (float)(DEFAULT_SIZE / 4);
        float x5 = x2;
        float y5 = y4 + (float)(DEFAULT_SIZE / 4);
        float x6 = x1;
        float y6 = y5;
        path1.moveTo(x1, y1);
        path1.lineTo(x2, y2);
        path1.lineTo(x3, y3);
        path1.lineTo(x4, y4);
        path1.lineTo(x5, y5);
        path1.lineTo(x6, y6);
        Rectangle2D.Float rec1 = new Rectangle2D.Float();
        ((Rectangle2D)rec1).setRect(x1 - (float)(DEFAULT_SIZE / 2), y1 - (float)(DEFAULT_SIZE / 12), DEFAULT_SIZE / 2, y6 - y1 + (float)(2 * DEFAULT_SIZE / 12));
        x1 = (float)(2.0 * bounds.getCenterX() - (double)x1);
        x2 = (float)(2.0 * bounds.getCenterX() - (double)x2);
        x3 = (float)(2.0 * bounds.getCenterX() - (double)x3);
        x4 = (float)(2.0 * bounds.getCenterX() - (double)x4);
        x5 = (float)(2.0 * bounds.getCenterX() - (double)x5);
        x6 = (float)(2.0 * bounds.getCenterX() - (double)x6);
        GeneralPath path2 = new GeneralPath();
        path2.moveTo(x1, y1);
        path2.lineTo(x2, y2);
        path2.lineTo(x3, y3);
        path2.lineTo(x4, y4);
        path2.lineTo(x5, y5);
        path2.lineTo(x6, y6);
        Rectangle2D.Float rec2 = new Rectangle2D.Float();
        ((Rectangle2D)rec2).setRect(x1, y1 - (float)(DEFAULT_SIZE / 12), DEFAULT_SIZE / 2, y6 - y1 + (float)(2 * DEFAULT_SIZE / 12));
        Color backupcolor = g2.getColor();
        g2.setColor(Color.WHITE);
        g2.fill(rec1);
        g2.fill(rec2);
        g2.setColor(backupcolor);
        g2.draw(path1);
        g2.draw(path2);
        g2.draw(rec1);
        g2.draw(rec2);
        Rectangle2D bot = this.getLabel().getBounds(g2);
        Rectangle2D.Double namebox = new Rectangle2D.Double(bounds.getX() + (bounds.getWidth() - bot.getWidth()) / 2.0, bounds.getY() + bounds.getHeight() - bot.getHeight(), bot.getWidth(), bot.getHeight());
        this.getLabel().draw(g2, namebox);
    }

    public DiagramLink getDiagramLink() {
        return this.diagramLink;
    }

    public void setDiagramLink(DiagramLink fLink) {
        this.diagramLink = fLink;
    }

    private MultiLineString getLabel() {
        DiagramLink dl;
        if (this.label == null) {
            this.label = new MultiLineString();
        }
        if ((dl = this.getDiagramLink()) != null && dl.getURL() != null) {
            StringBuffer linktext = new StringBuffer().append(ResourceBundle.getBundle("properties.OtherStrings", Locale.getDefault()).getString("file.link.text")).append(" ").append(dl.getURL().getFile());
            this.label.setText(linktext.toString());
        }
        return this.label;
    }
}

