/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.preference;

import com.horstmann.violet.framework.preference.PreferencesConstant;
import com.horstmann.violet.framework.preference.PreferencesService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class JNLPPreferencesService
implements PreferencesService {
    @Override
    public String get(PreferencesConstant key, String defval) {
        try {
            BasicService basic = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL codeBase = basic.getCodeBase();
            PersistenceService service = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            URL keyURL = new URL(codeBase, key.toString());
            FileContents contents = service.get(keyURL);
            InputStream in = contents.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String r = reader.readLine();
            if (r != null) {
                return r;
            }
        }
        catch (UnavailableServiceException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return defval;
    }

    @Override
    public void put(PreferencesConstant key, String value) {
        try {
            BasicService basic = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL codeBase = basic.getCodeBase();
            PersistenceService service = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            URL keyURL = new URL(codeBase, key.toString());
            try {
                service.delete(keyURL);
            }
            catch (Exception ex) {
                // empty catch block
            }
            byte[] bytes = value.getBytes("UTF-8");
            service.create(keyURL, (long)bytes.length);
            FileContents contents = service.get(keyURL);
            OutputStream out = contents.getOutputStream(true);
            out.write(bytes);
            out.close();
        }
        catch (UnavailableServiceException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reset() {
        try {
            BasicService basic = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL codeBase = basic.getCodeBase();
            PersistenceService service = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            for (int i = 0; i < PreferencesConstant.LIST.length; ++i) {
                URL keyURL = new URL(codeBase, PreferencesConstant.LIST[i].toString());
                try {
                    service.delete(keyURL);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (UnavailableServiceException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

