/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.sidebar;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.gui.sidebar.Tool;
import com.horstmann.violet.framework.gui.theme.Theme;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.resources.ResourceBundleUtils;
import com.horstmann.violet.framework.swingextension.CustomToggleButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class SideToolPanel
extends JPanel {
    private List<Listener> listeners = new ArrayList<Listener>();
    private Tool[] tools;
    private CustomToggleButton[] toggleButtons;

    public SideToolPanel(Graph graph) {
        this.tools = this.getTools(graph);
        this.toggleButtons = this.getToggleButtons(this.tools);
        JPanel buttonPanel = this.getButtonPanel(this.toggleButtons);
        this.setLayout(new BorderLayout());
        this.add((Component)buttonPanel, "Center");
        this.setBackground(ThemeManager.getInstance().getTheme().getSIDEBAR_ELEMENT_BACKGROUND_COLOR());
        this.reset();
    }

    private Tool[] getTools(Graph graph) {
        Tool aTool;
        String label;
        int i;
        Node[] nodeTypes = graph.getNodePrototypes();
        Edge[] edgeTypes = graph.getEdgePrototypes();
        int length = nodeTypes.length + edgeTypes.length + 1;
        ResourceBundle graphResources = ResourceBundleUtils.getStringsResourceBundleForObject(graph);
        Tool[] tools = new Tool[length];
        tools[0] = this.getSelectionTool();
        int j = 1;
        for (i = 0; i < nodeTypes.length; ++i) {
            label = graphResources.getString("node" + (i + 1) + ".tooltip");
            tools[j] = aTool = new Tool(nodeTypes[i], label);
            ++j;
        }
        for (i = 0; i < edgeTypes.length; ++i) {
            label = graphResources.getString("edge" + (i + 1) + ".tooltip");
            tools[j] = aTool = new Tool(edgeTypes[i], label);
            ++j;
        }
        return tools;
    }

    private Tool getSelectionTool() {
        return new Tool();
    }

    public Tool getSelectedTool() {
        for (int i = 0; i < this.toggleButtons.length; ++i) {
            CustomToggleButton button = this.toggleButtons[i];
            if (!button.isSelected()) continue;
            return this.tools[i];
        }
        this.reset();
        return this.tools[0];
    }

    private CustomToggleButton[] getToggleButtons(Tool[] tools) {
        CustomToggleButton[] buttons = new CustomToggleButton[tools.length];
        for (int i = 0; i < tools.length; ++i) {
            CustomToggleButton button;
            Tool aTool = tools[i];
            Theme cLAF = ThemeManager.getInstance().getTheme();
            buttons[i] = button = new CustomToggleButton(aTool.getLabel(), aTool.getIcon(), cLAF.getTOGGLEBUTTON_SELECTED_COLOR(), cLAF.getTOGGLEBUTTON_SELECTED_BORDER_COLOR(), cLAF.getTOGGLEBUTTON_UNSELECTED_COLOR());
        }
        return buttons;
    }

    private void setSelectedButton(CustomToggleButton selectedButton) {
        for (int i = 0; i < this.toggleButtons.length; ++i) {
            CustomToggleButton button = this.toggleButtons[i];
            if (button != selectedButton) {
                button.setSelected(false);
            }
            if (button != selectedButton) continue;
            button.setSelected(true);
            this.fireToolChangeEvent(this.tools[i]);
        }
    }

    public void selectNextButton() {
        for (int i = 0; i < this.toggleButtons.length; ++i) {
            CustomToggleButton button = this.toggleButtons[i];
            if (!button.isSelected() || i >= this.toggleButtons.length - 1) continue;
            this.setSelectedButton(this.toggleButtons[i + 1]);
            return;
        }
    }

    public void selectPreviousButton() {
        for (int i = 0; i < this.toggleButtons.length; ++i) {
            CustomToggleButton button = this.toggleButtons[i];
            if (!button.isSelected() || i <= 0) continue;
            this.setSelectedButton(this.toggleButtons[i - 1]);
            return;
        }
    }

    private JPanel getButtonPanel(CustomToggleButton[] buttons) {
        JPanel buttonPanel = new JPanel();
        for (int i = 0; i < buttons.length; ++i) {
            final CustomToggleButton button = buttons[i];
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    SideToolPanel.this.setSelectedButton(button);
                }
            });
            buttonPanel.add(button);
        }
        buttonPanel.setLayout(new GridLayout(0, 1));
        buttonPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int scroll = e.getUnitsToScroll();
                if (scroll > 0) {
                    SideToolPanel.this.selectNextButton();
                }
                if (scroll < 0) {
                    SideToolPanel.this.selectPreviousButton();
                }
            }
        });
        return buttonPanel;
    }

    private void fireToolChangeEvent(Tool tool) {
        for (Listener listener : this.listeners) {
            listener.toolSelectionChanged(tool);
        }
    }

    public void reset() {
        if (this.toggleButtons.length > 0) {
            this.setSelectedButton(this.toggleButtons[0]);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void toolSelectionChanged(Tool var1);
    }
}

