/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.menu;

import com.horstmann.violet.framework.action.HelpAction;
import com.horstmann.violet.framework.gui.EditorFrame;
import com.horstmann.violet.framework.resources.ResourceFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class HelpMenu
extends JMenu {
    private JFrame editorFrame;
    private ResourceFactory menuFactory;
    private HelpAction helpAction;

    public HelpMenu(EditorFrame editorFrame, ResourceFactory factory) {
        this.editorFrame = editorFrame;
        this.menuFactory = factory;
        this.helpAction = new HelpAction();
        this.createMenu();
    }

    private void createMenu() {
        this.menuFactory.configureMenu(this, "help");
        JMenuItem userGuideItem = this.menuFactory.createMenuItem("help.userguide");
        userGuideItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpMenu.this.performOpenUserGuide();
            }
        });
        this.add(userGuideItem);
        JMenuItem homepageItem = this.menuFactory.createMenuItem("help.homepage");
        homepageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpMenu.this.performOpenHomePage();
            }
        });
        this.add(homepageItem);
        JMenuItem aboutItem = this.menuFactory.createMenuItem("help.about");
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpMenu.this.performShowAboutDialog();
            }
        });
        this.add(aboutItem);
    }

    private void performShowAboutDialog() {
        this.helpAction.showAboutDialog(this.editorFrame);
    }

    private void performOpenUserGuide() {
        this.helpAction.openUserGuide();
    }

    private void performOpenHomePage() {
        this.helpAction.openHomepage();
    }
}

