/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.contentassist;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.ImageUtils;
import com.aptana.ide.editor.css.CSSColors;
import com.aptana.ide.editor.css.CSSLanguageEnvironment;
import com.aptana.ide.editor.css.CSSOffsetMapper;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.contentassist.CSSCompletionProposal;
import com.aptana.ide.editor.css.contentassist.CSSCompletionProposalComparator;
import com.aptana.ide.editor.css.contentassist.CSSContextInformationValidator;
import com.aptana.ide.editor.css.contentassist.Messages;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.contentassist.UnifiedContentAssistProcessor;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataEnvironment;
import com.aptana.ide.metadata.MetadataEnvironment;
import com.aptana.ide.metadata.ValueMetadata;
import com.aptana.ide.parsing.IOffsetMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSContentAssistProcessor
extends UnifiedContentAssistProcessor
implements IContentAssistProcessor {
    private static final String VALUE_PROPOSAL_ALL = "*";
    private static final String CSS_CLASS_PREFIX = ".";
    private static final String CSS_ID_PREFIX = "#";
    private static final String COLON = ":";
    private static final String HTML_MIME_TYPE = "text/html";
    private IContextInformationValidator validator;
    boolean initalPopup = false;
    boolean forceActivated = false;
    private static Image fIconField = UnifiedEditorsPlugin.getImage((String)"icons/field_public.gif");
    private static Image fIconFile = UnifiedEditorsPlugin.getImage((String)"icons/file.gif");
    private static Image fIconFolder = UnifiedEditorsPlugin.getImage((String)"icons/folder.gif");
    private static Image fIconTag = UnifiedEditorsPlugin.getImage((String)"icons/html_tag.gif");
    private static Image fIconTagGuess = UnifiedEditorsPlugin.getImage((String)"icons/html_tag_guess.gif");
    private CSSCompletionProposalComparator contentAssistComparator;
    private int offset;
    public static String INSIDE_RULE = "INSIDE_RULE";
    public static String OUTSIDE_RULE = "OUTSIDE_RULE";
    public static String ARG_ASSIST = "ARG_ASSIST";
    public static String ERROR = "ERROR";
    private String AUTO_ADDED = Messages.CSSContentAssistProcessor_AutoAdded;
    private String currentLocation;
    private String lexemeHash = "";
    private String propertyPrefix;
    private String valuePrefix;
    private EditorFileContext context;
    private IMetadataEnvironment environment;

    public CSSContentAssistProcessor(EditorFileContext context) {
        this.context = context;
        this.environment = (IMetadataEnvironment)CSSLanguageEnvironment.getInstance().getRuntimeEnvironment();
        this.contentAssistComparator = new CSSCompletionProposalComparator();
        this.validator = new CSSContextInformationValidator(this);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{':', '\t', '{', ';'};
    }

    public int[] getCompletionProposalSeparatorLexemes() {
        return new int[]{29, 30, 32, 31};
    }

    public ICompletionProposal[] computeInnerCompletionProposals(ITextViewer viewer, int offset, int position, LexemeList lexemeList, char activationChar, char previousChar) {
        this.offset = offset;
        if (position < 0) {
            return new ICompletionProposal[0];
        }
        Lexeme currentLexeme = lexemeList.get(position);
        if (this.unifiedViewer != null && this.unifiedViewer.isHotkeyActivated()) {
            this.unifiedViewer.setHotkeyActivated(false);
            activationChar = DEFAULT_CHARACTER;
        }
        if (currentLexeme != null && currentLexeme.getLanguage().equals(HTML_MIME_TYPE) && position > 0) {
            currentLexeme = lexemeList.get(position - 1);
        }
        this.currentLocation = this.getLocation(offset, position, lexemeList, previousChar);
        if (this.currentLocation.equals(ERROR)) {
            return new ICompletionProposal[0];
        }
        this.setPrefixes(this.currentLocation);
        ICompletionProposal[] result = null;
        if (this.currentLocation.equals(OUTSIDE_RULE)) {
            if (!(this.propertyPrefix == null || this.propertyPrefix.equals("") || previousChar != ' ' && previousChar != '\t')) {
                return new ICompletionProposal[0];
            }
            result = this.getElementCompletionProposals(this.propertyPrefix, previousChar, currentLexeme);
            CSSContentAssistProcessor.setSelection((String)this.propertyPrefix, (ICompletionProposal[])result);
            return result;
        }
        if (this.currentLocation.equals(INSIDE_RULE) && (activationChar != ' ' && activationChar != '\t' || previousChar == DEFAULT_CHARACTER)) {
            boolean addColon = this.addColon(currentLexeme, lexemeList);
            boolean colonPref = CSSContentAssistProcessor.insertColon(this.getPreferenceStore());
            result = this.getAllPropertiesCompletionProposals(this.propertyPrefix, currentLexeme, addColon && colonPref);
            CSSContentAssistProcessor.setSelection((String)this.propertyPrefix.toLowerCase(), (ICompletionProposal[])result);
            return result;
        }
        if (this.currentLocation.equals(ARG_ASSIST)) {
            result = this.getSpecificPropertyCompletionProposals(offset, this.propertyPrefix, this.valuePrefix, currentLexeme, lexemeList);
            CSSContentAssistProcessor.setSelectionUnsorted((String)this.valuePrefix, (ICompletionProposal[])result);
            if (result.length == 0) {
                if (this.unifiedViewer != null) {
                    ((SourceViewer)this.unifiedViewer).doOperation(14);
                    return result;
                }
            } else {
                return result;
            }
        }
        return result;
    }

    public void setPrefixes(String location) {
        this.propertyPrefix = "";
        this.valuePrefix = "";
        if (!this.lexemeHash.equals("")) {
            if (location.equals(OUTSIDE_RULE)) {
                if (this.lexemeHash.indexOf(COLON) < 0) {
                    this.propertyPrefix = this.lexemeHash;
                } else {
                    String[] lexemes = this.lexemeHash.split(COLON);
                    this.propertyPrefix = lexemes[lexemes.length - 1];
                }
            } else if (this.lexemeHash.indexOf(COLON) < 0) {
                this.propertyPrefix = this.lexemeHash;
            } else {
                String[] lexemes = this.lexemeHash.split(COLON);
                if (lexemes.length > 0) {
                    this.propertyPrefix = lexemes[0];
                    if (lexemes.length > 1) {
                        this.valuePrefix = lexemes[lexemes.length - 1];
                    }
                }
            }
        }
    }

    public String getLocation(int offset, int currentLexemePosition, LexemeList ll, char activationCharacter) {
        if (offset == 0) {
            return OUTSIDE_RULE;
        }
        if (currentLexemePosition < 0) {
            return ERROR;
        }
        String location = OUTSIDE_RULE;
        int position = currentLexemePosition;
        ArrayList<String> currentHash = new ArrayList<String>();
        while (position >= 0) {
            Lexeme prevIdentifier;
            Lexeme curLexeme = ll.get(position);
            if (!curLexeme.getLanguage().equals("text/css")) {
                if (!curLexeme.getLanguage().equals(HTML_MIME_TYPE)) break;
                int start = 0;
                int i = position - 1;
                while (i >= 0) {
                    Lexeme lex = ll.get(i);
                    if (lex.getLanguage().equals(HTML_MIME_TYPE)) {
                        start = i + 1;
                        break;
                    }
                    --i;
                }
                if (position == start) {
                    return INSIDE_RULE;
                }
                int size = position - start;
                String recursiveLocation = this.getLocation(offset, size - 1, new LexemeList(ll.copyRange(start, position - 1)), activationCharacter);
                this.offset = offset - this.lexemeHash.length();
                if (recursiveLocation.equals(OUTSIDE_RULE) || recursiveLocation.equals(ERROR)) {
                    return INSIDE_RULE;
                }
                return recursiveLocation;
            }
            if (curLexeme.getText().startsWith(CSS_ID_PREFIX) || curLexeme.getText().startsWith(CSS_CLASS_PREFIX)) {
                if (curLexeme.getCategoryIndex() == 5) {
                    currentHash.add(0, curLexeme.getText());
                } else if (curLexeme.getCategoryIndex() == 0 && curLexeme.getText().length() == 1) {
                    currentHash.add(0, curLexeme.getText());
                } else if (curLexeme.getCategoryIndex() == 0) {
                    location = ERROR;
                    break;
                }
            }
            if (curLexeme.getCategoryIndex() == 2) {
                currentHash.add(0, curLexeme.getText());
            }
            if (curLexeme.getCategoryIndex() == 5 && curLexeme.typeIndex == 5) {
                currentHash.add(0, curLexeme.getText());
            }
            if (curLexeme.getCategoryIndex() == 3 && curLexeme.typeIndex == 25) {
                currentHash.add(0, curLexeme.getText());
            }
            if (curLexeme.getCategoryIndex() == 0 && curLexeme.getText().startsWith("\"")) {
                currentHash.add(0, curLexeme.getText());
            }
            if (curLexeme.typeIndex == 32) {
                location = OUTSIDE_RULE;
                break;
            }
            if (curLexeme.typeIndex == 29) {
                location = ARG_ASSIST;
                prevIdentifier = CSSContentAssistProcessor.getPreviousLexemeOfType((int)curLexeme.getStartingOffset(), (int[])new int[]{4, 48, 47}, (LexemeList)ll, (boolean)false);
                if (prevIdentifier == null) break;
                currentHash.add(0, prevIdentifier.getText());
                break;
            }
            if (curLexeme.typeIndex == 30) {
                prevIdentifier = CSSContentAssistProcessor.getPreviousLexemeOfType((int)curLexeme.getStartingOffset(), (int[])new int[]{31}, (int[])new int[]{32}, (LexemeList)ll, (boolean)false);
                if (prevIdentifier != null) {
                    location = INSIDE_RULE;
                    break;
                }
                location = ERROR;
                break;
            }
            if (curLexeme.typeIndex == 31) {
                location = INSIDE_RULE;
                break;
            }
            if (curLexeme.typeIndex == 38 && location.equals(OUTSIDE_RULE)) {
                Lexeme prevCurly = CSSContentAssistProcessor.getPreviousLexemeOfType((int)curLexeme.getStartingOffset(), (int[])new int[]{31}, (int[])new int[]{32}, (LexemeList)ll, (boolean)false);
                if (prevCurly == null) break;
                location = INSIDE_RULE;
            }
            --position;
        }
        if (currentHash.size() > 0) {
            this.lexemeHash = StringUtils.join((String)COLON, (String[])currentHash.toArray(new String[currentHash.size()]));
            if (location.equals(ARG_ASSIST) && this.lexemeHash.indexOf(COLON) < 0) {
                this.lexemeHash = String.valueOf(this.lexemeHash) + COLON;
            }
        } else {
            this.lexemeHash = "";
        }
        return location;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.validator;
    }

    public int[] getCompletionProposalIdleActivationTokens() {
        return new int[]{8, 4, 9, 48, 47};
    }

    public String getErrorMessage() {
        return null;
    }

    public ICompletionProposal[] getElementCompletionProposals(String prefix, char activationChar, Lexeme currentLexeme) {
        CSSCompletionProposal cp;
        int cursorPosition;
        String replaceString;
        String displayString;
        String docText;
        Hashtable<String, CSSCompletionProposal> completionProposals = new Hashtable<String, CSSCompletionProposal>();
        String testPrefix = prefix.toLowerCase();
        int beginOffset = this.getOffsetForInsertion(this.offset, currentLexeme);
        String[] em = this.environment.getAllElements();
        int replaceLength = testPrefix.length();
        if (!prefix.startsWith(CSS_CLASS_PREFIX) && !prefix.startsWith(CSS_ID_PREFIX)) {
            int i = 0;
            while (i < em.length) {
                String e = em[i];
                String docText2 = this.environment.getElementDocumentation(e);
                String displayString2 = e;
                String replaceString2 = e;
                int cursorPosition2 = replaceString2.length();
                Image[] userAgents = null;
                userAgents = CSSContentAssistProcessor.getUserAgentImages((String[])CSSContentAssistProcessor.getUserAgents(), (String[])this.environment.getUserAgentPlatformNames(e));
                CSSCompletionProposal cp2 = new CSSCompletionProposal(replaceString2, beginOffset, replaceLength, cursorPosition2, fIconTag, displayString2, null, docText2, 1, this.unifiedViewer, userAgents);
                completionProposals.put(displayString2, cp2);
                ++i;
            }
        }
        String path = this.getEditorContentsPath();
        Collection<String> ids = CSSLanguageEnvironment.getInstance().getIds(path, "");
        Collection<String> classes = CSSLanguageEnvironment.getInstance().getClasses(path, "");
        if (ids != null) {
            for (String e : ids) {
                if ("".equals(e)) continue;
                String trimmedValue = CSS_ID_PREFIX + StringUtils.trimStringQuotes((String)e);
                docText = StringUtils.format((String)Messages.CSSContentAssistProcessor_IDSelectorDescription, (Object[])new String[]{trimmedValue, e, this.AUTO_ADDED});
                displayString = trimmedValue;
                replaceString = trimmedValue;
                cursorPosition = replaceString.length();
                cp = new CSSCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconTagGuess, displayString, null, docText, 1, this.unifiedViewer, CSSContentAssistProcessor.getAllUserAgentImages((String[])CSSContentAssistProcessor.getUserAgents()));
                completionProposals.put(displayString, cp);
            }
        }
        if ((classes == null || classes.size() == 0) && prefix.startsWith(CSS_CLASS_PREFIX)) {
            return new ICompletionProposal[0];
        }
        if (classes != null) {
            for (String e : classes) {
                String trimmedValue = CSS_CLASS_PREFIX + StringUtils.trimStringQuotes((String)e);
                docText = StringUtils.format((String)Messages.CSSContentAssistProcessor_ClassSelectorDescription, (Object[])new String[]{trimmedValue, e, this.AUTO_ADDED});
                displayString = trimmedValue;
                replaceString = trimmedValue;
                cursorPosition = replaceString.length();
                cp = new CSSCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconTagGuess, displayString, null, docText, 1, this.unifiedViewer, CSSContentAssistProcessor.getAllUserAgentImages((String[])CSSContentAssistProcessor.getUserAgents()));
                completionProposals.put(displayString, cp);
            }
        }
        ICompletionProposal[] result = completionProposals.values().toArray(new ICompletionProposal[completionProposals.size()]);
        Arrays.sort(result, this.contentAssistComparator);
        return result;
    }

    private String getEditorContentsPath() {
        IEditorInput pathEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        if (pathEditor instanceof IFileEditorInput) {
            IFileEditorInput fileEI = (IFileEditorInput)pathEditor;
            return fileEI.getFile().getProject().getFullPath().toPortableString();
        }
        return null;
    }

    public ICompletionProposal[] getSpecificPropertyCompletionProposals(int offset, String propertyName, String valueName, Lexeme currentLexeme, LexemeList lexemeList) {
        ValueMetadata value;
        boolean isColor;
        String propertyNameLower;
        if (valueName.startsWith("url(")) {
            return this.getFilePathCompletionProposals(valueName, offset, 0);
        }
        if (currentLexeme.getText().startsWith("url(")) {
            return this.getFilePathCompletionProposals(currentLexeme.getText(), offset, 0);
        }
        Lexeme lexeme = currentLexeme;
        String valueString = valueName;
        ArrayList<CSSCompletionProposal> completionProposals = new ArrayList<CSSCompletionProposal>();
        ArrayList<ValueMetadata> addedFields = new ArrayList<ValueMetadata>();
        Hashtable fields = this.environment.getGlobalFields();
        FieldMetadata fm = (FieldMetadata)fields.get(propertyNameLower = propertyName.toLowerCase());
        if (fm == null) {
            return new ICompletionProposal[0];
        }
        HashMap<String, Image> colors = new HashMap<String, Image>();
        boolean bl = isColor = fm.getName().equals("background-color") || fm.getName().equals("color");
        if (isColor) {
            fm.getValues().clear();
            for (Image image : colors.values()) {
                image.dispose();
            }
            colors.clear();
            Collection<String> colorsUsedInProject = this.getColorsUsed();
            for (String color : colorsUsedInProject) {
                if (colors.containsKey(color)) continue;
                value = new ValueMetadata();
                value.setName(color);
                fm.addValue(value);
                colors.put(color, CSSColors.toImage(color, 16, 16));
            }
        }
        if (offset > lexeme.getEndingOffset() && fm.getAllowMultipleValues()) {
            lexeme = null;
            valueString = "";
        }
        int beginOffset = this.getOffsetForInsertion(offset, lexeme);
        boolean insertSemicolonPref = CSSContentAssistProcessor.insertSemicolon(this.getPreferenceStore());
        int i = 0;
        while (i < fm.getValues().size()) {
            CSSCompletionProposal cp;
            value = (ValueMetadata)fm.getValues().get(i);
            String docText = "";
            docText = MetadataEnvironment.getValueDocumentation((ValueMetadata)value);
            String replaceString = value.getName();
            String displayString = value.getName();
            if (replaceString.equals(VALUE_PROPOSAL_ALL)) {
                replaceString = "";
            } else if (!fm.getAllowMultipleValues() && insertSemicolonPref) {
                replaceString = this.addSemicolonIfNecessary(replaceString, lexemeList, currentLexeme);
            }
            int cursorPosition = replaceString.length();
            int replaceLength = valueString.length();
            Image[] userAgents = null;
            userAgents = value.getUserAgents().length == 0 ? CSSContentAssistProcessor.getUserAgentImages((String[])CSSContentAssistProcessor.getUserAgents(), (String[])fm.getUserAgentPlatformNames()) : CSSContentAssistProcessor.getUserAgentImages((String[])CSSContentAssistProcessor.getUserAgents(), (String[])value.getUserAgentPlatformNames());
            Image icon = fIconField;
            if (isColor) {
                icon = (Image)colors.get(value.getName());
            }
            if ((cp = new CSSCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, icon, displayString, null, docText, 1, this.unifiedViewer, userAgents)) != null && !addedFields.contains(value)) {
                addedFields.add(value);
                completionProposals.add(cp);
            }
            ++i;
        }
        ICompletionProposal[] result = completionProposals.toArray(new ICompletionProposal[completionProposals.size()]);
        return result;
    }

    private Collection<String> getColorsUsed() {
        return CSSLanguageEnvironment.getInstance().getColors(this.getEditorContentsPath(), "");
    }

    private String addSemicolonIfNecessary(String replaceString, LexemeList lexemeList, Lexeme currentLexeme) {
        int currentPosition = lexemeList.getLexemeIndex(currentLexeme);
        if (lexemeList.size() <= currentPosition + 1) {
            return String.valueOf(replaceString) + ";";
        }
        Lexeme next = lexemeList.get(currentPosition + 1);
        if (next != null && next.typeIndex == 30) {
            return replaceString;
        }
        return String.valueOf(replaceString) + ";";
    }

    public int getOffsetForInsertion(int offset, Lexeme currentLexeme) {
        if (currentLexeme == null) {
            return offset;
        }
        int beginOffset = offset;
        if (!currentLexeme.getLanguage().equals("text/css")) {
            return offset;
        }
        if (currentLexeme.typeIndex == 4 || currentLexeme.typeIndex == 47 || currentLexeme.typeIndex == 48 || currentLexeme.getCategoryIndex() == 5 || currentLexeme.getCategoryIndex() == 0) {
            beginOffset = currentLexeme.getStartingOffset();
        }
        return beginOffset;
    }

    public boolean addColon(Lexeme currentLexeme, LexemeList lexemeList) {
        Lexeme sibling;
        if (currentLexeme == null) {
            return false;
        }
        int lexemeIndex = lexemeList.getLexemeIndex(currentLexeme);
        return lexemeIndex < lexemeList.size() - 1 && (sibling = lexemeList.get(lexemeIndex + 1)) != null && sibling.typeIndex != 29;
    }

    public ICompletionProposal[] getAllPropertiesCompletionProposals(String prefix, Lexeme currentLexeme, boolean addColon) {
        Hashtable<String, CSSCompletionProposal> completionProposals = new Hashtable<String, CSSCompletionProposal>();
        Hashtable fields = this.environment.getGlobalFields();
        Collection vals = fields.values();
        Iterator iter = vals.iterator();
        String testPrefix = prefix.toLowerCase();
        int beginOffset = this.getOffsetForInsertion(this.offset, currentLexeme);
        while (iter.hasNext()) {
            Image[] userAgents;
            FieldMetadata fm = (FieldMetadata)iter.next();
            String docText = "";
            docText = this.environment.getFieldDocumentation(fm);
            String replaceString = fm.getName();
            if (addColon) {
                replaceString = String.valueOf(replaceString) + COLON;
            }
            String displayString = fm.getName();
            int cursorPosition = replaceString.length();
            int replaceLength = testPrefix.length();
            CSSCompletionProposal cp = new CSSCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconField, displayString, null, docText, 1, this.unifiedViewer, userAgents = CSSContentAssistProcessor.getUserAgentImages((String[])CSSContentAssistProcessor.getUserAgents(), (String[])fm.getUserAgentPlatformNames()));
            if (cp == null) continue;
            completionProposals.put(fm.getName(), cp);
        }
        ICompletionProposal[] result = completionProposals.values().toArray(new ICompletionProposal[completionProposals.size()]);
        Arrays.sort(result, this.contentAssistComparator);
        return result;
    }

    public CSSOffsetMapper getCSSOffsetMapper() {
        return (CSSOffsetMapper)this.getOffsetMapper();
    }

    public IOffsetMapper getOffsetMapper() {
        IFileLanguageService ls = this.context.getLanguageService("text/css");
        if (ls != null) {
            return ls.getOffsetMapper();
        }
        return null;
    }

    public Lexeme getCurrentLexeme(int offset) {
        this.getOffsetMapper().calculateCurrentLexeme(offset);
        Lexeme currentLexeme = this.getOffsetMapper().getCurrentLexeme();
        return currentLexeme;
    }

    protected IPreferenceStore getPreferenceStore() {
        if (PluginUtils.isPluginLoaded((Plugin)CSSPlugin.getDefault())) {
            return CSSPlugin.getDefault().getPreferenceStore();
        }
        return null;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public String getValuePrefix() {
        return this.valuePrefix;
    }

    public IContextInformation[] computeInnerContextInformation(String documentSource, int offset, int position, LexemeList lexemeList) {
        ContextInformation ci;
        String propertyNameLower;
        IContextInformation[] ici = null;
        if (this.propertyPrefix == null) {
            return new IContextInformation[0];
        }
        Hashtable fields = this.environment.getGlobalFields();
        FieldMetadata fm = (FieldMetadata)fields.get(propertyNameLower = this.propertyPrefix.toLowerCase());
        if (fm == null) {
            return new IContextInformation[0];
        }
        String hint = fm.getDescription();
        if (fm.getHint() != null) {
            hint = fm.getHint();
        }
        if (hint == null) {
            hint = Messages.CSSContentAssistProcessor_NoHintAvailable;
        }
        if ((ci = new ContextInformation("contextDisplayString", StringUtils.format((String)Messages.CSSContentAssistProcessor_ContextHint, (Object[])new String[]{fm.getName(), hint}))) != null) {
            ici = new IContextInformation[]{ci};
        }
        return ici;
    }

    public static boolean insertColon(IPreferenceStore store) {
        if (store != null) {
            return store.getBoolean("com.aptana.ide.editor.css.CSSEDITOR_INSERT_COLON");
        }
        return false;
    }

    public static boolean insertSemicolon(IPreferenceStore store) {
        if (store != null) {
            return store.getBoolean("com.aptana.ide.editor.css.CSSEDITOR_INSERT_SEMICOLON");
        }
        return false;
    }

    public Comparator<ICompletionProposal> getProposalComparator() {
        return this.contentAssistComparator;
    }

    private ICompletionProposal[] getFilePathCompletionProposals(String valuePrefix, int beginOffset, int replaceLength) {
        File[] files;
        ArrayList<CSSCompletionProposal> completionProposals = new ArrayList<CSSCompletionProposal>();
        IEditorInput pathEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        String urlPrefix = null;
        if (pathEditor instanceof IFileEditorInput) {
            urlPrefix = this.getProjectContextRoot((IFileEditorInput)pathEditor);
        }
        String editorPath = CoreUIUtils.getPathFromEditorInput((IEditorInput)pathEditor);
        String basePath = new Path(CoreUIUtils.getPathFromEditorInput((IEditorInput)pathEditor)).removeLastSegments(1).toOSString();
        if (urlPrefix != null && !"".equals(urlPrefix)) {
            basePath = urlPrefix;
        }
        String currentPath = basePath;
        if (valuePrefix != null) {
            String s;
            if (valuePrefix.startsWith("url(")) {
                valuePrefix = valuePrefix.substring(4);
            }
            if (valuePrefix.endsWith(")")) {
                valuePrefix = valuePrefix.substring(0, valuePrefix.length() - 1);
            }
            if (!"".equals(s = StringUtils.trimStringQuotes((String)valuePrefix))) {
                beginOffset -= s.length();
                replaceLength += s.length();
                File current = new File(currentPath);
                if (current.isDirectory()) {
                    if (currentPath.endsWith(File.separator)) {
                        currentPath = currentPath.substring(0, currentPath.length() - 1);
                    }
                    currentPath = String.valueOf(currentPath) + s;
                } else {
                    currentPath = String.valueOf(current.getParent().toString()) + File.separator + s;
                }
            }
        }
        if ((files = FileUtils.getFilesInDirectory((File)new File(currentPath))) == null) {
            return new ICompletionProposal[0];
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.getName().startsWith(CSS_CLASS_PREFIX) && !f.toString().equals(editorPath)) {
                Image image = this.getImage(f);
                String replaceString = FileUtils.makeFilePathRelative((File)new File(basePath), (File)f);
                replaceString = replaceString.replaceAll("\\\\", "/");
                String displayString = CoreUIUtils.getPathFromURI((String)replaceString);
                int cursorPosition = replaceString.length();
                CSSCompletionProposal cp = new CSSCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, image, displayString, null, f.toString(), 1, this.unifiedViewer, new Image[0]);
                if (cp != null) {
                    completionProposals.add(cp);
                }
            }
            ++n2;
        }
        return completionProposals.toArray(new ICompletionProposal[0]);
    }

    private Image getImage(File f) {
        String fileType = "";
        try {
            fileType = FileSystemView.getFileSystemView().getSystemTypeDescription(f);
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"FIXME!!!!", (Throwable)ex);
        }
        Image image = null;
        if (fileType != null) {
            image = (Image)ImageUtils.fileIconsHash.get(fileType);
        }
        if (image == null) {
            image = fIconFile;
            if (f.isDirectory()) {
                image = fIconFolder;
            }
        }
        return image;
    }

    private String getProjectContextRoot(IFileEditorInput input) {
        String urlPrefix = "/";
        IFile file = input.getFile();
        IProject project = file.getProject();
        try {
            String contextRoot = project.getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.CONTEXT_ROOT"));
            if (contextRoot != null && !contextRoot.equals("/")) {
                urlPrefix = String.valueOf(contextRoot) + "/";
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project.getLocation().append(urlPrefix).toOSString();
    }
}

