/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.css.CSSErrorManager;
import com.aptana.ide.editor.css.CSSFileLanguageService;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.Messages;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.BaseFileServiceFactory;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.editors.unified.errors.IErrorManager;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import org.eclipse.core.runtime.Plugin;

public final class CSSFileServiceFactory
extends BaseFileServiceFactory {
    private static CSSFileServiceFactory instance;

    private CSSFileServiceFactory() {
    }

    protected IParser createScanner() {
        IParser result = null;
        if (UnifiedEditorsPlugin.getDefault().useFastScan()) {
            result = LanguageRegistry.getScanner((String)"text/css");
        }
        return result;
    }

    public static CSSFileServiceFactory getInstance() {
        if (instance == null) {
            instance = new CSSFileServiceFactory();
        }
        return instance;
    }

    public FileService createFileService(IFileSourceProvider sourceProvider, boolean parse) {
        IParser parser = this.createParser();
        IParser scanner = this.createScanner();
        IParseState parseState = parser.createParseState(null);
        FileService fileService = new FileService(parser, parseState, sourceProvider, "text/css");
        fileService.setScanner(scanner);
        fileService.setErrorManager((IErrorManager)new CSSErrorManager(fileService));
        ParentOffsetMapper parentMapper = new ParentOffsetMapper(fileService);
        CSSFileLanguageService languageService = new CSSFileLanguageService(fileService, parseState, parser, (IParentOffsetMapper)parentMapper);
        fileService.addLanguageService("text/css", (IFileLanguageService)languageService);
        if (parse) {
            fileService.doFullParse();
        }
        return fileService;
    }

    protected IParser createParser() {
        IParser parser = LanguageRegistry.getParser((String)"text/css");
        if (parser == null) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)StringUtils.format((String)Messages.CSSFileServiceFactory_ERR_UnableToCreateParser, (String)"text/css"));
        }
        return parser;
    }
}

