/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSSColors {
    private static Map<String, String> NAMED_COLORS = new HashMap<String, String>();

    static {
        NAMED_COLORS.put("aqua", "#00FFFF");
        NAMED_COLORS.put("black", "#000000");
        NAMED_COLORS.put("blue", "#0000FF");
        NAMED_COLORS.put("fuchsia", "#FF00FF");
        NAMED_COLORS.put("gray", "#808080");
        NAMED_COLORS.put("green", "#008000");
        NAMED_COLORS.put("lime", "#00FF00");
        NAMED_COLORS.put("maroon", "#800000");
        NAMED_COLORS.put("navy", "#000080");
        NAMED_COLORS.put("olive", "#808000");
        NAMED_COLORS.put("purple", "#800080");
        NAMED_COLORS.put("red", "#FF0000");
        NAMED_COLORS.put("silver", "#C0C0C0");
        NAMED_COLORS.put("teal", "#008080");
        NAMED_COLORS.put("white", "#FFFFFF");
        NAMED_COLORS.put("yellow", "#FFFF00");
    }

    public static boolean namedColorExists(String colorName) {
        return NAMED_COLORS.containsKey(colorName);
    }

    private static String getHexValueForName(String colorName) {
        return NAMED_COLORS.get(colorName);
    }

    public static Set<String> getNamedColors() {
        return Collections.unmodifiableSet(NAMED_COLORS.keySet());
    }

    private static RGB toRGB(String color) {
        if (CSSColors.namedColorExists(color.toLowerCase())) {
            color = CSSColors.getHexValueForName(color.toLowerCase());
        }
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        if (color.length() == 3) {
            int red = Integer.decode("#" + color.substring(0, 1) + color.substring(0, 1));
            int green = Integer.decode("#" + color.substring(1, 2) + color.substring(1, 2));
            int blue = Integer.decode("#" + color.substring(2, 3) + color.substring(2, 3));
            return new RGB(red, green, blue);
        }
        int red = Integer.decode("#" + color.substring(0, 2));
        int green = Integer.decode("#" + color.substring(2, 4));
        int blue = Integer.decode("#" + color.substring(4, 6));
        return new RGB(red, green, blue);
    }

    public static String to6CharHexWithLeadingHash(String color) {
        if (CSSColors.namedColorExists(color.toLowerCase())) {
            return CSSColors.getHexValueForName(color.toLowerCase());
        }
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        if (color.length() == 3) {
            return ("#" + color.charAt(0) + color.charAt(0) + color.charAt(1) + color.charAt(1) + color.charAt(2) + color.charAt(2)).toUpperCase();
        }
        return "#" + color.toUpperCase();
    }

    public static Image toImage(String color, int height, int width) {
        RGB actualColor = CSSColors.toRGB(color);
        PaletteData paletteData = new PaletteData(new RGB[]{actualColor, new RGB(0, 0, 0)});
        ImageData imageData = new ImageData(16, 16, 1, paletteData);
        return new Image((Device)Display.getDefault(), imageData);
    }
}

