/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.pathtools;

import com.aptana.ide.pathtools.Activator;
import com.aptana.ide.pathtools.Messages;
import com.aptana.ide.pathtools.handlers.Utilities;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public class ExplorePlacesActions
implements IWorkbenchWindowPulldownDelegate2 {
    private Menu explorePlacesMenu;

    public void dispose() {
        if (this.explorePlacesMenu != null) {
            this.explorePlacesMenu.dispose();
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        URL url;
        Location installLocation;
        URL url2;
        Location userDataLocation;
        URL url3;
        if (this.explorePlacesMenu != null) {
            this.explorePlacesMenu.dispose();
        }
        this.explorePlacesMenu = new Menu(parent);
        final IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        MenuItem gotoWorkspace = new MenuItem(this.explorePlacesMenu, 8);
        gotoWorkspace.setText(MessageFormat.format(Messages.ExplorePlacesActions_TXT_WorkspaceFolder, workspaceLocation.toFile().getAbsolutePath()));
        gotoWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExplorePlacesActions.openFolder(workspaceLocation.toFile());
            }
        });
        MenuItem gotoWorkspaceMetadata = new MenuItem(this.explorePlacesMenu, 8);
        gotoWorkspaceMetadata.setText(MessageFormat.format(Messages.ExplorePlacesActions_TXT_WorkspaceMetadata, workspaceLocation.toFile().getAbsolutePath(), File.separator));
        gotoWorkspaceMetadata.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExplorePlacesActions.openFolder(new File(workspaceLocation.toFile(), ".metadata"));
            }
        });
        Location configurationLocation = Platform.getConfigurationLocation();
        if (configurationLocation != null && (url3 = configurationLocation.getURL()) != null && new File(url3.getFile()).exists()) {
            MenuItem gotoConfigurationFolder = new MenuItem(this.explorePlacesMenu, 8);
            gotoConfigurationFolder.setText(MessageFormat.format(Messages.ExplorePlacesActions_TXT_ConfigFolder, url3.getFile()));
            gotoConfigurationFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExplorePlacesActions.openFolder(new File(url3.getFile()));
                }
            });
        }
        if ((userDataLocation = Platform.getUserLocation()) != null && (url2 = userDataLocation.getURL()) != null && new File(url2.getFile()).exists()) {
            MenuItem gotoUserFolder = new MenuItem(this.explorePlacesMenu, 8);
            gotoUserFolder.setText(MessageFormat.format(Messages.ExplorePlacesActions_TXT_UserDataFolder, url2.getFile()));
            gotoUserFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExplorePlacesActions.openFolder(new File(url2.getFile()));
                }
            });
        }
        if ((installLocation = Platform.getInstallLocation()) != null && (url = installLocation.getURL()) != null && new File(url.getFile()).exists()) {
            MenuItem gotoInstallFolder = new MenuItem(this.explorePlacesMenu, 8);
            gotoInstallFolder.setText(MessageFormat.format(Messages.ExplorePlacesActions_TXT_InstallFolder, url.getFile()));
            gotoInstallFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExplorePlacesActions.openFolder(new File(url.getFile()));
                }
            });
        }
        return this.explorePlacesMenu;
    }

    private static void openFolder(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            Utilities.launch(Activator.getDefault().getPreferenceStore().getString("folderExploreCommand"), file);
        }
    }
}

