/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.pathtools;

import com.aptana.ide.pathtools.Activator;
import com.aptana.ide.pathtools.handlers.Utilities;
import com.aptana.ide.ui.io.FileSystemUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyPathAction
implements IViewActionDelegate,
IObjectActionDelegate {
    private List<File> files = new LinkedList<File>();
    private List<IPath> resourcePaths = new LinkedList<IPath>();
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IViewPart view) {
        this.window = view.getViewSite().getWorkbenchWindow();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        CopyPathAction.copyToClipboard(Activator.getDefault().getPreferenceStore().getString("lastCopyPathFormat"), this.files);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        File file;
        IFileEditorInput fileEditorInput;
        IFile iFile;
        ITextEditor abstractTextEditor;
        IEditorInput editorInput;
        IWorkbenchPart activeEditor;
        IWorkbenchPage activePage;
        this.files.clear();
        this.resourcePaths.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object firstElement : structuredSelection) {
                File file2;
                IPath fullPath = null;
                IPath location = null;
                if (firstElement instanceof IResource) {
                    IResource resource = (IResource)firstElement;
                    location = resource.getLocation();
                    fullPath = resource.getFullPath();
                } else if (firstElement instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)firstElement;
                    IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                    if (resource != null) {
                        location = resource.getLocation();
                        fullPath = resource.getFullPath();
                    } else {
                        IFileStore fileStore = FileSystemUtils.getFileStore((Object)adaptable);
                        try {
                            File file3 = fileStore.toLocalFile(0, null);
                            if (file3 != null) {
                                this.files.add(file3);
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                if (location != null && (file2 = location.toFile()) != null) {
                    this.files.add(file2);
                }
                if (fullPath == null) continue;
                this.resourcePaths.add(fullPath);
            }
        }
        if (this.files.size() == 0 && this.window != null && (activePage = this.window.getActivePage()) != null && (activeEditor = activePage.getActivePart()) instanceof ITextEditor && (editorInput = (abstractTextEditor = (ITextEditor)activeEditor).getEditorInput()) instanceof IFileEditorInput && (iFile = (fileEditorInput = (IFileEditorInput)editorInput).getFile()) != null && (file = iFile.getLocation().toFile()) != null) {
            this.files.add(file);
            this.resourcePaths.add(iFile.getFullPath());
        }
        action.setEnabled(this.files.size() > 0);
    }

    private static void copyToClipboard(String pathFormat, List<File> files) {
        if (files.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (File file : files) {
                stringBuilder.append(String.valueOf(Utilities.formatCommand(pathFormat, file)) + (files.size() > 1 ? System.getProperty("line.separator", "\n") : ""));
            }
            CopyPathAction.copyToClipboard(stringBuilder.toString());
        }
    }

    private static void copyToClipboard(String string) {
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());
        clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
    }
}

