/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.wizards;

import com.aptana.ide.librarymanager.LibraryInfo;
import com.aptana.ide.librarymanager.LibraryManager;
import com.aptana.ide.wizards.LibraryProjectWizard;
import com.aptana.ide.wizards.LibraryWizardPage;
import com.aptana.ide.wizards.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class LibraryImportWizard
extends Wizard
implements IImportWizard {
    LibraryWizardPage page;
    IProject _project;

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    LibraryImportWizard.this.createProject((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void createProject(IProgressMonitor monitor) {
        if (this._project != null && this.page.getSelectedLibraries().length > 0) {
            LibraryProjectWizard.copyLibraryFiles(monitor, this._project, this.page.getSelectedLibraries());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection s) {
        Object firstItem = s.getFirstElement();
        if (firstItem instanceof IProject) {
            this._project = (IProject)firstItem;
        } else {
            this._project = null;
            MessageDialog.openInformation((Shell)workbench.getActiveWorkbenchWindow().getShell(), (String)Messages.LibraryImportWizard_ImportJavaScriptLibrary, (String)Messages.LibraryImportWizard_CanOnlyImportIntoTopLevel);
        }
    }

    public void addPages() {
        if (this._project != null) {
            super.addPages();
            IStructuredContentProvider provider = new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return LibraryManager.getInstance().getLibraryInfoExtensions();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
            ILabelProvider labelProvider = new ILabelProvider(){

                public Image getImage(Object element) {
                    String iconFile;
                    Image result = null;
                    if (element instanceof LibraryInfo && (iconFile = ((LibraryInfo)element).getIconFile()) != null && iconFile.length() > 0) {
                        File file = new File(iconFile);
                        result = new Image((Device)Display.getDefault(), file.getAbsolutePath());
                    }
                    return result;
                }

                public String getText(Object element) {
                    return element.toString();
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
            this.page = new LibraryWizardPage(Messages.LibraryImportWizard_JavaScriptLibraries, provider, labelProvider);
            this.page.setTitle(Messages.LibraryImportWizard_ImportJavaScriptLibrary);
            this.page.setDescription(Messages.LibraryImportWizard_ImportLibraryDescription);
            this.addPage((IWizardPage)this.page);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.page != null) {
            this.page.dispose();
        }
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor((String)"wizban/newprj_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
    }
}

